/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ainpl.core.nlp;

import com.els.modules.ainpl.core.nlp.ModelInfo;
import com.els.modules.ainpl.core.nlp.OrderCreationMatchingAlgorithm;
import com.els.modules.ainpl.core.nlp.OrderCreationModelMatchingService;
import com.els.modules.ainpl.service.AiOrderCreationModelHeadService;
import com.hankcs.hanlp.HanLP;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HanLpOrderCreationModelMatchingServiceImpl
implements OrderCreationModelMatchingService {
    @Autowired
    private OrderCreationMatchingAlgorithm matchingAlgorithm;
    @Autowired
    private AiOrderCreationModelHeadService aiOrderCreationModelHeadService;

    @Override
    public String matchModel(String queryText) {
        List<ModelInfo> allModels;
        List terms = HanLP.segment((String)queryText);
        List<String> questionWords = terms.stream().map(term -> term.word).collect(Collectors.toList());
        List<ModelInfo> nameMatchedModels = this.matchByModelName(questionWords, allModels = this.aiOrderCreationModelHeadService.getAllModels());
        if (nameMatchedModels.size() == 1) {
            return nameMatchedModels.get(0).getModelId();
        }
        List<ModelInfo> candidateModels = nameMatchedModels.isEmpty() ? allModels : nameMatchedModels;
        return this.matchByFieldSpec(questionWords, candidateModels);
    }

    private List<ModelInfo> matchByModelName(List<String> questionWords, List<ModelInfo> models) {
        return models.stream().filter(model -> questionWords.stream().anyMatch(word -> model.getModelName().contains((CharSequence)word))).collect(Collectors.toList());
    }

    private String matchByFieldSpec(List<String> questionWords, List<ModelInfo> models) {
        HashMap<String, Double> modelScores = new HashMap<String, Double>();
        for (ModelInfo model : models) {
            double score = this.matchingAlgorithm.calculateModelMatchingScore(questionWords, model);
            modelScores.put(model.getModelId(), score);
        }
        return modelScores.entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElse(null);
    }
}

