/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core.agent.run;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.els.common.exception.ELSBootException;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.ai.core.agent.run.AbstractRunStrategy;
import com.els.modules.ai.core.modelStrategy.AiLogicRunStrategy;
import com.els.modules.ai.core.util.AiBeanFactory;
import com.els.modules.ai.entity.AiAgentAppConfigItem;
import com.els.modules.ai.pojo.AiChatAppPojo;
import com.els.modules.ai.pojo.AiChatExamplarPojo;
import com.els.modules.ai.pojo.AiChatModelConfigPojo;
import com.els.modules.ai.pojo.AiChatPojo;
import com.els.modules.ai.pojo.LlmRequestPojo;
import com.els.modules.ai.pojo.LlmResponsePojo;
import com.els.modules.ai.pojo.QuestionInfoPojo;
import com.els.modules.ai.service.AiChatAppService;
import com.els.modules.ai.service.AiChatExamplarService;
import com.els.modules.ai.service.AiChatModelConfigService;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class AgentAiRequestService
extends AbstractRunStrategy {
    @Override
    public LlmResponsePojo doExecute(LlmRequestPojo llmRequest, AiAgentAppConfigItem config) {
        AiChatPojo chatDto = llmRequest.getAiChatPojo();
        if (null == chatDto) {
            throw new ELSBootException("\u8c03\u7528\u7684APP\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        AiChatAppPojo chatAppConfig = ((AiChatAppService)SpringContextUtils.getBean(AiChatAppService.class)).loadAiChatAppByCode(chatDto.getAppCode(), SysUtil.getLoginUser().getElsAccount());
        chatDto.setLanguage("zh");
        chatDto.setCurrentDate(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        QuestionInfoPojo questionInfo = chatDto.getQuestion();
        if (CharSequenceUtil.isEmpty((CharSequence)questionInfo.getQuestion())) {
            questionInfo.setQuestion(chatAppConfig.getQuestion());
        }
        List<AiChatExamplarPojo> chatExamplers = ((AiChatExamplarService)SpringContextUtils.getBean(AiChatExamplarService.class)).loadExamplersByCode(chatDto.getAppCode(), chatAppConfig.getElsAccount());
        llmRequest.setAiChatPojo(chatDto);
        llmRequest.setAiChatAppPojo(chatAppConfig);
        llmRequest.setChatExamplers(chatExamplers);
        AiChatModelConfigPojo aiChatModelConfigDto = ((AiChatModelConfigService)SpringContextUtils.getBean(AiChatModelConfigService.class)).loadModelConfigByProvider(chatAppConfig.getModelProvider(), chatAppConfig.getModelName(), chatAppConfig.getElsAccount());
        chatAppConfig.setAiChatModelConfigPojo(aiChatModelConfigDto);
        AiLogicRunStrategy runStrategy = AiBeanFactory.getAiLogicRunStrategy(chatAppConfig.getModelRunStrategy());
        LlmResponsePojo result = runStrategy.generate(llmRequest);
        result.setQuestion(questionInfo.getQuestion());
        result.setLlmRequestPojo(llmRequest);
        return result;
    }

    @Override
    public String type() {
        return "default";
    }
}

