/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ainpl.core.nlp;

import com.els.modules.ai.pojo.AiOrderCreationFiledSchemaPojo;
import com.els.modules.ainpl.core.nlp.AiOrderCreationModelProperties;
import com.els.modules.ainpl.core.nlp.NlpProcessor;
import com.els.modules.ainpl.core.nlp.SimilarityCalculator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QuestionAnalysisService {
    @Autowired
    private NlpProcessor nlpProcessor;
    @Autowired
    private AiOrderCreationModelProperties aiOrderCreationModelProperties;

    public boolean isQuestionRelevant(List<AiOrderCreationFiledSchemaPojo> schemaList, String question) {
        if (question == null || question.trim().isEmpty()) {
            return false;
        }
        Set<String> protectedTerms = schemaList.stream().map(AiOrderCreationFiledSchemaPojo::getFieldName).collect(Collectors.toSet());
        protectedTerms.addAll(schemaList.stream().flatMap(x -> x.getFieldAlias().stream()).collect(Collectors.toSet()));
        List<String> questionKeywords = this.nlpProcessor.segmentWithCustomDict(question, protectedTerms);
        if (questionKeywords.isEmpty()) {
            return false;
        }
        return schemaList.stream().anyMatch(spec -> this.calculateSpecSimilarity(questionKeywords, (AiOrderCreationFiledSchemaPojo)spec) >= this.aiOrderCreationModelProperties.getSimilarityThreshold());
    }

    private List<AiOrderCreationFiledSchemaPojo> getRelevantSpecs(List<AiOrderCreationFiledSchemaPojo> schemaList, String question) {
        if (!this.isQuestionRelevant(schemaList, question)) {
            return Collections.emptyList();
        }
        List<String> questionKeywords = this.nlpProcessor.extractKeywords(question);
        return schemaList.stream().filter(spec -> this.calculateSpecSimilarity(questionKeywords, (AiOrderCreationFiledSchemaPojo)spec) >= this.aiOrderCreationModelProperties.getSimilarityThreshold()).sorted((s1, s2) -> Double.compare(this.calculateSpecSimilarity(questionKeywords, (AiOrderCreationFiledSchemaPojo)s2), this.calculateSpecSimilarity(questionKeywords, (AiOrderCreationFiledSchemaPojo)s1))).collect(Collectors.toList());
    }

    private double calculateSpecSimilarity(List<String> questionKeywords, AiOrderCreationFiledSchemaPojo spec) {
        ArrayList<String> specTokens = new ArrayList<String>();
        specTokens.add(spec.getFieldName());
        specTokens.addAll(spec.getFieldAlias());
        return SimilarityCalculator.cosineSimilarity(questionKeywords, specTokens);
    }
}

