/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.job;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.service.JobRpcService;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="tableEntityScannerJob")
public class TableEntityScannerJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(TableEntityScannerJob.class);
    private final String LOCK_PREFIX = "tableEntityScannerJob";
    private final long EXPIRE_TIME = 50000L;
    @Autowired
    private RedisUtil redisUtil;
    @Resource(name="tableEntityRedisTemplate")
    private RedisTemplate<String, Object> tableEntityRedisTemplate;

    public void execute(String parameter) {
        JSONObject jsonObject = JSONObject.parseObject((String)parameter);
        String tableStr = jsonObject.getString("tableList");
        if (CharSequenceUtil.isEmpty((CharSequence)tableStr)) {
            throw new ELSBootException("\u5b57\u6bb5tableList\u8868\u540d\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u9017\u53f7\u5206\u9694\u7684\u8868\u540d\u3002");
        }
        List tableList = Arrays.stream(tableStr.split(",")).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(tableList)) {
            return;
        }
        if (!this.redisUtil.tryGetDistributedLock("tableEntityScannerJob", "tableEntityScannerJob", 50000L)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WFGJOHzXVLSIRc_fdd7aade", (String)"\u6570\u636e\u5e93\u5b57\u6bb5\u957f\u5ea6\u5237\u65b0\u4efb\u52a1\u5df2\u6267\u884c"));
        }
        try {
            this.tableEntityRedisTemplate.convertAndSend("tableEntityRefresh", tableList);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.redisUtil.releaseDistributedLock("tableEntityScannerJob", "tableEntityScannerJob");
        }
    }
}

