/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core.provider;

import com.els.modules.ai.core.provider.AiModelFactory;
import com.els.modules.ai.core.util.AiBeanFactory;
import com.els.modules.ai.core.util.AiUtil;
import com.els.modules.ai.pojo.AiChatModelConfigPojo;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.openai.OpenAiChatModel;
import java.time.Duration;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;

@Service
public class OpenAiModelFactory
implements AiModelFactory,
InitializingBean {
    public static final String PROVIDER = "OPEN_AI";

    @Override
    public ChatLanguageModel createChatModel(AiChatModelConfigPojo modelConfig) {
        return OpenAiChatModel.builder().baseUrl(modelConfig.getBaseUrl()).modelName(modelConfig.getModelName()).apiKey(AiUtil.aesDecryptECB(modelConfig.getApiKey())).temperature(modelConfig.getTemperature()).topP(modelConfig.getTopPn()).store(Boolean.valueOf("1".equals(modelConfig.getStore()))).maxRetries(modelConfig.getMaxRetries()).timeout(Duration.ofSeconds(modelConfig.getTimeOut())).logRequests(Boolean.valueOf("1".equals(modelConfig.getLogRequests()))).logResponses(Boolean.valueOf("1".equals(modelConfig.getLogResponses()))).build();
    }

    public void afterPropertiesSet() {
        AiBeanFactory.registerModelFactories(PROVIDER, this);
    }
}

