/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ainpl.core.nlp;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.dictionary.CustomDictionary;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class NlpProcessor {
    public List<String> segmentWithCustomDict(String queryText, Set<String> protectedTerms) {
        for (String term2 : protectedTerms) {
            if (CustomDictionary.contains((String)term2)) continue;
            CustomDictionary.add((String)term2);
        }
        List terms = HanLP.segment((String)queryText);
        return terms.stream().filter(term -> this.isMeaningfulWord(term.word)).map(term -> term.word).collect(Collectors.toList());
    }

    public List<String> extractKeywords(String text) {
        List terms = HanLP.segment((String)text);
        return terms.stream().filter(term -> this.isMeaningfulWord(term.word)).map(term -> term.word.toLowerCase()).collect(Collectors.toList());
    }

    private boolean isMeaningfulWord(String word) {
        return word.length() > 1 && !word.matches("\\d+");
    }
}

