/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.service.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.barcode.entity.PurchaseBarcodeLevelHead;
import com.els.modules.barcode.entity.PurchaseBarcodeLevelItem;
import com.els.modules.barcode.entity.SaleBarcodeLevelHead;
import com.els.modules.barcode.entity.SaleBarcodeLevelItem;
import com.els.modules.barcode.enumerate.BarcodeLevelStatusEnum;
import com.els.modules.barcode.mapper.SaleBarcodeLevelHeadMapper;
import com.els.modules.barcode.mapper.SaleBarcodeLevelItemMapper;
import com.els.modules.barcode.service.PurchaseBarcodeLevelHeadService;
import com.els.modules.barcode.service.SaleBarcodeLevelHeadService;
import com.els.modules.barcode.service.SaleBarcodeLevelItemService;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.TemplateRpcService;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.system.service.CodeGeneratorService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SaleBarcodeLevelHeadServiceImpl
extends BaseServiceImpl<SaleBarcodeLevelHeadMapper, SaleBarcodeLevelHead>
implements SaleBarcodeLevelHeadService {
    @Autowired
    private SaleBarcodeLevelHeadMapper saleBarcodeLevelHeadMapper;
    @Autowired
    private SaleBarcodeLevelItemMapper saleBarcodeLevelItemMapper;
    @Autowired
    private SaleBarcodeLevelItemService saleBarcodeLevelItemService;
    @Autowired
    private CodeGeneratorService codeGeneratorService;
    @Autowired
    private TemplateRpcService templateHeadService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    @Lazy
    private PurchaseBarcodeLevelHeadService purchaseBarcodeLevelHeadService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(SaleBarcodeLevelHead saleBarcodeLevelHead, List<SaleBarcodeLevelItem> saleBarcodeLevelItemList) {
        ElsEnterpriseInfoDTO enterpriseInfo;
        saleBarcodeLevelHead.setId(IdWorker.getIdStr());
        saleBarcodeLevelHead.setLevelNumber(this.codeGeneratorService.getNextCode("srmBarcodeInfoNumber", (Object)saleBarcodeLevelHead));
        saleBarcodeLevelHead.setLevelStatus(BarcodeLevelStatusEnum.NEW.getValue());
        TemplateHeadDTO templateHead = this.templateHeadService.getById(saleBarcodeLevelHead.getTemplateNumber());
        if (templateHead != null) {
            saleBarcodeLevelHead.setTemplateName(templateHead.getTemplateName());
            saleBarcodeLevelHead.setTemplateNumber(templateHead.getTemplateNumber());
            saleBarcodeLevelHead.setTemplateVersion(templateHead.getTemplateVersion());
            saleBarcodeLevelHead.setTemplateAccount(templateHead.getElsAccount());
        }
        if ((enterpriseInfo = this.invokeAccountRpcService.getByElsAccount(TenantContext.getTenant())) != null) {
            saleBarcodeLevelHead.setSupplierName(enterpriseInfo.getName());
        }
        if ((enterpriseInfo = this.invokeAccountRpcService.getByElsAccount(saleBarcodeLevelHead.getToElsAccount())) != null) {
            saleBarcodeLevelHead.setPurchaseName(enterpriseInfo.getName());
        }
        this.saleBarcodeLevelHeadMapper.insert((Object)saleBarcodeLevelHead);
        this.insertData(saleBarcodeLevelHead, saleBarcodeLevelItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(SaleBarcodeLevelHead saleBarcodeLevelHead, List<SaleBarcodeLevelItem> saleBarcodeLevelItemList) {
        int count = this.saleBarcodeLevelHeadMapper.updateById((Object)saleBarcodeLevelHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        this.saleBarcodeLevelItemMapper.deleteByMainId(saleBarcodeLevelHead.getId());
        this.insertData(saleBarcodeLevelHead, saleBarcodeLevelItemList);
    }

    @Override
    public void publish(SaleBarcodeLevelHead saleBarcodeLevelHead, List<SaleBarcodeLevelItem> saleBarcodeLevelItemList) {
        saleBarcodeLevelHead.setLevelStatus(BarcodeLevelStatusEnum.FINAL.getValue());
        int count = this.saleBarcodeLevelHeadMapper.updateById((Object)saleBarcodeLevelHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        this.saleBarcodeLevelItemMapper.deleteByMainId(saleBarcodeLevelHead.getId());
        this.insertData(saleBarcodeLevelHead, saleBarcodeLevelItemList);
        this.purchaseBarcodeLevelHeadService.addBySale(saleBarcodeLevelHead, saleBarcodeLevelItemList);
    }

    private void insertData(SaleBarcodeLevelHead saleBarcodeLevelHead, List<SaleBarcodeLevelItem> saleBarcodeLevelItemList) {
        if (saleBarcodeLevelItemList != null && !saleBarcodeLevelItemList.isEmpty()) {
            for (SaleBarcodeLevelItem entity : saleBarcodeLevelItemList) {
                entity.setHeadId(saleBarcodeLevelHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)saleBarcodeLevelHead);
            }
            this.saleBarcodeLevelItemService.saveBatch(saleBarcodeLevelItemList);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.saleBarcodeLevelItemMapper.deleteByMainId(id);
        this.saleBarcodeLevelHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.saleBarcodeLevelItemMapper.deleteByMainId(serializable.toString());
            this.saleBarcodeLevelHeadMapper.deleteById(serializable);
        }
    }

    @Override
    public boolean addByPurchase(PurchaseBarcodeLevelHead purchaseBarcodeLevelHead, List<PurchaseBarcodeLevelItem> purchaseBarcodeLevelItemList) {
        String purchaseEls = purchaseBarcodeLevelHead.getElsAccount();
        String purchaseName = purchaseBarcodeLevelHead.getPurchaseName();
        SaleBarcodeLevelHead saleBarcodeLevelHead = new SaleBarcodeLevelHead();
        BeanUtils.copyProperties((Object)((Object)purchaseBarcodeLevelHead), (Object)((Object)saleBarcodeLevelHead));
        saleBarcodeLevelHead.setRelationId(purchaseBarcodeLevelHead.getId());
        saleBarcodeLevelHead.setId(null);
        saleBarcodeLevelHead.setElsAccount(purchaseBarcodeLevelHead.getToElsAccount());
        saleBarcodeLevelHead.setToElsAccount(purchaseEls);
        this.saleBarcodeLevelHeadMapper.insert((Object)saleBarcodeLevelHead);
        ArrayList<SaleBarcodeLevelItem> saleBarcodeLevelItemList = new ArrayList<SaleBarcodeLevelItem>();
        for (PurchaseBarcodeLevelItem purchaseBarcodeLevelItem : purchaseBarcodeLevelItemList) {
            SaleBarcodeLevelItem saleBarcodeLevelItem = new SaleBarcodeLevelItem();
            BeanUtils.copyProperties((Object)((Object)purchaseBarcodeLevelItem), (Object)((Object)saleBarcodeLevelItem));
            saleBarcodeLevelItem.setRelationId(purchaseBarcodeLevelItem.getId());
            saleBarcodeLevelItem.setElsAccount(saleBarcodeLevelHead.getElsAccount());
            saleBarcodeLevelItem.setHeadId(saleBarcodeLevelHead.getId());
            saleBarcodeLevelItem.setId(null);
            saleBarcodeLevelItemList.add(saleBarcodeLevelItem);
        }
        return this.saleBarcodeLevelItemService.saveBatch(saleBarcodeLevelItemList);
    }
}

