/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.custom.adapter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.custom.entity.BusinessCustomConfig;
import com.els.modules.custom.entity.PurchaseCustomFormHead;
import com.els.modules.custom.service.BusinessCustomConfigService;
import com.els.modules.custom.service.PurchaseCustomFormHeadService;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;

public class BusinessCustomAdapter
implements AuditOptCallBackService {
    @Resource
    private PurchaseCustomFormHeadService purchaseCustomFormHeadService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private BusinessCustomConfigService customConfigService;

    public void startCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        this.updateAuditStatus(inputParamDTO, outputParamDTO);
        this.sendMsg(inputParamDTO, outputParamDTO, "submitAudit");
    }

    public void completeCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        this.updateAuditStatus(inputParamDTO, outputParamDTO);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamDTO.getAuditStatus())) {
            this.sendMsg(inputParamDTO, outputParamDTO, "auditPass");
        } else {
            this.sendMsg(inputParamDTO, outputParamDTO, "submitAudit");
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        this.updateAuditStatus(inputParamDTO, outputParamDTO);
        this.sendMsg(inputParamDTO, outputParamDTO, "auditReject");
    }

    public void cancelCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        this.updateAuditStatus(inputParamDTO, outputParamDTO);
        this.sendMsg(inputParamDTO, outputParamDTO, "auditReject");
    }

    public JSONObject getDataById(String id) {
        PurchaseCustomFormHead customFormHead = (PurchaseCustomFormHead)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.purchaseCustomFormHeadService.lambdaQuery().eq(BaseEntity::getId, (Object)id)).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).one());
        return JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)customFormHead)));
    }

    private void updateAuditStatus(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        String businessId = inputParamDTO.getBusinessId();
        String businessType = inputParamDTO.getBusinessType();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.purchaseCustomFormHeadService.lambdaUpdate().set(PurchaseCustomFormHead::getAuditStatus, (Object)outputParamDTO.getAuditStatus())).eq(BaseEntity::getId, (Object)businessId)).eq(PurchaseCustomFormHead::getBusinessType, (Object)businessType)).update();
    }

    private void sendMsg(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO, String optType) {
        String elsAccount = TenantContext.getTenant();
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamDTO.getAuditStatus())) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamDTO, outputParamDTO, outputParamDTO.getSubmitUser());
            MqUtil.sendBusMsg((String)elsAccount, (String)inputParamDTO.getBusinessType(), (String)optType, (MsgParamsVO)msgParamsVO);
        } else {
            List accountList = outputParamDTO.getNextAuditUserList();
            for (String account : accountList) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamDTO, outputParamDTO, account);
                MqUtil.sendBusMsg((String)elsAccount, (String)inputParamDTO.getBusinessType(), (String)optType, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        String businessType = inputParamDTO.getBusinessType();
        String flowId = outputParamDTO.getProcessRootId();
        String headId = inputParamDTO.getBusinessId();
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        String outAuditRejectUrl = SysUtil.getOutAuditRejectUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        PurchaseCustomFormHead customFormHead = (PurchaseCustomFormHead)((Object)this.purchaseCustomFormHeadService.getById((Serializable)((Object)headId)));
        BusinessCustomConfig customConfig = (BusinessCustomConfig)((Object)this.customConfigService.getById((Serializable)((Object)businessType)));
        Result result = Result.ok((Object)((Object)customFormHead));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean(DictAspect.class);
        dictAspect.parseDictText((Object)result);
        JSONObject jsonObject = (JSONObject)result.getResult();
        Map paramMap = (Map)JSON.parse((String)jsonObject.toString());
        paramMap.put("userName", subAccount.getRealname());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams((Object)paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamDTO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamDTO.getBusinessType());
        paramObj.put("businessName", (Object)customConfig.getBusinessName());
        if (account.split("_").length > 2) {
            paramObj.put("taskId", (Object)account.split("_")[2]);
        }
        if (account.split("_").length > 3) {
            paramObj.put("processInstanceId", (Object)account.split("_")[3]);
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }
}

