/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.interfaceConversion.service.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.modules.interfaceConversion.entity.ElsInterfaceConvertConfig;
import com.els.modules.interfaceConversion.mapper.ElsInterfaceConvertConfigMapper;
import com.els.modules.interfaceConversion.service.ElsInterfaceConvertConfigService;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ElsInterfaceConvertConfigServiceImpl
extends BaseServiceImpl<ElsInterfaceConvertConfigMapper, ElsInterfaceConvertConfig>
implements ElsInterfaceConvertConfigService {
    private static final Logger log = LoggerFactory.getLogger(ElsInterfaceConvertConfigServiceImpl.class);
    private static final String ROOT_KEY = "[root]";
    private static final String PARENT_KEY = "[parent].";
    private static final String DEFAULT_KEY = "[DEFAULT]";

    @Override
    public void add(ElsInterfaceConvertConfig elsInterfaceConvertConfig) {
        ((ElsInterfaceConvertConfigMapper)this.baseMapper).insert((Object)elsInterfaceConvertConfig);
    }

    @Override
    public void edit(ElsInterfaceConvertConfig elsInterfaceConvertConfig) {
        int count = ((ElsInterfaceConvertConfigMapper)this.baseMapper).updateById((Object)elsInterfaceConvertConfig);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((ElsInterfaceConvertConfigMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((ElsInterfaceConvertConfigMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public ElsInterfaceConvertConfig getInterfaceConvertConfig(String elsAccount, String configCode) {
        List convertConfigList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(ElsInterfaceConvertConfig::getConfigCode, (Object)configCode)).list();
        if (convertConfigList.size() == 0) {
            throw new ELSBootException("\u627e\u4e0d\u5230\u8f6c\u6362\u914d\u7f6e\uff1a" + configCode);
        }
        HashSet<String> nodeKeySet = new HashSet<String>();
        HashSet<String> parentKeySet = new HashSet<String>();
        for (ElsInterfaceConvertConfig convertConfig : convertConfigList) {
            parentKeySet.add(convertConfig.getParent());
            if (nodeKeySet.contains(convertConfig.getNodeName()) && parentKeySet.contains(convertConfig.getNodeName())) {
                throw new ELSBootException("\u5b58\u5728\u91cd\u590d\u7684\u8282\u70b9\u540d\u79f0\uff1a" + convertConfig.getNodeName());
            }
            nodeKeySet.add(convertConfig.getNodeName());
        }
        ElsInterfaceConvertConfig rootConfig = null;
        for (ElsInterfaceConvertConfig configVO : convertConfigList) {
            if (!ROOT_KEY.equals(configVO.getParent())) continue;
            rootConfig = configVO;
            this.getChildrenConfig(rootConfig, convertConfigList);
            break;
        }
        if (rootConfig == null) {
            throw new ELSBootException("\u627e\u4e0d\u5230\u6839\u8282\u70b9\u914d\u7f6e\uff0c\u6839\u8282\u70b9\u7684parent\u5fc5\u987b\u4e3a[root]\uff1a" + configCode);
        }
        return rootConfig;
    }

    private void getChildrenConfig(ElsInterfaceConvertConfig parentConfig, List<ElsInterfaceConvertConfig> configVOList) {
        for (ElsInterfaceConvertConfig configVO : configVOList) {
            if (!parentConfig.getNodeName().equals(configVO.getParent())) continue;
            parentConfig.getChildren().add(configVO);
            this.getChildrenConfig(configVO, configVOList);
        }
    }
}

