/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.language.excel;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.excel.service.BaseExportService;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.service.ExportDataLoaderService;
import com.els.modules.language.entity.I18n;
import com.els.modules.language.mapper.I18nMapper;
import com.els.modules.language.vo.I18nVO;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="i18nExportServiceImpl")
public class I18nExportServiceImpl
extends BaseExportService<I18n, I18nVO, I18nVO>
implements ExportDataLoaderService {
    @Autowired
    private I18nMapper baseMapper;

    public List<I18nVO> queryExportData(QueryWrapper<I18n> queryWrapper, I18nVO i18n, Map<String, String[]> paramMap) {
        List<Object> chineseList = new ArrayList();
        i18n.setElsAccount(TenantContext.getTenant());
        i18n.setFromIndex(0);
        if (StringUtils.isEmpty((CharSequence)i18n.getChinese())) {
            count = this.baseMapper.findPageCount(i18n);
            i18n.setPageSize((int)count);
            chineseList = this.baseMapper.findPageChinese(i18n);
        } else {
            count = this.baseMapper.findPageCountch(i18n);
            i18n.setPageSize((int)count);
            chineseList = this.baseMapper.findPageChinesech(i18n);
        }
        List<String> i18nKeyList = chineseList.stream().map(I18n::getI18nKey).distinct().collect(Collectors.toList());
        ArrayList<I18nVO> list = new ArrayList<I18nVO>(chineseList.size());
        if (CollUtil.isNotEmpty(i18nKeyList)) {
            List<I18n> englishList = this.baseMapper.findPageEnglish(i18nKeyList, i18n.getElsAccount());
            Map<String, String> englishMap = englishList.stream().collect(Collectors.toMap(I18n::getI18nKey, I18n::getI18nValue));
            List<I18n> chtList = this.baseMapper.findPageCht(i18nKeyList, i18n.getElsAccount());
            Map<String, String> chtMap = chtList.stream().collect(Collectors.toMap(I18n::getI18nKey, I18n::getI18nValue));
            List<I18n> fraList = this.baseMapper.findPageFra(i18nKeyList, i18n.getElsAccount());
            Map<String, String> fraMap = fraList.stream().collect(Collectors.toMap(I18n::getI18nKey, I18n::getI18nValue));
            List<I18n> vieList = this.baseMapper.findPageVie(i18nKeyList, i18n.getElsAccount());
            Map<String, String> vieMap = vieList.stream().collect(Collectors.toMap(I18n::getI18nKey, I18n::getI18nValue));
            List<I18n> germanList = this.baseMapper.findPageGerman(i18nKeyList, i18n.getElsAccount());
            Map<String, String> germanMap = germanList.stream().collect(Collectors.toMap(I18n::getI18nKey, I18n::getI18nValue));
            for (I18n i18n2 : chineseList) {
                I18nVO vo = new I18nVO();
                vo.setChinese(i18n2.getI18nValue());
                vo.setI18nKey(i18n2.getI18nKey());
                if (englishMap.containsKey(i18n2.getI18nKey())) {
                    vo.setEnglish(englishMap.get(i18n2.getI18nKey()));
                }
                if (fraMap.containsKey(i18n2.getI18nKey())) {
                    vo.setFrench(fraMap.get(i18n2.getI18nKey()));
                }
                if (chtMap.containsKey(i18n2.getI18nKey())) {
                    vo.setTraditionalChinese(chtMap.get(i18n2.getI18nKey()));
                }
                if (vieMap.containsKey(i18n2.getI18nKey())) {
                    vo.setVietnamese(vieMap.get(i18n2.getI18nKey()));
                }
                if (germanMap.containsKey(i18n2.getI18nKey())) {
                    vo.setGerman(germanMap.get(i18n2.getI18nKey()));
                }
                list.add(vo);
            }
            return list;
        }
        return Lists.newArrayList();
    }

    public long queryExportDataCount(QueryWrapper<I18n> queryWrapper, I18nVO i18n, Map<String, String[]> paramMap) {
        i18n.setElsAccount(TenantContext.getTenant());
        if (StringUtils.isEmpty((CharSequence)i18n.getChinese())) {
            return this.baseMapper.findPageCount(i18n);
        }
        return this.baseMapper.findPageCountch(i18n);
    }

    public String getBusinessType() {
        return "I18n";
    }

    public String getBeanName() {
        return "i18nExportExcelDataBatchQueryLoader";
    }

    protected boolean doQueryWrapperFiler() {
        return false;
    }

    public String loadData(Integer pageNumber, Integer pageSize, Map<String, Object> entityMap, Map<String, String[]> requestParamMap) {
        I18nVO i18n = (I18nVO)JSON.parseObject((String)JSON.toJSONString(entityMap), I18nVO.class);
        i18n.setElsAccount(TenantContext.getTenant());
        i18n.setFromIndex(pageNumber - 1);
        i18n.setPageSize(pageSize);
        List<I18n> chineseList = StringUtils.isEmpty((CharSequence)i18n.getChinese()) ? this.baseMapper.findPageChinese(i18n) : this.baseMapper.findPageChinesech(i18n);
        List<String> i18nKeyList = chineseList.stream().map(I18n::getI18nKey).distinct().collect(Collectors.toList());
        ArrayList<I18nVO> list = new ArrayList<I18nVO>(chineseList.size());
        if (CollUtil.isNotEmpty(i18nKeyList)) {
            List<I18n> englishList = this.baseMapper.findPageEnglish(i18nKeyList, i18n.getElsAccount());
            Map<String, String> englishMap = englishList.stream().collect(Collectors.toMap(I18n::getI18nKey, I18n::getI18nValue));
            List<I18n> chtList = this.baseMapper.findPageCht(i18nKeyList, i18n.getElsAccount());
            Map<String, String> chtMap = chtList.stream().collect(Collectors.toMap(I18n::getI18nKey, I18n::getI18nValue));
            List<I18n> fraList = this.baseMapper.findPageFra(i18nKeyList, i18n.getElsAccount());
            Map<String, String> fraMap = fraList.stream().collect(Collectors.toMap(I18n::getI18nKey, I18n::getI18nValue));
            List<I18n> vieList = this.baseMapper.findPageVie(i18nKeyList, i18n.getElsAccount());
            Map<String, String> vieMap = vieList.stream().collect(Collectors.toMap(I18n::getI18nKey, I18n::getI18nValue));
            List<I18n> germanList = this.baseMapper.findPageGerman(i18nKeyList, i18n.getElsAccount());
            Map<String, String> germanMap = germanList.stream().collect(Collectors.toMap(I18n::getI18nKey, I18n::getI18nValue));
            for (I18n n : chineseList) {
                I18nVO vo = new I18nVO();
                vo.setChinese(n.getI18nValue());
                vo.setI18nKey(n.getI18nKey());
                if (englishMap.containsKey(n.getI18nKey())) {
                    vo.setEnglish(englishMap.get(n.getI18nKey()));
                }
                if (fraMap.containsKey(n.getI18nKey())) {
                    vo.setFrench(fraMap.get(n.getI18nKey()));
                }
                if (chtMap.containsKey(n.getI18nKey())) {
                    vo.setTraditionalChinese(chtMap.get(n.getI18nKey()));
                }
                if (vieMap.containsKey(n.getI18nKey())) {
                    vo.setVietnamese(vieMap.get(n.getI18nKey()));
                }
                if (germanMap.containsKey(n.getI18nKey())) {
                    vo.setGerman(germanMap.get(n.getI18nKey()));
                }
                list.add(vo);
            }
            return JSON.toJSONString(list);
        }
        return "[]";
    }
}

