/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.FormCommit;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.ElsYhBankConfig;
import com.els.modules.system.entity.ElsYhBranchBankConfig;
import com.els.modules.system.entity.ElsYhCityConfig;
import com.els.modules.system.entity.ElsYhProvinceConfig;
import com.els.modules.system.service.ElsYhBankConfigService;
import com.els.modules.system.service.ElsYhBranchBankConfigService;
import com.els.modules.system.service.ElsYhCityConfigService;
import com.els.modules.system.service.ElsYhProvinceConfigService;
import com.els.modules.system.vo.ElsYhBranchBankConfigVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u94f6\u884c\u4fe1\u606f\u63a5\u53e3\u914d\u7f6e"})
@RestController
@RequestMapping(value={"/system/branchBankConfig"})
public class ElsBranchBankConfigController
extends BaseController<ElsYhBranchBankConfig, ElsYhBranchBankConfigService> {
    @Autowired
    private ElsYhBranchBankConfigService elsYhBranchBankConfigService;
    @Autowired
    private ElsYhProvinceConfigService elsYhProvinceConfigService;
    @Autowired
    private ElsYhCityConfigService elsYhCityConfigService;
    @Autowired
    private ElsYhBankConfigService elsYhBankConfigService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"system#branchBankConfig:list"})
    public Result<?> queryPageList(ElsYhBranchBankConfigVO elsYhBranchBankConfigVO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsYhBranchBankConfigVO), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        queryWrapper.eq((Object)"deleted", (Object)CommonConstant.DEL_FLAG_0);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<ElsYhBranchBankConfigVO> pageList = this.elsYhBranchBankConfigService.seleBanksPage((Page<ElsYhBranchBankConfigVO>)page, (QueryWrapper<ElsYhBranchBankConfigVO>)queryWrapper);
        return Result.ok(pageList);
    }

    @FormCommit
    @SrmValidated
    @AutoLog(value="\u94f6\u884c\u4fe1\u606f\u63a5\u53e3\u914d\u7f6e-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"system#branchBankConfig:add"})
    public Result<?> add(@RequestBody ElsYhBranchBankConfigVO configVO) {
        String purchaseAccount = SysUtil.getPurchaseAccount();
        String elsAccount = TenantContext.getTenant();
        if (StringUtils.isBlank((CharSequence)elsAccount) || StringUtils.isBlank((CharSequence)purchaseAccount)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_UEeynOAt_b67d2968", (String)"\u5e73\u53f0\u8d26\u53f7\u624d\u80fd\u7f16\u8f91\uff01"));
        }
        if (!elsAccount.equals(purchaseAccount)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_UEeynOAt_b67d2968", (String)"\u5e73\u53f0\u8d26\u53f7\u624d\u80fd\u7f16\u8f91\uff01"));
        }
        this.elsYhBranchBankConfigService.add(configVO);
        String id = configVO.getId();
        return this.queryById(id);
    }

    @SrmValidated
    @AutoLog(value="\u94f6\u884c\u4fe1\u606f\u63a5\u53e3\u914d\u7f6e-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"system#branchBankConfig:edit"})
    public Result<?> edit(@RequestBody ElsYhBranchBankConfigVO configVO) {
        String purchaseAccount = SysUtil.getPurchaseAccount();
        String elsAccount = TenantContext.getTenant();
        if (StringUtils.isBlank((CharSequence)elsAccount) || StringUtils.isBlank((CharSequence)purchaseAccount)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_UEeynOSu_b63591de", (String)"\u5e73\u53f0\u8d26\u53f7\u624d\u80fd\u6dfb\u52a0\uff01"));
        }
        if (!elsAccount.equals(purchaseAccount)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_UEeynOSu_b63591de", (String)"\u5e73\u53f0\u8d26\u53f7\u624d\u80fd\u6dfb\u52a0\uff01"));
        }
        this.elsYhBranchBankConfigService.edit(configVO);
        String id = configVO.getId();
        return this.queryById(id);
    }

    @AutoLog(value="\u94f6\u884c\u4fe1\u606f\u63a5\u53e3\u914d\u7f6e-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"system#branchBankConfig:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        String purchaseAccount = SysUtil.getPurchaseAccount();
        String elsAccount = TenantContext.getTenant();
        if (StringUtils.isBlank((CharSequence)elsAccount) || StringUtils.isBlank((CharSequence)purchaseAccount)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_UEeynOQG_b5d5357f", (String)"\u5e73\u53f0\u8d26\u53f7\u624d\u80fd\u5220\u9664\uff01"));
        }
        if (!elsAccount.equals(purchaseAccount)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_UEeynOQG_b5d5357f", (String)"\u5e73\u53f0\u8d26\u53f7\u624d\u80fd\u5220\u9664\uff01"));
        }
        this.elsYhBranchBankConfigService.delete(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"system#branchBankConfig:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        ElsYhBranchBankConfigVO bankConfig = this.elsYhBranchBankConfigService.queryById(id);
        return Result.ok((Object)((Object)bankConfig));
    }

    @ApiOperation(value="\u94f6\u884c\u4fe1\u606f\u63a5\u53e3\u914d\u7f6e-\u7701\u4efd\u83b7\u53d6", notes="\u94f6\u884c\u4fe1\u606f\u63a5\u53e3\u914d\u7f6e-\u7701\u4efd\u83b7\u53d6")
    @GetMapping(value={"/provinceList"})
    @RequiresPermissions(value={"system#branchBankConfig:list"})
    public Result<?> provinceList(ElsYhProvinceConfig elsYhProvinceConfig, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsYhProvinceConfig), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        queryWrapper.eq((Object)"is_deleted", (Object)CommonConstant.DEL_FLAG_0);
        IPage pageList = this.elsYhProvinceConfigService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u94f6\u884c\u4fe1\u606f\u63a5\u53e3\u914d\u7f6e-\u57ce\u5e02\u83b7\u53d6", notes="\u94f6\u884c\u4fe1\u606f\u63a5\u53e3\u914d\u7f6e-\u57ce\u5e02\u83b7\u53d6")
    @GetMapping(value={"/cityList"})
    @RequiresPermissions(value={"system#branchBankConfig:list"})
    public Result<?> cityList(ElsYhCityConfig elsYhCityConfig, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsYhCityConfig), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        queryWrapper.eq((Object)"is_deleted", (Object)CommonConstant.DEL_FLAG_0);
        IPage pageList = this.elsYhCityConfigService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u94f6\u884c\u4fe1\u606f\u63a5\u53e3\u914d\u7f6e-\u57ce\u5e02\u83b7\u53d6", notes="\u94f6\u884c\u4fe1\u606f\u63a5\u53e3\u914d\u7f6e-\u57ce\u5e02\u83b7\u53d6")
    @GetMapping(value={"/bankList"})
    @RequiresPermissions(value={"system#branchBankConfig:list"})
    public Result<?> bankList(ElsYhBankConfig elsYhBankConfig, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsYhBankConfig), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        queryWrapper.eq((Object)"is_deleted", (Object)CommonConstant.DEL_FLAG_0);
        IPage pageList = this.elsYhBankConfigService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }
}

