/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.SysUtil;
import com.els.modules.system.entity.ElsQueryHead;
import com.els.modules.system.entity.ElsQueryItem;
import com.els.modules.system.mapper.ElsQueryHeadMapper;
import com.els.modules.system.mapper.ElsQueryItemMapper;
import com.els.modules.system.service.ElsQueryHeadService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ElsQueryHeadServiceImpl
extends ServiceImpl<ElsQueryHeadMapper, ElsQueryHead>
implements ElsQueryHeadService {
    @Autowired
    private ElsQueryHeadMapper elsQueryHeadMapper;
    @Autowired
    private ElsQueryItemMapper elsQueryItemMapper;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(ElsQueryHead elsQueryHead, List<ElsQueryItem> elsQueryItemList) {
        this.elsQueryHeadMapper.insert((Object)elsQueryHead);
        this.insertData(elsQueryHead, elsQueryItemList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(ElsQueryHead elsQueryHead, List<ElsQueryItem> elsQueryItemList) {
        this.elsQueryHeadMapper.updateById((Object)elsQueryHead);
        this.elsQueryItemMapper.deleteByMainId(elsQueryHead.getId());
        this.insertData(elsQueryHead, elsQueryItemList);
    }

    private void insertData(ElsQueryHead elsQueryHead, List<ElsQueryItem> elsQueryItemList) {
        int itemNumber = 1;
        for (ElsQueryItem entity : elsQueryItemList) {
            entity.setHeadId(elsQueryHead.getId());
            entity.setItemNumber("" + itemNumber);
            ++itemNumber;
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)elsQueryHead);
        }
        if (!elsQueryItemList.isEmpty()) {
            this.elsQueryItemMapper.insertBatchSomeColumn(elsQueryItemList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.elsQueryItemMapper.deleteByMainId(id);
        this.elsQueryHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.elsQueryItemMapper.deleteByMainId(serializable.toString());
            this.elsQueryHeadMapper.deleteById(serializable);
        }
    }
}

