/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.SensitiveField;
import com.els.modules.system.mapper.SensitiveFieldMapper;
import com.els.modules.system.service.SensitiveFieldService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SensitiveFieldServiceImpl
extends BaseServiceImpl<SensitiveFieldMapper, SensitiveField>
implements SensitiveFieldService {
    private static final String REDIS_KEY = "sys:sensitiveList:";
    @Resource
    private RedisUtil redisUtil;

    private String getRedisKey(String elsAccount) {
        StringBuilder redisKey = new StringBuilder(REDIS_KEY);
        redisKey.append(elsAccount);
        return redisKey.toString();
    }

    @Override
    public void saveSensitiveField(SensitiveField sensitiveField) {
        ((SensitiveFieldMapper)this.baseMapper).insert((Object)sensitiveField);
        this.redisUtil.del(new String[]{this.getRedisKey(TenantContext.getTenant())});
    }

    @Override
    public void updateSensitiveField(SensitiveField sensitiveField) {
        ((SensitiveFieldMapper)this.baseMapper).updateById((Object)sensitiveField);
        this.redisUtil.del(new String[]{this.getRedisKey(TenantContext.getTenant())});
    }

    @Override
    public void delSensitiveField(String id) {
        ((SensitiveFieldMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.redisUtil.del(new String[]{this.getRedisKey(TenantContext.getTenant())});
    }

    @Override
    public void delBatchSensitiveField(List<String> idList) {
        ((SensitiveFieldMapper)this.baseMapper).deleteBatchIds(idList);
        this.redisUtil.del(new String[]{this.getRedisKey(TenantContext.getTenant())});
    }

    @Override
    public List<SensitiveField> findAllGroup(String elsAccount) {
        List<SensitiveField> fieldList = this.findAll(elsAccount);
        ArrayList<SensitiveField> resultList = new ArrayList<SensitiveField>();
        HashMap<String, String> map = new HashMap<String, String>();
        for (SensitiveField field : fieldList) {
            if (map.containsKey(field.getFieldGroup())) continue;
            map.put(field.getFieldGroup(), field.getFieldGroup());
            resultList.add(field);
        }
        return resultList;
    }

    private List<SensitiveField> findAll(String elsAccount) {
        List fieldList = (List)this.redisUtil.get(this.getRedisKey(elsAccount));
        if (fieldList != null) {
            return fieldList;
        }
        fieldList = this.list((Wrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount));
        if (fieldList.isEmpty()) {
            fieldList = this.list((Wrapper)new QueryWrapper().eq((Object)"els_account", (Object)"100000"));
        }
        this.redisUtil.set(this.getRedisKey(elsAccount), (Object)fieldList, 7200L);
        return fieldList;
    }

    @Override
    public List<SensitiveField> findSensitiveFieldByGroup(String elsAccount, String groups) {
        List<SensitiveField> fieldList = this.findAll(elsAccount);
        ArrayList<SensitiveField> resultList = new ArrayList<SensitiveField>();
        if (StrUtil.isBlank((CharSequence)elsAccount) || StrUtil.isBlank((CharSequence)groups)) {
            return resultList;
        }
        for (SensitiveField field : fieldList) {
            if (!groups.contains(field.getFieldGroup())) continue;
            resultList.add(field);
        }
        return resultList;
    }
}

