/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.todo.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.els.common.api.vo.Result;
import com.els.modules.history.entity.ElsBusinessTransferHis;
import com.els.modules.todo.service.rpc.service.TodoListService;
import com.els.modules.todo.vo.TodoCountInfoVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u9996\u9875\u5f85\u529e\u4e8b\u9879"})
@RestController
@RequestMapping(value={"/base/todo"})
public class TodoListController {
    private static final Logger log = LoggerFactory.getLogger(TodoListController.class);
    @Autowired
    private TodoListService todoListService;

    @ApiOperation(value="\u83b7\u53d6\u9996\u9875\u5f85\u529e\u4e8b\u9879\u7edf\u8ba1", notes="\u83b7\u53d6\u9996\u9875\u5f85\u529e\u4e8b\u9879\u7edf\u8ba1")
    @PostMapping(value={"/getTodoCountList"})
    @RequiresPermissions(value={"todo#todo:getTodoCountList"})
    public Result<?> getTodoCountList() {
        List<TodoCountInfoVO> list = this.todoListService.getTodoCountList();
        return Result.ok(list);
    }

    @ApiOperation(value="\u9996\u9875\u5f85\u529e\u4e8b\u9879\u7edf\u8ba1-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u9996\u9875\u5f85\u529e\u4e8b\u9879\u7edf\u8ba1-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/pageTodoCountList"})
    @RequiresPermissions(value={"todo#todo:pageTodoCountList"})
    public Result<?> queryPageList(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        IPage<ElsBusinessTransferHis> pageList = this.todoListService.pageTodoCountList(pageNo, pageSize);
        return Result.ok(pageList);
    }
}

