/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.translate.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.PermissionDTO;
import com.els.modules.translate.service.TranslateService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TranslateServiceImpl
implements TranslateService {
    private static final Logger log = LoggerFactory.getLogger(TranslateServiceImpl.class);
    @Resource
    private InvokeAccountRpcService accountRpcService;

    @Override
    public void buildResult(JSONObject result, String requestType) {
        String audioText = result.getString("Result");
        if (StrUtil.isNotBlank((CharSequence)audioText) && audioText.contains("\u3002")) {
            result.put("Result", (Object)audioText.substring(0, audioText.length() - 1));
        }
        if ("openMenu".equals(requestType)) {
            List permissionList = this.accountRpcService.getPermissionByAccount(TenantContext.getTenant(), SysUtil.getLoginUser().getSubAccount());
            log.info("permissionList_size:" + permissionList.size());
            List muenList = permissionList.stream().filter(o -> o.getMenuType() != 2).collect(Collectors.toList());
            List<PermissionDTO> resultList = muenList.stream().filter(o -> audioText.contains(o.getName())).collect(Collectors.toList());
            if (resultList.isEmpty()) {
                resultList = muenList.stream().filter(o -> this.contains(audioText, o.getName())).collect(Collectors.toList());
            }
            log.info("resultList_size:" + resultList.size());
            if (resultList.isEmpty()) {
                result.put("optType", (Object)"error");
                result.put("optObject", (Object)"\u672a\u6b63\u786e\u8bc6\u522b\u64cd\u4f5c\u6307\u4ee4");
            } else {
                result.put("optType", (Object)"openMenu");
                resultList.forEach(item -> item.setSortNo(Double.valueOf(StrUtil.similar((String)audioText, (String)item.getName()))));
                PermissionDTO dto = resultList.stream().max(Comparator.comparing(PermissionDTO::getSortNo)).get();
                result.put("optObject", (Object)dto);
            }
        }
    }

    private boolean contains(String audioText, String name) {
        double similar = StrUtil.similar((String)audioText, (String)name);
        return similar > 0.0;
    }

    public static void main(String[] args) {
        String a = "\u6253\u5f00\u9996\u9875";
        String b = "\u6253\u5370\u6a21\u677f";
        double similar = StrUtil.similar((String)a, (String)b);
        System.out.println(similar);
    }
}

