/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core.modelStrategy;

import cn.hutool.core.text.CharSequenceUtil;
import com.els.modules.ai.core.AiChatExtractor;
import com.els.modules.ai.core.AiQuestion;
import com.els.modules.ai.core.helper.AiChatResponseHelper;
import com.els.modules.ai.core.modelStrategy.SimpleAiLogicRunStrategy;
import com.els.modules.ai.core.util.AiBeanFactory;
import com.els.modules.ai.pojo.AiChatAppPojo;
import com.els.modules.ai.pojo.AiChatExamplarPojo;
import com.els.modules.ai.pojo.AiChatPojo;
import com.els.modules.ai.pojo.LlmRequestPojo;
import com.els.modules.ai.pojo.LlmResponsePojo;
import com.els.modules.ai.pojo.QuestionInfoPojo;
import com.google.common.collect.Lists;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.service.AiServices;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;

@Service
public class OrderCreationAiLogicRunStrategy
extends SimpleAiLogicRunStrategy
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(OrderCreationAiLogicRunStrategy.class);
    public static final String INSTRUCTION = "#\u89d2\u8272: \u8bf7\u4f5c\u4e3a\u81ea\u7136\u8bed\u8a00\u5206\u6790\u4e13\u5bb6\uff0c\u6309\u4ee5\u4e0b\u6b65\u9aa4\u5904\u7406\u5904\u7406\u5206\u6790\u6211\u8f93\u5165\u7684\u95ee\u9898\uff0c\u8fd4\u56de\u89e3\u6790\u7ed3\u679c\u3002\n1.\u6536\u96c6\u6211\u63d0\u4f9b\u7684\u6570\u636e\u6a21\u578b\u89c4\u7ea6(questionSchema)\uff0c\u8fd9\u662f\u6211\u81ea\u7136\u8bed\u8a00\u95ee\u9898\u91cc\u9762\u7684\u5b57\u6bb5\u89c4\u8303\uff0c\u7ed9\u4f60\u5bf9\u7167\u4f7f\u7528\u3002\n2.\u6839\u636e\u6211\u7684Question\uff0c\u914d\u5408\u6570\u636e\u6a21\u578b\u89c4\u8303(questionSchema)\uff0c\u5e2e\u6211\u8fd4\u56de\u4e00\u4e2a\u7b26\u5408\u8981\u6c42\u7684JSON\u683c\u5f0f\u7684\u6570\u636e\u3002\n3.\u5982\u679c\u67d0\u4e2a\u6761\u4ef6\u662f\u591a\u4e2a\u503c\u7684\uff0c\u4f60\u53ef\u4ee5\u4f7f\u7528\u9017\u53f7(,)\u62fc\u63a5\uff0c\u4ee5\u4fbf\u4e8e\u533a\u5206\u3002\n3.\u5982\u679c\u6709\u63d0\u4f9b\u6837\u4f8b(Exemplars)\uff0c\u53ef\u4ee5\u53c2\u8003\u6837\u4f8b\u7ed9\u51fa\u7ed3\u679c\u3002\n4.\u5982\u679c\u4f60\u8981\u7528\u5230\u65e5\u671f\u7684\u5b57\u6bb5\uff0c\u586b\u5145JSON\u7684\u6570\u636e\u7684\u65e5\u671f\u683c\u5f0f\u53ef\u4ee5\u662f\u7c7b\u4f3c:2025-05-12 \u8fd9\u79cd\u683c\u5f0f\u3002\n5.\u4e0d\u5141\u8bb8\u634f\u9020\u5b57\u6bb5\uff0c\u8fd4\u56de\u7684JSON\u91cc\u9762\u7684\u6570\u636ekey\uff0c\u5fc5\u987b\u53d7\u5230\u6211\u63d0\u4f9b\u7684\u6570\u636e\u6a21\u578b\u89c4\u7ea6(questionSchema)\u7684\u7ea6\u675f\uff0cJSON\u7684key\u5fc5\u987b\u90fd\u5728\u91cc\u9762\u5b58\u5728\u3002\n6.\u4e0d\u7ba1\u7528\u6237\u95ee\u9898\u5339\u914d\u5230\u7684\u662fquestionSchema\u4e2d\u7684\u5b57\u6bb5\u540d\u79f0(fieldName)\uff0c\u8fd8\u662f\u8fd9\u4e2a\u5b57\u6bb5\u522b\u540d(fieldAlias)\uff0c\u6700\u7ec8\u8fd4\u56de\u7684JSON\u7684key\uff0c\u90fd\u662f\u4f7f\u7528\u6a21\u578b\u89c4\u4e2d\u7684\u5b57\u6bb5\u7f16\u7801(fieldCode)\u3002\n7.\u5982\u679c\u6211\u63d0\u4f9b\u4e86\u4e0a\u4e00\u6b21\u95ee\u9898(lastQuestion)\u548c\u4e0a\u4e00\u6b21\u89e3\u6790\u7ed3\u679c(lastQueryResult)\uff0c\u4f60\u9700\u8981\u4f7f\u7528\u4e0a\u4e00\u6b21\u7684\u89e3\u6790\u7ed3\u679c\uff0c\u548c\u5f53\u524dQuestion\u8fdb\u884c\u5bf9\u6bd4\uff0c\u518d\u6309\u7167\u8981\u6c42\u8fdb\u884c\u5206\u6790\u3002\n8.questionSchemaSideInfo\u91cc\u9762\u662f\u4e00\u4e9b\u9488\u5bf9\u6570\u636e\u6a21\u578b\u89c4\u7ea6(questionSchema)\u989d\u5916\u8bf4\u660e\uff0c\u6216\u8005\u662f\u4e00\u4e9b\u5176\u4ed6\u7684\u8bf4\u660e\u5b57\u6bb5\uff0c\u53ef\u4ee5\u7ed9\u4f60\u8f85\u52a9\u7406\u89e3\u3002\n9.SideInfo\u91cc\u9762\u662f\u4e00\u4e9b\u62d3\u5c55\u4fe1\u606f\uff0c\u53ef\u4ee5\u7ed9\u4f60\u8f85\u52a9\u7406\u89e3\uff0c\u66f4\u597d\u628a\u81ea\u7136\u8bed\u8a00\u8f6c\u6210\u6211\u8981\u7684JSON\u3002\n#Exemplars: {{exemplar}}\n\n#Query:\nQuestion:{{question}} \nquestionSchema:{{questionSchema}} \n\n#lastQuery:\nlastQuestion:{{lastQuestion}} \nlastQueryResult:{{lastQueryResult}} \n\nquestionSchemaSideInfo:{{questionSchemaSideInfo}} \nSideInfo:{{information}} ";

    @Override
    String modelRunStrategy() {
        return "orderCreationAiLogicRunStrategy";
    }

    @Override
    public LlmResponsePojo generate(LlmRequestPojo llmRequest) {
        LlmResponsePojo llmResponse = new LlmResponsePojo();
        AiChatPojo chatChatConfig = llmRequest.getAiChatPojo();
        AiChatAppPojo chatAppConfig = llmRequest.getAiChatAppPojo();
        QuestionInfoPojo question = chatChatConfig.getQuestion();
        String questionText = CharSequenceUtil.isEmpty((CharSequence)question.getQuestion()) ? chatAppConfig.getQuestion() : question.getQuestion();
        llmResponse.setQuestion(questionText);
        List<List<AiChatExamplarPojo>> exemplarsList = this.promptHelper.getFewShotExemplars(llmRequest);
        AiChatAppPojo chatApp = llmRequest.getAiChatAppPojo();
        if (StringUtils.isEmpty((CharSequence)chatApp.getPromptTemplate())) {
            chatApp.setPromptTemplate(this.getInstruction());
        }
        ChatLanguageModel chatLanguageModel = this.getChatLanguageModel(chatApp.getAiChatModelConfigPojo());
        AiChatExtractor extractor = (AiChatExtractor)AiServices.create(AiChatExtractor.class, (ChatLanguageModel)chatLanguageModel);
        HashMap<Prompt, List<AiChatExamplarPojo>> prompt2Exemplar = new HashMap<Prompt, List<AiChatExamplarPojo>>();
        for (List<AiChatExamplarPojo> exemplars : exemplarsList) {
            llmRequest.setChatExamplers(exemplars);
            Prompt prompt2 = this.generatePrompt(llmRequest, llmResponse, chatApp);
            prompt2Exemplar.put(prompt2, exemplars);
        }
        ConcurrentHashMap output2Prompt = new ConcurrentHashMap();
        ConcurrentHashMap thoughtMap = new ConcurrentHashMap();
        prompt2Exemplar.keySet().parallelStream().forEach(prompt -> {
            llmResponse.setQuestionInput(prompt.toUserMessage().singleText());
            AiQuestion answer = extractor.generateResult(prompt.toUserMessage().singleText());
            output2Prompt.put(answer.getResultText(), prompt);
            thoughtMap.put(answer.getResultText(), answer.getThought());
        });
        AiChatResponseHelper responseHelper = AiBeanFactory.getAiChatResponseHelper(chatAppConfig.getModelRunResponseHelper());
        Pair<String, Map<String, Double>> sqlMapPair = responseHelper.selfConsistencyVote(Lists.newArrayList(output2Prompt.keySet()));
        llmResponse.setResultText((String)sqlMapPair.getLeft());
        llmResponse.setThought((String)thoughtMap.get(sqlMapPair.getLeft()));
        return llmResponse;
    }

    @Override
    public String getInstruction() {
        return INSTRUCTION;
    }
}

