/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ainpl.core;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SqlInjectionUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.ai.pojo.AiOrderCreationFiledSchemaPojo;
import com.els.modules.ainpl.core.ConditionMapping;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictConditionMapping
implements ConditionMapping<JSONObject> {
    private static final Logger log = LoggerFactory.getLogger(DictConditionMapping.class);

    @Override
    public String type() {
        return "dictMapping";
    }

    @Override
    public JSONObject mapping(JSONObject condition, List<AiOrderCreationFiledSchemaPojo> filedSchema) {
        Map filedMap = filedSchema.stream().collect(Collectors.toMap(AiOrderCreationFiledSchemaPojo::getFieldCode, Function.identity(), (v1, v2) -> v2));
        JSONObject resultObject = new JSONObject();
        for (String key : condition.keySet()) {
            AiOrderCreationFiledSchemaPojo dependent;
            AiOrderCreationFiledSchemaPojo schemaDTO = (AiOrderCreationFiledSchemaPojo)filedMap.get(key);
            if (null == schemaDTO) {
                resultObject.put(key, condition.get((Object)key));
                continue;
            }
            if (CharSequenceUtil.isEmpty((CharSequence)schemaDTO.getFieldDictCode())) {
                resultObject.put(key, condition.get((Object)key));
                continue;
            }
            schemaDTO.setMappered(Boolean.valueOf(false));
            String filter = "";
            if (CharSequenceUtil.isNotEmpty((CharSequence)schemaDTO.getDependentFiled()) && null != (dependent = (AiOrderCreationFiledSchemaPojo)filedMap.get(schemaDTO.getDependentFiled()))) {
                String dependentValue = condition.getString(schemaDTO.getDependentFiled());
                JSONObject con = new JSONObject();
                con.put(dependent.getFieldCode(), (Object)dependentValue);
                dependent.setMappered(Boolean.valueOf(false));
                ArrayList temSchema = Lists.newArrayList((Object[])new AiOrderCreationFiledSchemaPojo[]{dependent});
                DictConditionMapping dictConditionMapping = new DictConditionMapping();
                JSONObject jSONObject = dictConditionMapping.mapping(con, (List<AiOrderCreationFiledSchemaPojo>)temSchema);
                String v = jSONObject.getString(dependent.getFieldCode());
                List<String> list = Arrays.stream(v.split(",")).toList();
                if (CollectionUtil.isNotEmpty(list)) {
                    StringBuilder sb = new StringBuilder("('");
                    sb.append(list.stream().collect(Collectors.joining("','")));
                    sb.append("')");
                    filter = String.format(schemaDTO.getDependentSqlFilter(), sb.toString());
                }
            }
            Object o = condition.get((Object)key);
            String value = ObjectUtil.toString((Object)o);
            List<Object> listValue = new ArrayList<String>();
            if (null != value && value.contains(",")) {
                listValue = Arrays.stream(value.split(",")).toList();
            } else {
                listValue.add(value);
            }
            HashSet<String> result = new HashSet<String>();
            for (String string : listValue) {
                TenantContext.setTenant((String)SysUtil.getLoginUser().getElsAccount());
                String dictValue = this.getDictValue(schemaDTO.getFieldDictCode(), string, filter);
                if (CharSequenceUtil.isEmpty((CharSequence)string)) {
                    throw new ELSBootException(string + "\u4e0d\u5b58\u5728\u4e8e\u5b57\u5178\u4e2d\uff0c\u8bf7\u66f4\u6539\u5185\u5bb9\u540e\u518d\u64cd\u4f5c");
                }
                String associationSplit = schemaDTO.getAssociationSplit();
                String associationColumn = schemaDTO.getAssociationColumn();
                if (CharSequenceUtil.isNotEmpty((CharSequence)associationSplit) && CharSequenceUtil.isNotEmpty((CharSequence)associationColumn)) {
                    List columnList = Arrays.stream(associationColumn.split(",")).distinct().collect(Collectors.toCollection(ArrayList::new));
                    columnList.add(0, key);
                    List splitDictValue = Arrays.stream(dictValue.split(associationSplit)).collect(Collectors.toCollection(ArrayList::new));
                    if (dictValue.endsWith(associationSplit)) {
                        splitDictValue.add("");
                    }
                    if (columnList.size() != splitDictValue.size()) {
                        throw new ELSBootException("\u7528\u6237\u8f93\u5165[" + splitDictValue.stream().collect(Collectors.joining(",")) + "]\u4e0d\u662f\u6709\u6548\u7684[" + schemaDTO.getFieldName() + "](\u82e5\u6a21\u578b\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u91cd\u65b0\u64cd\u4f5c)\uff01");
                    }
                    if (listValue.size() > 1) {
                        throw new ELSBootException("\u5217:" + schemaDTO.getFieldName() + "\uff0c:\u503c:" + listValue.stream().collect(Collectors.joining(",")) + "\uff0c\u914d\u7f6e\u6709\u5b57\u5178\u5e26\u51fa\u5217\u7684\u5b57\u5178\u6570\u636e\u5339\u914d\u53ea\u5141\u8bb8\u5355\u6761\u6570\u636e\u5339\u914d\uff0c\u8bf7\u51cf\u5c11\u5339\u914d\u503c\u6761\u4ef6\u518d\u64cd\u4f5c\uff01");
                    }
                    result.add((String)splitDictValue.get(0));
                    for (int index = columnList.size() - 1; index > 0; --index) {
                        resultObject.put((String)columnList.get(index), splitDictValue.get(index));
                    }
                    continue;
                }
                result.add(dictValue);
            }
            String lastValue = result.stream().collect(Collectors.joining(","));
            resultObject.put(key, (Object)lastValue);
            schemaDTO.setMappered(Boolean.valueOf(true));
        }
        return resultObject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getDictValue(String dictCode, String text, String filter) {
        String val = text;
        if (dictCode.contains("#") || dictCode.contains(",")) {
            String[] params = null;
            params = dictCode.contains("#") ? dictCode.split("#") : dictCode.split(",");
            if (params.length < 3) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_JCWWWWmKxiR_bc91c337", (String)"\u5b57\u5178Code\u683c\u5f0f\u4e0d\u6b63\u786e"));
            }
            String[] sqlInjCheck = new String[]{params[0], params[1], params[2]};
            SqlInjectionUtil.filterContent((String[])sqlInjCheck);
            if (params.length != 4) throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_JCxzE_2d5d1760", (String)"\u5b57\u5178\u4e0d\u5339\u914d"));
            String filterSql = params[3] + " and " + params[1] + " = '" + val + "'";
            SqlInjectionUtil.filterContent((String)filterSql);
            if (params[0].toLowerCase().contains("supplier_master_data") && params[1].toLowerCase().contains("purchase_name")) {
                filterSql = filterSql + " and to_els_account = '" + SysUtil.getLoginUser().getElsAccount() + "' ";
            }
            if (CharSequenceUtil.isNotEmpty((CharSequence)filter)) {
                filterSql = filterSql + " and " + filter;
            }
            val = ((InvokeBaseRpcService)SpringContextUtils.getBean(InvokeBaseRpcService.class)).queryTableDictItemsByValue(params[0], params[1], params[2], filterSql, val, SysUtil.getLoginUser().getElsAccount());
        } else {
            val = ((InvokeBaseRpcService)SpringContextUtils.getBean(InvokeBaseRpcService.class)).queryDictCodeByText(dictCode, val, SysUtil.getLoginUser().getElsAccount());
        }
        if (null != val) return val;
        return text;
    }
}

