/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ainpl.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.ainpl.core.nlp.FieldSpec;
import com.els.modules.ainpl.core.nlp.ModelInfo;
import com.els.modules.ainpl.entity.AiOrderCreationModelExtendItem;
import com.els.modules.ainpl.entity.AiOrderCreationModelHead;
import com.els.modules.ainpl.entity.AiOrderCreationModelItem;
import com.els.modules.ainpl.mapper.AiOrderCreationModelHeadMapper;
import com.els.modules.ainpl.service.AiOrderCreationModelExtendItemService;
import com.els.modules.ainpl.service.AiOrderCreationModelHeadService;
import com.els.modules.ainpl.service.AiOrderCreationModelItemService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class AiOrderCreationModelHeadServiceImpl
extends ServiceImpl<AiOrderCreationModelHeadMapper, AiOrderCreationModelHead>
implements AiOrderCreationModelHeadService {
    @Resource
    private AiOrderCreationModelItemService aiOrderCreationModelItemService;
    @Resource
    private AiOrderCreationModelExtendItemService aiOrderCreationModelExtendItemService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(AiOrderCreationModelHead aiOrderCreationModelHead, List<AiOrderCreationModelItem> aiOrderCreationModelItemList, List<AiOrderCreationModelExtendItem> aiOrderCreationModelExtendItemList) {
        ((AiOrderCreationModelHeadMapper)this.baseMapper).insert((Object)aiOrderCreationModelHead);
        this.insertData(aiOrderCreationModelHead, aiOrderCreationModelItemList, aiOrderCreationModelExtendItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(AiOrderCreationModelHead aiOrderCreationModelHead, List<AiOrderCreationModelItem> aiOrderCreationModelItemList, List<AiOrderCreationModelExtendItem> aiOrderCreationModelExtendItemList) {
        int count = ((AiOrderCreationModelHeadMapper)this.baseMapper).updateById((Object)aiOrderCreationModelHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.aiOrderCreationModelItemService.deleteByMainId(aiOrderCreationModelHead.getId());
        this.aiOrderCreationModelExtendItemService.deleteByMainId(aiOrderCreationModelHead.getId());
        this.insertData(aiOrderCreationModelHead, aiOrderCreationModelItemList, aiOrderCreationModelExtendItemList);
    }

    private void insertData(AiOrderCreationModelHead aiOrderCreationModelHead, List<AiOrderCreationModelItem> aiOrderCreationModelItemList, List<AiOrderCreationModelExtendItem> aiOrderCreationModelExtendItemList) {
        if (!CollectionUtils.isEmpty(aiOrderCreationModelItemList)) {
            for (AiOrderCreationModelItem aiOrderCreationModelItem : aiOrderCreationModelItemList) {
                aiOrderCreationModelItem.setHeadId(aiOrderCreationModelHead.getId());
                SysUtil.setSysParam((BaseEntity)aiOrderCreationModelItem, (BaseEntity)aiOrderCreationModelHead);
            }
            this.aiOrderCreationModelItemService.saveBatch(aiOrderCreationModelItemList, 2000);
        }
        if (!CollectionUtils.isEmpty(aiOrderCreationModelExtendItemList)) {
            for (AiOrderCreationModelExtendItem aiOrderCreationModelExtendItem : aiOrderCreationModelExtendItemList) {
                aiOrderCreationModelExtendItem.setHeadId(aiOrderCreationModelHead.getId());
                SysUtil.setSysParam((BaseEntity)aiOrderCreationModelExtendItem, (BaseEntity)aiOrderCreationModelHead);
            }
            this.aiOrderCreationModelExtendItemService.saveBatch(aiOrderCreationModelExtendItemList, 2000);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.aiOrderCreationModelItemService.deleteByMainId(id);
        this.aiOrderCreationModelExtendItemService.deleteByMainId(id);
        ((AiOrderCreationModelHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public List<ModelInfo> getAllModels() {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(AiOrderCreationModelHead::getStatus, (Object)"1");
        List modelHeads = this.list((Wrapper)wrapper);
        if (modelHeads.isEmpty()) {
            return Lists.newArrayList();
        }
        List headList = modelHeads.stream().map(BaseEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper itemWrapper = Wrappers.lambdaQuery();
        itemWrapper.in(AiOrderCreationModelItem::getHeadId, headList);
        List items = this.aiOrderCreationModelItemService.list((Wrapper)itemWrapper);
        Map<String, List<AiOrderCreationModelItem>> groupItemMap = items.stream().collect(Collectors.groupingBy(AiOrderCreationModelItem::getHeadId));
        ArrayList<ModelInfo> allModels = new ArrayList<ModelInfo>();
        Map<String, Long> countMap = items.stream().collect(Collectors.groupingBy(AiOrderCreationModelItem::getModelFieldName, Collectors.counting()));
        for (AiOrderCreationModelHead head : modelHeads) {
            ModelInfo modelInfo = new ModelInfo();
            modelInfo.setModelName(head.getModelName());
            modelInfo.setModelId(head.getId());
            ArrayList aiOrderCreationModelItems = groupItemMap.get(head.getId());
            if (null == aiOrderCreationModelItems) {
                aiOrderCreationModelItems = Lists.newArrayList();
            }
            List<FieldSpec> lastItemList = aiOrderCreationModelItems.stream().map(x -> {
                FieldSpec fieldSpec = new FieldSpec();
                fieldSpec.setFieldName(x.getModelFieldName());
                fieldSpec.setFieldCode(x.getModelFieldCode());
                fieldSpec.setFieldAlias((List<String>)(CharSequenceUtil.isEmpty((CharSequence)x.getModelFieldAlias()) ? Lists.newArrayList() : Arrays.stream(x.getModelFieldAlias().split(",")).toList()));
                fieldSpec.setTimes((Long)countMap.get(x.getModelFieldName()));
                return fieldSpec;
            }).collect(Collectors.toList());
            modelInfo.setFieldSpecs(lastItemList);
            allModels.add(modelInfo);
        }
        return allModels;
    }
}

