/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core.modelStrategy;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.modules.ai.core.helper.AiChatResponseHelper;
import com.els.modules.ai.core.modelStrategy.SimpleAiLogicRunStrategy;
import com.els.modules.ai.core.util.AiBeanFactory;
import com.els.modules.ai.pojo.AiChatAppPojo;
import com.els.modules.ai.pojo.AiChatExamplarPojo;
import com.els.modules.ai.pojo.AiChatModelConfigPojo;
import com.els.modules.ai.pojo.AiChatPojo;
import com.els.modules.ai.pojo.LlmRequestPojo;
import com.els.modules.ai.pojo.LlmResponsePojo;
import com.els.modules.ai.pojo.QuestionInfoPojo;
import com.google.common.collect.Lists;
import dev.langchain4j.model.input.Prompt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;

@Service
public class FileAiLogicRunStrategy
extends SimpleAiLogicRunStrategy
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(FileAiLogicRunStrategy.class);
    public static final String INSTRUCTION = "#\u89d2\u8272: \u8bf7\u4f5c\u4e3a\u6587\u4ef6\u6570\u636e\u63d0\u53d6\u4e13\u5bb6\uff0c\u5e2e\u6211\u89e3\u6790\u63d0\u53d6\u6587\u4ef6\u4e2d\u7684\u6570\u636e\uff0c\u6309\u7167\u4e0b\u9762\u7684\u8981\u6c42\u8fd4\u56de\u6570\u636e\u3002\n#Exemplars: {{exemplar}}\n#Query:\nQuestion:{{question}} \nquestionSchema:{{questionSchema}} \nSideInfo:{{information}} ";

    @Override
    String modelRunStrategy() {
        return "fileAiLogicRunStrategy";
    }

    @Override
    public LlmResponsePojo generate(LlmRequestPojo llmRequest) {
        LlmResponsePojo llmResponse = new LlmResponsePojo();
        AiChatPojo chatChatConfig = llmRequest.getAiChatPojo();
        AiChatAppPojo chatAppConfig = llmRequest.getAiChatAppPojo();
        if (CollectionUtil.isEmpty((Collection)chatChatConfig.getFileList())) {
            throw new ELSBootException("\u6587\u4ef6\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QuestionInfoPojo question = chatChatConfig.getQuestion();
        String questionText = CharSequenceUtil.isEmpty((CharSequence)question.getQuestion()) ? chatAppConfig.getQuestion() : question.getQuestion();
        llmResponse.setQuestion(questionText);
        List<List<AiChatExamplarPojo>> exemplarsList = this.promptHelper.getFewShotExemplars(llmRequest);
        AiChatAppPojo chatApp = llmRequest.getAiChatAppPojo();
        if (StrUtil.isBlank((CharSequence)chatApp.getPromptTemplate())) {
            chatApp.setPromptTemplate(this.getInstruction());
        }
        HashMap<Prompt, List<AiChatExamplarPojo>> prompt2Exemplar = new HashMap<Prompt, List<AiChatExamplarPojo>>();
        for (List<AiChatExamplarPojo> exemplars : exemplarsList) {
            llmRequest.setChatExamplers(exemplars);
            Prompt prompt2 = this.generatePrompt(llmRequest, llmResponse, chatApp);
            prompt2Exemplar.put(prompt2, exemplars);
        }
        AiChatModelConfigPojo aiChatModelConfigPojo = chatApp.getAiChatModelConfigPojo();
        JSONObject param = new JSONObject();
        param.put("model", (Object)aiChatModelConfigPojo.getModelName());
        JSONObject messages = new JSONObject();
        messages.put("role", (Object)"user");
        param.put("messages", (Object)Lists.newArrayList((Object[])new JSONObject[]{messages}));
        param.put("plugins", (Object)Lists.newArrayList((Object[])new String[]{"ChatFilePlus"}));
        param.put("stream", (Object)false);
        JSONObject plugin_options = new JSONObject();
        param.put("plugin_options", (Object)plugin_options);
        JSONObject plugin_args = new JSONObject();
        plugin_options.put("plugin_args", (Object)plugin_args);
        JSONObject ChatFilePlus = new JSONObject();
        plugin_args.put("ChatFilePlus", (Object)ChatFilePlus);
        JSONObject body = new JSONObject();
        ChatFilePlus.put("body", (Object)body);
        ArrayList<List> files = new ArrayList<List>();
        files.add(llmRequest.getAiChatPojo().getFileList());
        body.put("files", files);
        ConcurrentHashMap output2Prompt = new ConcurrentHashMap();
        prompt2Exemplar.keySet().parallelStream().forEach(prompt -> {
            llmResponse.setQuestionInput(prompt.toUserMessage().singleText());
            messages.put("content", (Object)prompt.toUserMessage().singleText());
            HashMap<String, Object> header = new HashMap<String, Object>();
            header.put("Authorization", "Bearer " + aiChatModelConfigPojo.getApiKey());
            header.put("Content-Type", "application/json");
            HttpResponse execute = ((HttpRequest)HttpUtil.createPost((String)aiChatModelConfigPojo.getBaseUrl()).body(param.toJSONString()).addHeaders(header)).execute();
            String result = execute.body();
            output2Prompt.put(result, prompt);
        });
        AiChatResponseHelper responseHelper = AiBeanFactory.getAiChatResponseHelper(chatAppConfig.getModelRunResponseHelper());
        Pair<String, Map<String, Double>> sqlMapPair = responseHelper.selfConsistencyVote(Lists.newArrayList(output2Prompt.keySet()));
        llmResponse.setResultText((String)sqlMapPair.getLeft());
        return llmResponse;
    }

    @Override
    public String getInstruction() {
        return INSTRUCTION;
    }
}

