/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ainpl.core;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SqlInjectionUtil;
import com.els.common.util.SysUtil;
import com.els.modules.ainpl.core.ConditionMapping;
import com.els.modules.ainpl.vo.AiOrderCreationFiledSchemaDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DictConditionMapping
implements ConditionMapping<JSONObject> {
    @Override
    public String type() {
        return "dictMapping";
    }

    @Override
    public JSONObject mapping(JSONObject condition, List<AiOrderCreationFiledSchemaDTO> filedSchema) {
        Map filedMap = filedSchema.stream().collect(Collectors.toMap(AiOrderCreationFiledSchemaDTO::getFieldCode, Function.identity(), (v1, v2) -> v2));
        for (String key : condition.keySet()) {
            AiOrderCreationFiledSchemaDTO schemaDTO = (AiOrderCreationFiledSchemaDTO)filedMap.get(key);
            if (null == schemaDTO || CharSequenceUtil.isEmpty((CharSequence)schemaDTO.getFieldDictCode())) continue;
            Object o = condition.get((Object)key);
            String value = ObjectUtil.toString((Object)o);
            StringBuilder sb = new StringBuilder("");
            List<String> listValue = new ArrayList<String>();
            if (null != value && value.contains(",")) {
                listValue = Arrays.stream(value.split(",")).toList();
            } else {
                listValue.add(value);
            }
            for (String text : listValue) {
                String dictValue = this.getDictValue(schemaDTO.getFieldDictCode(), text);
                sb.append(dictValue).append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
            String lastValue = sb.toString();
            condition.put(key, (Object)lastValue);
        }
        return condition;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getDictValue(String dictCode, String text) {
        String val = text;
        if (!dictCode.contains("#")) {
            if (!dictCode.contains(",")) return ((InvokeBaseRpcService)SpringContextUtils.getBean(InvokeBaseRpcService.class)).queryDictCodeByText(dictCode, val, SysUtil.getLoginUser().getElsAccount());
        }
        String[] params = null;
        params = dictCode.contains("#") ? dictCode.split("#") : dictCode.split(",");
        if (params.length < 3) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_JCWWWWmKxiR_bc91c337", (String)"\u5b57\u5178Code\u683c\u5f0f\u4e0d\u6b63\u786e"));
        }
        String[] sqlInjCheck = new String[]{params[0], params[1], params[2]};
        SqlInjectionUtil.filterContent((String[])sqlInjCheck);
        if (params.length != 4) throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_JCxzE_2d5d1760", (String)"\u5b57\u5178\u4e0d\u5339\u914d"));
        String filterSql = params[3] + " and " + params[1] + " = '" + val + "'";
        SqlInjectionUtil.filterContent((String)filterSql);
        return ((InvokeBaseRpcService)SpringContextUtils.getBean(InvokeBaseRpcService.class)).queryTableDictItemsByValue(params[0], params[1], params[2], filterSql, val, SysUtil.getLoginUser().getElsAccount());
    }
}

