/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.util.SysUtil;
import com.els.modules.ai.core.modelStrategy.AiLogicRunStrategy;
import com.els.modules.ai.core.util.AiBeanFactory;
import com.els.modules.ai.entity.AiChatResultLog;
import com.els.modules.ai.pojo.AiChatAppPojo;
import com.els.modules.ai.pojo.AiChatExamplarPojo;
import com.els.modules.ai.pojo.AiChatModelConfigPojo;
import com.els.modules.ai.pojo.AiChatPojo;
import com.els.modules.ai.pojo.AiOrderCreationCheckPojo;
import com.els.modules.ai.pojo.LlmRequestPojo;
import com.els.modules.ai.pojo.LlmResponsePojo;
import com.els.modules.ai.pojo.QuestionInfoPojo;
import com.els.modules.ai.service.AiChatAppService;
import com.els.modules.ai.service.AiChatExamplarService;
import com.els.modules.ai.service.AiChatModelConfigService;
import com.els.modules.ai.service.AiChatResultLogService;
import com.els.modules.ainpl.core.DictConditionMapping;
import com.els.modules.ainpl.core.FiledConditionMapping;
import com.els.modules.ainpl.core.SessionBuilder;
import com.els.modules.ainpl.entity.AiOrderCreationDialogAiSession;
import com.els.modules.ainpl.entity.AiOrderCreationModelHead;
import com.els.modules.ainpl.entity.AiOrderCreationModelItem;
import com.els.modules.ainpl.enums.AiOrderCreationSessionStatus;
import com.els.modules.ainpl.service.AiOrderCreationDialogAiSessionService;
import com.els.modules.ainpl.service.AiOrderCreationModelHeadService;
import com.els.modules.ainpl.service.AiOrderCreationModelItemService;
import com.els.modules.ainpl.vo.AiOrderCreationCurrentSession;
import com.els.modules.ainpl.vo.AiOrderCreationFiledSchemaDTO;
import com.els.modules.ainpl.vo.AiOrderCreationRequestDTO;
import com.els.modules.ainpl.vo.AiOrderCreationRunDTO;
import com.els.modules.ainpl.vo.AiOrderCreationSessionDTO;
import com.els.modules.ainpl.vo.AiOrderCreationUnCompletedSession;
import com.els.modules.system.rpc.service.BaseInvokeAiChatRpcService;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class AiRequestService {
    private static final Logger log = LoggerFactory.getLogger(AiRequestService.class);
    @Resource
    private AiChatAppService aiChatAppService;
    @Resource
    private AiChatExamplarService aiChatExamplarService;
    @Resource
    private AiChatResultLogService aiChatResultLogService;
    @Resource
    private AiChatModelConfigService aiChatModelConfigService;
    @Autowired
    private SessionBuilder sessionBuilder;
    @Autowired
    private BaseInvokeAiChatRpcService baseInvokeAiChatRpcService;
    @Autowired
    private AiOrderCreationModelHeadService aiOrderCreationModelHeadService;
    @Autowired
    private AiOrderCreationDialogAiSessionService aiOrderCreationDialogAiSessionService;
    @Autowired
    private AiOrderCreationModelItemService aiOrderCreationModelItemService;

    @Transactional(rollbackFor={Exception.class})
    public LlmResponsePojo runChat(LlmRequestPojo llmRequest) {
        AiChatPojo chatDto = llmRequest.getAiChatPojo();
        if (null == chatDto) {
            throw new ELSBootException("\u8c03\u7528\u7684APP\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        AiChatAppPojo chatAppConfig = this.aiChatAppService.loadAiChatAppByCode(chatDto.getAppCode(), SysUtil.getLoginUser().getElsAccount());
        chatDto.setLanguage("zh");
        chatDto.setCurrentDate(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        QuestionInfoPojo questionInfo = chatDto.getQuestion();
        if (CharSequenceUtil.isEmpty((CharSequence)questionInfo.getQuestion())) {
            questionInfo.setQuestion(chatAppConfig.getQuestion());
        }
        List<AiChatExamplarPojo> chatExamplers = this.aiChatExamplarService.loadExamplersByCode(chatDto.getAppCode(), SysUtil.getLoginUser().getElsAccount());
        llmRequest.setAiChatPojo(chatDto);
        llmRequest.setAiChatAppPojo(chatAppConfig);
        llmRequest.setChatExamplers(chatExamplers);
        AiChatModelConfigPojo aiChatModelConfigDto = this.aiChatModelConfigService.loadModelConfigByProvider(chatAppConfig.getModelProvider(), chatAppConfig.getModelName(), SysUtil.getLoginUser().getElsAccount());
        chatAppConfig.setAiChatModelConfigPojo(aiChatModelConfigDto);
        AiLogicRunStrategy runStrategy = AiBeanFactory.getAiLogicRunStrategy(chatAppConfig.getModelRunStrategy());
        LlmResponsePojo result = runStrategy.generate(llmRequest);
        result.setQuestion(questionInfo.getQuestion());
        AiChatResultLog log = new AiChatResultLog();
        log.setElsAccount(SysUtil.getLoginUser().getElsAccount());
        log.setBusinessId(questionInfo.getBusinessId());
        log.setBusinessNumber(questionInfo.getBusinessNumber());
        log.setBusinessType(questionInfo.getBusinessType());
        log.setBusinessName(questionInfo.getBusinessName());
        log.setQuestionInput(result.getQuestionInput());
        log.setQuestionResult(result.getResultText());
        log.setAppCode(chatDto.getAppCode());
        this.aiChatResultLogService.add(log);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public AiOrderCreationSessionDTO runAiOrderCreationChat(AiOrderCreationRequestDTO requestDTO) {
        try {
            AiOrderCreationCheckPojo creationCheckPojo;
            requestDTO.setUserId(SysUtil.getLoginUser().getId());
            AiOrderCreationUnCompletedSession unCompletedSession = this.sessionBuilder.findUnCompletedSessionByRequest(requestDTO);
            AiOrderCreationCurrentSession currentSession = this.sessionBuilder.buildNewSessionByRequest(requestDTO, unCompletedSession);
            LlmRequestPojo llmRequest = new LlmRequestPojo();
            QuestionInfoPojo questionInfo = new QuestionInfoPojo();
            questionInfo.setQuestion(currentSession.getQueryText());
            HashMap<String, String> questionSchemaMap = new HashMap<String, String>();
            this.sessionBuilder.buildQuestionSchema(currentSession, unCompletedSession, questionSchemaMap);
            questionInfo.setQuestionSchema((String)questionSchemaMap.remove("questionSchema"));
            questionInfo.setQuestionSchemaMap(questionSchemaMap);
            questionInfo.setBusinessType(currentSession.getBusinessType());
            AiChatPojo chatChatConfig = new AiChatPojo();
            chatChatConfig.setAppCode("AiOrderCreation");
            chatChatConfig.setQuestion(questionInfo);
            llmRequest.setAiChatPojo(chatChatConfig);
            LlmResponsePojo llmResponsePojo = this.runChat(llmRequest);
            String resultText = llmResponsePojo.getResultText();
            currentSession.setQueryResult(llmResponsePojo.getThought());
            currentSession.setFinalCondition(resultText);
            JSONObject conditionJsonObject = JSON.parseObject((String)resultText);
            FiledConditionMapping filedConditionMapping = new FiledConditionMapping();
            JSONObject mappingCondition = filedConditionMapping.mapping(conditionJsonObject, currentSession.getSchemaList());
            currentSession.setFinalConditionText(mappingCondition.toString());
            this.sessionBuilder.saveUserSession(currentSession, unCompletedSession);
            try {
                DictConditionMapping dictConditionMapping = new DictConditionMapping();
                JSONObject condition = dictConditionMapping.mapping(JSON.parseObject((String)resultText), currentSession.getSchemaList());
                creationCheckPojo = this.baseInvokeAiChatRpcService.getAiOrderCreationRpcService(currentSession.getBeanImpl()).check(currentSession.getBusinessType(), SysUtil.getLoginUser().getElsAccount(), condition);
            }
            catch (Exception e) {
                log.error("AI\u521b\u5efa\u5355\u636e\u6570\u636e\u68c0\u6d4b\u62a5\u9519:{}", (Object)e.getMessage());
                String message = e.getMessage();
                creationCheckPojo = new AiOrderCreationCheckPojo();
                creationCheckPojo.setCheckPass(false);
                creationCheckPojo.setCount(0);
                creationCheckPojo.setCheckMessage(message);
            }
            AiOrderCreationDialogAiSession aiSession = this.sessionBuilder.saveAiSession(currentSession, unCompletedSession, creationCheckPojo, llmResponsePojo);
            AiOrderCreationSessionDTO result = new AiOrderCreationSessionDTO();
            BeanUtils.copyProperties((Object)((Object)aiSession), (Object)result);
            return result;
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
    }

    @SrmTransaction(rollbackFor={Exception.class})
    public void execAiOrderCreation(AiOrderCreationRunDTO runDTO) {
        AiOrderCreationModelHead modelHead = (AiOrderCreationModelHead)((Object)this.aiOrderCreationModelHeadService.getById((Serializable)((Object)runDTO.getDataModelId())));
        if (null == modelHead) {
            throw new ELSBootException("\u6570\u636e\u6a21\u578b\u4e0d\u5b58\u5728");
        }
        AiOrderCreationDialogAiSession aiSession = (AiOrderCreationDialogAiSession)((Object)this.aiOrderCreationDialogAiSessionService.getById((Serializable)((Object)runDTO.getAiSessionId())));
        if (null == aiSession) {
            throw new ELSBootException("AI\u5206\u6790\u7ed3\u679c\u4e0d\u5b58\u5728");
        }
        List<AiOrderCreationModelItem> modelItems = this.aiOrderCreationModelItemService.selectByMainId(runDTO.getDataModelId());
        if (CollectionUtil.isEmpty(modelItems)) {
            throw new ELSBootException("\u6570\u636e\u6a21\u578b\u5b57\u6bb5\u4e0d\u5b58\u5728");
        }
        List<AiOrderCreationFiledSchemaDTO> schemaList = modelItems.stream().map(x -> {
            AiOrderCreationFiledSchemaDTO schemaDTO = new AiOrderCreationFiledSchemaDTO();
            schemaDTO.setFieldName(x.getModelFieldName());
            schemaDTO.setFieldCode(x.getModelFieldCode());
            schemaDTO.setFieldType(x.getModelFieldType());
            schemaDTO.setFieldDictCode(x.getModelFieldDict());
            return schemaDTO;
        }).collect(Collectors.toList());
        JSONObject jsonObject = JSON.parseObject((String)aiSession.getFinalCondition());
        FiledConditionMapping filedConditionMapping = new FiledConditionMapping();
        JSONObject condition = filedConditionMapping.mapping(jsonObject, schemaList);
        this.baseInvokeAiChatRpcService.getAiOrderCreationRpcService(modelHead.getBeanImpl()).run(modelHead.getBusinessType(), SysUtil.getLoginUser().getElsAccount(), condition);
        aiSession.setStatus(AiOrderCreationSessionStatus.COMPLETED.getCode());
        this.aiOrderCreationDialogAiSessionService.updateById((Object)aiSession);
    }
}

