/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.template.service.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.ConfigUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.LoginUserContext;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.language.entity.I18n;
import com.els.modules.language.service.I18nService;
import com.els.modules.system.service.CodeGeneratorService;
import com.els.modules.template.entity.TemplateConfigHead;
import com.els.modules.template.entity.TemplateConfigHeadHis;
import com.els.modules.template.entity.TemplateConfigItem;
import com.els.modules.template.entity.TemplateConfigItemHis;
import com.els.modules.template.entity.TemplateGroup;
import com.els.modules.template.entity.TemplateGroupHis;
import com.els.modules.template.entity.TemplateHead;
import com.els.modules.template.entity.TemplateHeadHis;
import com.els.modules.template.enumerate.TemplateStatusEnum;
import com.els.modules.template.mapper.TemplateConfigHeadMapper;
import com.els.modules.template.mapper.TemplateConfigItemMapper;
import com.els.modules.template.mapper.TemplateGroupMapper;
import com.els.modules.template.mapper.TemplateHeadMapper;
import com.els.modules.template.service.TemplateConfigHeadService;
import com.els.modules.template.service.TemplateConfigItemService;
import com.els.modules.template.service.TemplateGroupService;
import com.els.modules.template.service.TemplateHeadHisService;
import com.els.modules.template.service.TemplateHeadService;
import com.els.modules.template.util.CreateJsonFileUtil;
import com.els.modules.template.vo.TemplateHeadHisVO;
import com.els.modules.template.vo.TemplateHeadImportVO;
import com.els.modules.template.vo.TemplateHeadVO;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class TemplateHeadServiceImpl
extends ServiceImpl<TemplateHeadMapper, TemplateHead>
implements TemplateHeadService {
    private static final Logger log = LoggerFactory.getLogger(TemplateHeadServiceImpl.class);
    private static final String TEMPLATE_VO_REDIS_KEY = "srm:base:template:vo:";
    private static final String TEMPLATE_DICT_MAP_REDIS_KEY = "srm:base:template:dictMap:";
    @Resource
    private TemplateHeadMapper templateHeadMapper;
    @Resource
    private TemplateGroupMapper templateGroupMapper;
    @Resource
    private TemplateConfigHeadMapper templateConfigHeadMapper;
    @Resource
    private TemplateConfigItemMapper templateConfigItemMapper;
    @Autowired
    private CodeGeneratorService codeGeneratorService;
    @Autowired
    private TemplateHeadHisService templateHeadHisService;
    @Autowired
    private TemplateConfigItemService templateConfigItemService;
    @Autowired
    private I18nService i18nService;
    @Autowired
    private TemplateConfigHeadService templateConfigHeadService;
    @Autowired
    private TemplateGroupService templateGroupService;
    @Autowired
    private RedisUtil redisUtil;
    @Resource(name="srmPoolExecutor")
    public ThreadPoolExecutor srmPoolExecutor;
    public static final String ADDRESS = "srm:template:";

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(TemplateHead templateHead, List<TemplateGroup> templateGroupList, List<TemplateConfigHead> templateConfigHeadList, List<TemplateConfigItem> templateConfigItemList) {
        String templateNumber = this.codeGeneratorService.getNextCode("srmTemplateNumber", (Object)templateHead);
        templateHead.setTemplateNumber(templateNumber);
        templateHead.setTemplateVersion(1);
        if (StrUtil.isEmpty((CharSequence)templateHead.getTemplateStatus())) {
            templateHead.setTemplateStatus(TemplateStatusEnum.NEW.getValue());
        }
        this.templateHeadMapper.insert((Object)templateHead);
        this.insertData(templateHead, templateGroupList, templateConfigHeadList, templateConfigItemList);
    }

    private String getRedisKey(String elsAccount, String templateNumber, String templateVersion) {
        StringBuilder builder = new StringBuilder(TEMPLATE_VO_REDIS_KEY);
        builder.append(elsAccount).append(":").append(templateNumber).append(":").append(templateVersion);
        return builder.toString();
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(TemplateHead templateHead, List<TemplateGroup> templateGroupList, List<TemplateConfigHead> templateConfigHeadList, List<TemplateConfigItem> templateConfigItemList) {
        if (StrUtil.isBlank((CharSequence)templateHead.getTemplateStatus())) {
            templateHead.setTemplateStatus(TemplateStatusEnum.NEW.getValue());
        }
        this.templateHeadMapper.updateById((Object)templateHead);
        this.templateGroupMapper.deleteByMainId(templateHead.getId());
        this.templateConfigHeadMapper.deleteByMainId(templateHead.getId());
        this.templateConfigItemMapper.deleteByMainId(templateHead.getId());
        this.insertData(templateHead, templateGroupList, templateConfigHeadList, templateConfigItemList);
        this.clearRedisCache(TenantContext.getTenant(), templateHead.getId(), templateHead.getBusinessType());
        this.redisUtil.del(new String[]{this.getRedisKey(templateHead.getElsAccount(), templateHead.getTemplateNumber(), "" + templateHead.getTemplateVersion())});
    }

    private void insertData(TemplateHead templateHead, List<TemplateGroup> templateGroupList, List<TemplateConfigHead> templateConfigHeadList, List<TemplateConfigItem> templateConfigItemList) {
        String field;
        List collect = templateGroupList.parallelStream().filter(item -> StrUtil.isBlank((CharSequence)item.getGroupNameI18nKey())).map(item -> item.getGroupName()).collect(Collectors.toList());
        List collect1 = templateConfigHeadList.parallelStream().filter(item -> StrUtil.isBlank((CharSequence)item.getFieldLabelI18nKey())).distinct().map(item -> item.getFieldLabel()).collect(Collectors.toList());
        List collect2 = templateConfigItemList.parallelStream().filter(item -> StrUtil.isBlank((CharSequence)item.getFieldLabelI18nKey())).distinct().map(item -> item.getFieldLabel()).collect(Collectors.toList());
        List alertheadlist = templateConfigHeadList.parallelStream().filter(item -> StrUtil.isBlank((CharSequence)item.getAlertMsgI18nKey())).distinct().map(item -> item.getAlertMsg()).collect(Collectors.toList());
        List alertitemlist = templateConfigItemList.parallelStream().filter(item -> StrUtil.isBlank((CharSequence)item.getAlertMsgI18nKey())).distinct().map(item -> item.getAlertMsg()).collect(Collectors.toList());
        collect.addAll(collect1);
        collect.addAll(collect2);
        collect.addAll(alertitemlist);
        collect.addAll(alertheadlist);
        Map<Object, Object> stringMap = new HashMap();
        if (!CollectionUtils.isEmpty(collect)) {
            List zh = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.i18nService.lambdaQuery().eq(I18n::getLanguage, (Object)"zh")).in(I18n::getI18nValue, collect)).list();
            stringMap = zh.stream().collect(Collectors.toMap(I18n::getI18nValue, I18n::getI18nKey, (key1, key2) -> key2));
        }
        HashMap<String, String> noKeyHashMap = new HashMap<String, String>();
        for (TemplateGroup templateGroup : templateGroupList) {
            templateGroup.setId(null);
            templateGroup.setHeadId(templateHead.getId());
            SysUtil.setSysParam((BaseEntity)templateGroup, (BaseEntity)templateHead);
            if (!StrUtil.isBlank((CharSequence)templateGroup.getGroupNameI18nKey())) continue;
            if (stringMap.containsKey(templateGroup.getGroupName())) {
                templateGroup.setGroupNameI18nKey((String)stringMap.get(templateGroup.getGroupName()));
                continue;
            }
            field = this.i18nService.createI18nKey(templateGroup.getGroupName(), "field");
            noKeyHashMap.put(templateGroup.getGroupName(), field);
            templateGroup.setGroupNameI18nKey(field);
        }
        if (!templateGroupList.isEmpty()) {
            this.templateGroupService.saveOrUpdateBatch(templateGroupList);
        }
        for (TemplateConfigHead templateConfigHead : templateConfigHeadList) {
            templateConfigHead.setId(null);
            templateConfigHead.setHeadId(templateHead.getId());
            templateConfigHead.setPurchaseEdit(templateConfigHead.getPurchaseEdit() == null ? "0" : templateConfigHead.getPurchaseEdit());
            templateConfigHead.setPurchaseShow(templateConfigHead.getPurchaseShow() == null ? "0" : templateConfigHead.getPurchaseShow());
            templateConfigHead.setSaleEdit(templateConfigHead.getSaleEdit() == null ? "0" : templateConfigHead.getSaleEdit());
            templateConfigHead.setSaleShow(templateConfigHead.getSaleShow() == null ? "0" : templateConfigHead.getSaleShow());
            templateConfigHead.setRequired(templateConfigHead.getRequired() == null ? "0" : templateConfigHead.getRequired());
            templateConfigHead.setAudited(templateConfigHead.getAudited() == null ? "1" : templateConfigHead.getAudited());
            templateConfigHead.setSys(templateConfigHead.getSys() == null ? "0" : templateConfigHead.getSys());
            SysUtil.setSysParam((BaseEntity)templateConfigHead, (BaseEntity)templateHead);
            if (StrUtil.isBlank((CharSequence)templateConfigHead.getFieldLabelI18nKey())) {
                if (stringMap.containsKey(templateConfigHead.getFieldLabel())) {
                    templateConfigHead.setFieldLabelI18nKey((String)stringMap.get(templateConfigHead.getFieldLabel()));
                } else {
                    field = this.i18nService.createI18nKey(templateConfigHead.getFieldLabel(), "field");
                    noKeyHashMap.put(templateConfigHead.getFieldLabel(), field);
                    templateConfigHead.setFieldLabelI18nKey(field);
                }
            }
            if (!StrUtil.isBlank((CharSequence)templateConfigHead.getAlertMsgI18nKey()) || StrUtil.isBlank((CharSequence)templateConfigHead.getAlertMsg())) continue;
            if (stringMap.containsKey(templateConfigHead.getAlertMsg())) {
                templateConfigHead.setAlertMsgI18nKey((String)stringMap.get(templateConfigHead.getAlertMsg()));
                continue;
            }
            field = this.i18nService.createI18nKey(templateConfigHead.getAlertMsg(), "alert");
            noKeyHashMap.put(templateConfigHead.getAlertMsg(), field);
            templateConfigHead.setAlertMsgI18nKey(field);
        }
        if (!templateConfigHeadList.isEmpty()) {
            ((TemplateConfigHeadService)SpringContextUtils.getBean(TemplateConfigHeadService.class)).saveBatch(templateConfigHeadList);
        }
        for (TemplateConfigItem templateConfigItem : templateConfigItemList) {
            templateConfigItem.setId(null);
            templateConfigItem.setHeadId(templateHead.getId());
            templateConfigItem.setPurchaseEdit(templateConfigItem.getPurchaseEdit() == null ? "0" : templateConfigItem.getPurchaseEdit());
            templateConfigItem.setPurchaseShow(templateConfigItem.getPurchaseShow() == null ? "0" : templateConfigItem.getPurchaseShow());
            templateConfigItem.setSaleEdit(templateConfigItem.getSaleEdit() == null ? "0" : templateConfigItem.getSaleEdit());
            templateConfigItem.setSaleShow(templateConfigItem.getSaleShow() == null ? "0" : templateConfigItem.getSaleShow());
            templateConfigItem.setRequired(templateConfigItem.getRequired() == null ? "0" : templateConfigItem.getRequired());
            templateConfigItem.setAudited(templateConfigItem.getAudited() == null ? "1" : templateConfigItem.getAudited());
            templateConfigItem.setSys(templateConfigItem.getSys() == null ? "0" : templateConfigItem.getSys());
            SysUtil.setSysParam((BaseEntity)templateConfigItem, (BaseEntity)templateHead);
            if (StrUtil.isBlank((CharSequence)templateConfigItem.getFieldLabelI18nKey())) {
                if (stringMap.containsKey(templateConfigItem.getFieldLabel())) {
                    templateConfigItem.setFieldLabelI18nKey((String)stringMap.get(templateConfigItem.getFieldLabel()));
                } else {
                    field = this.i18nService.createI18nKey(templateConfigItem.getFieldLabel(), "field");
                    noKeyHashMap.put(templateConfigItem.getFieldLabel(), field);
                    templateConfigItem.setFieldLabelI18nKey(field);
                }
            }
            if (!StrUtil.isBlank((CharSequence)templateConfigItem.getAlertMsgI18nKey()) || StrUtil.isBlank((CharSequence)templateConfigItem.getAlertMsg())) continue;
            if (stringMap.containsKey(templateConfigItem.getAlertMsg())) {
                templateConfigItem.setAlertMsgI18nKey((String)stringMap.get(templateConfigItem.getAlertMsg()));
                continue;
            }
            field = this.i18nService.createI18nKey(templateConfigItem.getAlertMsg(), "alert");
            noKeyHashMap.put(templateConfigItem.getAlertMsg(), field);
            templateConfigItem.setAlertMsgI18nKey(field);
        }
        if (!templateConfigItemList.isEmpty()) {
            ((TemplateConfigItemService)SpringContextUtils.getBean(TemplateConfigItemService.class)).saveBatch(templateConfigItemList);
        }
        this.i18nService.addOtherKey(noKeyHashMap);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.templateGroupMapper.deleteByMainId(id);
        this.templateConfigHeadMapper.deleteByMainId(id);
        this.templateConfigItemMapper.deleteByMainId(id);
        this.templateHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.templateGroupMapper.deleteByMainId(serializable.toString());
            this.templateConfigHeadMapper.deleteByMainId(serializable.toString());
            this.templateConfigItemMapper.deleteByMainId(serializable.toString());
            this.templateHeadMapper.deleteById(serializable);
        }
    }

    private void clearRedisCache(String elsAccount, String templateId, String businessType) {
        this.redisUtil.del(new String[]{this.getTemplateRedisKey(templateId)});
        this.redisUtil.del(new String[]{this.getTemplateRedisKey(elsAccount, businessType)});
        String redisKey = this.getTemplateDictMapRedisKey(templateId, "");
        this.redisUtil.deleteByPrex(redisKey);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void copyById(String id) {
        TemplateHead templateHead = (TemplateHead)((Object)this.templateHeadMapper.selectById((Serializable)((Object)id)));
        String templateNumber = this.codeGeneratorService.getNextCode("srmTemplateNumber", (Object)templateHead);
        templateHead.setId(null);
        templateHead.setElsAccount(TenantContext.getTenant());
        templateHead.setTemplateNumber(templateNumber);
        templateHead.setTemplateVersion(1);
        templateHead.setTemplateStatus("0");
        templateHead.setDefaultType("0");
        templateHead.setCreateBy(null);
        templateHead.setCreateTime(null);
        templateHead.setUpdateBy(null);
        templateHead.setUpdateTime(null);
        templateHead.setCreateById(null);
        templateHead.setUpdateById(null);
        this.templateHeadMapper.insert((Object)templateHead);
        List<TemplateGroup> templateGroupList = this.templateGroupMapper.selectByMainId(id);
        for (TemplateGroup templateGroup : templateGroupList) {
            templateGroup.setId(null);
            templateGroup.setElsAccount(TenantContext.getTenant());
            templateGroup.setHeadId(templateHead.getId());
        }
        if (!templateGroupList.isEmpty()) {
            this.templateGroupService.saveOrUpdateBatch(templateGroupList);
        }
        List<TemplateConfigHead> templateConfigHeadList = this.templateConfigHeadMapper.selectByMainId(id);
        for (TemplateConfigHead configHead : templateConfigHeadList) {
            configHead.setId(null);
            configHead.setElsAccount(TenantContext.getTenant());
            configHead.setHeadId(templateHead.getId());
        }
        if (!templateConfigHeadList.isEmpty()) {
            this.templateConfigHeadService.saveOrUpdateBatch(templateConfigHeadList);
        }
        List<TemplateConfigItem> list = this.templateConfigItemMapper.selectByMainId(id);
        for (TemplateConfigItem configItem : list) {
            configItem.setId(null);
            configItem.setElsAccount(TenantContext.getTenant());
            configItem.setHeadId(templateHead.getId());
        }
        if (!list.isEmpty()) {
            this.templateConfigItemService.saveOrUpdateBatch(list);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void upgradeVersion(String id) {
        TemplateHead templateHead = (TemplateHead)((Object)this.templateHeadMapper.selectById((Serializable)((Object)id)));
        TemplateHeadHis headHis = new TemplateHeadHis();
        BeanUtils.copyProperties((Object)((Object)templateHead), (Object)((Object)headHis));
        headHis.setId(null);
        TemplateHead updateHead = new TemplateHead();
        updateHead.setId(templateHead.getId());
        updateHead.setTemplateVersion(templateHead.getTemplateVersion() + 1);
        updateHead.setTemplateStatus(TemplateStatusEnum.NEW.getValue());
        this.templateHeadMapper.updateById((Object)updateHead);
        ArrayList<TemplateGroupHis> templateGroupHisList = new ArrayList<TemplateGroupHis>();
        ArrayList<TemplateConfigHeadHis> templateConfigHeadHisList = new ArrayList<TemplateConfigHeadHis>();
        ArrayList<TemplateConfigItemHis> templateConfigItemHisList = new ArrayList<TemplateConfigItemHis>();
        List<TemplateGroup> templateGroupList = this.templateGroupMapper.selectByMainId(id);
        for (TemplateGroup templateGroup : templateGroupList) {
            TemplateGroupHis groupHis = new TemplateGroupHis();
            BeanUtils.copyProperties((Object)((Object)templateGroup), (Object)((Object)groupHis));
            groupHis.setId(null);
            templateGroupHisList.add(groupHis);
        }
        List<TemplateConfigHead> templateConfigHeadList = this.templateConfigHeadMapper.selectByMainId(id);
        for (TemplateConfigHead configHead : templateConfigHeadList) {
            TemplateConfigHeadHis configHeadHis = new TemplateConfigHeadHis();
            BeanUtils.copyProperties((Object)((Object)configHead), (Object)((Object)configHeadHis));
            configHeadHis.setId(null);
            templateConfigHeadHisList.add(configHeadHis);
        }
        List<TemplateConfigItem> list = this.templateConfigItemMapper.selectByMainId(id);
        for (TemplateConfigItem configItem : list) {
            TemplateConfigItemHis configItemHis = new TemplateConfigItemHis();
            BeanUtils.copyProperties((Object)((Object)configItem), (Object)((Object)configItemHis));
            configItemHis.setId(null);
            templateConfigItemHisList.add(configItemHis);
        }
        this.templateHeadHisService.saveMain(headHis, templateGroupHisList, templateConfigHeadHisList, templateConfigItemHisList);
    }

    @Override
    public TemplateHeadVO getAllConfig(String busAccount, String templateNumber, String templateVersion) {
        StringBuilder redisKey = new StringBuilder(ADDRESS).append(busAccount).append(":").append(templateNumber).append(":").append(templateVersion);
        TemplateHeadVO headVO = (TemplateHeadVO)((Object)this.redisUtil.get(redisKey.toString()));
        if (headVO == null) {
            TemplateHead head;
            headVO = new TemplateHeadVO();
            List headList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BaseEntity::getElsAccount, (Object)busAccount)).eq(TemplateHead::getTemplateNumber, (Object)templateNumber)).eq(TemplateHead::getTemplateVersion, (Object)templateVersion));
            TemplateHead templateHead = head = headList.size() > 0 ? (TemplateHead)((Object)headList.get(0)) : null;
            if (head == null) {
                TemplateHeadHisVO headHisVO = this.templateHeadHisService.getAllConfig(busAccount, templateNumber, templateVersion);
                BeanUtils.copyProperties((Object)((Object)headHisVO), (Object)((Object)headVO));
                ArrayList<TemplateConfigHead> templateConfigHeadList = new ArrayList<TemplateConfigHead>();
                for (TemplateConfigHeadHis headHis : headHisVO.getTemplateConfigHeadHisList()) {
                    TemplateConfigHead configHead = new TemplateConfigHead();
                    BeanUtils.copyProperties((Object)((Object)headHis), (Object)((Object)configHead));
                    templateConfigHeadList.add(configHead);
                }
                headVO.setTemplateConfigHeadList(templateConfigHeadList);
                ArrayList<TemplateConfigItem> templateConfigItemList = new ArrayList<TemplateConfigItem>();
                for (TemplateConfigItemHis itemHis : headHisVO.getTemplateConfigItemHisList()) {
                    TemplateConfigItem configItem = new TemplateConfigItem();
                    BeanUtils.copyProperties((Object)((Object)itemHis), (Object)((Object)configItem));
                    templateConfigItemList.add(configItem);
                }
                headVO.setTemplateConfigItemList(templateConfigItemList);
            } else {
                BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headVO));
                List<TemplateConfigHead> templateConfigHeadList = this.templateConfigHeadMapper.selectByMainId(head.getId());
                headVO.setTemplateConfigHeadList(templateConfigHeadList);
                List<TemplateConfigItem> templateConfigItemList = this.templateConfigItemMapper.selectByMainId(head.getId());
                headVO.setTemplateConfigItemList(templateConfigItemList);
            }
            this.redisUtil.set(redisKey.toString(), (Object)headVO);
        }
        return headVO;
    }

    @Override
    public List<TemplateHead> getAllByAccountAndType(String elsAccount, String businessType) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"els_account", (Object)elsAccount);
        wrapper.eq((Object)"business_type", (Object)businessType);
        wrapper.eq((Object)"template_status", (Object)"1");
        wrapper.eq((Object)"is_deleted", (Object)CommonConstant.DEL_FLAG_0);
        wrapper.eq((Object)"is_default_type", (Object)1);
        wrapper.lambda().orderByDesc(BaseEntity::getCreateTime);
        List list = this.templateHeadMapper.selectList((Wrapper)wrapper);
        List<TemplateHead> result = list.stream().filter(o -> "1".equals(o.getDefaultType())).collect(Collectors.toList());
        if (result.isEmpty()) {
            return list;
        }
        return result;
    }

    @Override
    public List<TemplateHead> getDefaultTemplateByType(String businessType) {
        LambdaQueryWrapper chainWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)chainWrapper.eq(TemplateHead::getBusinessType, (Object)businessType)).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(TemplateHead::getTemplateStatus, (Object)TemplateStatusEnum.GENERATED.getValue())).eq(TemplateHead::getDefaultType, (Object)"1");
        chainWrapper.orderByDesc(BaseEntity::getUpdateTime);
        List list = ((TemplateHeadMapper)this.baseMapper).selectList((Wrapper)chainWrapper);
        if (list.isEmpty()) {
            chainWrapper.clear();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)chainWrapper.eq(TemplateHead::getBusinessType, (Object)businessType)).eq(BaseEntity::getElsAccount, (Object)"100000")).eq(TemplateHead::getDefaultType, (Object)"1")).eq(TemplateHead::getTemplateStatus, (Object)TemplateStatusEnum.GENERATED.getValue());
            chainWrapper.orderByDesc(BaseEntity::getUpdateTime);
            list = ((TemplateHeadMapper)this.baseMapper).selectList((Wrapper)chainWrapper);
        }
        if (list.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_VERWWWWWWUEtCLIr_5d28d2fe", (String)"\u8bf7\u914d\u7f6e[${0}]\u5e73\u53f0\u7ea7\u9ed8\u8ba4\u6a21\u677f", (String[])new String[]{businessType}));
        }
        return list;
    }

    @Override
    public TemplateHead getDefaultOneTemplateByType(String businessType) {
        return this.getDefaultTemplateByType(businessType).get(0);
    }

    @Override
    public TemplateHeadVO selectVoById(String templateId) {
        TemplateHead templateHead = (TemplateHead)((Object)((TemplateHeadMapper)this.baseMapper).selectById((Serializable)((Object)templateId)));
        TemplateHeadVO vo = (TemplateHeadVO)((Object)Convert.convert(TemplateHeadVO.class, (Object)((Object)templateHead)));
        List<TemplateGroup> templateGroups = this.templateGroupMapper.selectByMainId(templateId);
        List<TemplateConfigHead> templateConfigHeads = this.templateConfigHeadMapper.selectByMainId(templateId);
        List<TemplateConfigItem> templateConfigItems = this.templateConfigItemMapper.selectByMainId(templateId);
        vo.setTemplateGroupList(templateGroups);
        vo.setTemplateConfigHeadList(templateConfigHeads);
        vo.setTemplateConfigItemList(templateConfigItems);
        return vo;
    }

    @Override
    public void addTempleI18nKey() {
        List collect1;
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.templateGroupService.lambdaQuery().and(p -> ((LambdaQueryWrapper)((LambdaQueryWrapper)p.isNull(TemplateGroup::getGroupNameI18nKey)).or()).eq(TemplateGroup::getGroupNameI18nKey, (Object)""))).eq(BaseEntity::getElsAccount, (Object)"100000")).list();
        List listHead = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.templateConfigHeadService.lambdaQuery().and(p -> ((LambdaQueryWrapper)((LambdaQueryWrapper)p.isNull(TemplateConfigHead::getFieldLabelI18nKey)).or()).eq(TemplateConfigHead::getFieldLabelI18nKey, (Object)""))).eq(BaseEntity::getElsAccount, (Object)"100000")).list();
        List listItem = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.templateConfigItemService.lambdaQuery().and(p -> ((LambdaQueryWrapper)((LambdaQueryWrapper)p.isNull(TemplateConfigItem::getFieldLabelI18nKey)).or()).eq(TemplateConfigItem::getFieldLabelI18nKey, (Object)""))).eq(BaseEntity::getElsAccount, (Object)"100000")).list();
        ArrayList<String> collect = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            collect = list.parallelStream().map(o -> o.getGroupName()).distinct().collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty((Collection)listHead)) {
            collect1 = listHead.parallelStream().map(o -> o.getFieldLabel()).distinct().collect(Collectors.toList());
            collect.addAll(collect1);
        }
        if (!CollectionUtils.isEmpty((Collection)listItem)) {
            collect1 = listItem.parallelStream().map(o -> o.getFieldLabel()).distinct().collect(Collectors.toList());
            collect.addAll(collect1);
        }
        if (!CollectionUtils.isEmpty(collect)) {
            Map<String, String> stringStringMap = this.i18nService.checkAndAdd(collect, "field");
            list.forEach(item -> item.setGroupNameI18nKey((String)stringStringMap.get(item.getGroupName())));
            listHead.forEach(item -> item.setFieldLabelI18nKey((String)stringStringMap.get(item.getFieldLabel())));
            listItem.forEach(item -> item.setFieldLabelI18nKey((String)stringStringMap.get(item.getFieldLabel())));
            this.templateGroupService.updateBatchById(list);
            this.templateConfigHeadService.updateBatchById(listHead);
            this.templateConfigItemService.updateBatchById(listItem);
        }
    }

    @Override
    public void exportJson(TemplateHead templateHead, HttpServletRequest req, HttpServletResponse res) throws Exception {
        String selections = req.getParameter("selections");
        List<Object> dataList = new ArrayList();
        List templateHeadList = null;
        if (StrUtil.isNotBlank((CharSequence)selections)) {
            queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"id", (Object[])selections.split(","));
            templateHeadList = this.list((Wrapper)queryWrapper);
        } else {
            queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)templateHead), (Map)req.getParameterMap());
            if (StrUtil.isNotBlank((CharSequence)templateHead.getElsAccount())) {
                queryWrapper.eq((Object)"els_account", (Object)templateHead.getElsAccount());
            } else {
                queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
            }
            templateHeadList = this.list((Wrapper)queryWrapper);
        }
        if (templateHeadList.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_importData_empty", (String)"\u5bfc\u51fa\u7684\u6570\u636e\u4e3a\u7a7a\uff01"));
        }
        List<String> templateIds = templateHeadList.parallelStream().map(BaseEntity::getId).collect(Collectors.toList());
        dataList = this.assembleTemplateHeadVOInfo(templateHeadList, templateIds);
        JSONArray jsonObject = JSONArray.parseArray((String)JSON.toJSONString(dataList));
        CreateJsonFileUtil.createFile(jsonObject.toString(), "", res);
    }

    @Override
    public void importJson(List<TemplateHeadVO> headVOList) {
        String elsAccount = TenantContext.getTenant();
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        List templateNumberList = headVOList.parallelStream().map(TemplateHead::getTemplateNumber).collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.in((Object)"template_number", templateNumberList);
        List myHeadList = this.list((Wrapper)queryWrapper);
        TemplateHead templateHead = null;
        List notExistHeadList = headVOList.parallelStream().filter(vo -> !myHeadList.parallelStream().map(my -> my.getTemplateNumber()).collect(Collectors.toList()).contains(vo.getTemplateNumber())).collect(Collectors.toList());
        for (TemplateHeadVO headVO : notExistHeadList) {
            templateHead = new TemplateHead();
            BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)templateHead));
            this.importJsonDataToInsertAsync(headVO, templateHead, elsAccount, loginUser);
        }
        if (myHeadList.isEmpty()) {
            return;
        }
        List existHeadList = headVOList.parallelStream().filter(vo -> myHeadList.parallelStream().map(my -> my.getTemplateNumber()).collect(Collectors.toList()).contains(vo.getTemplateNumber())).collect(Collectors.toList());
        List<String> myHeadIds = myHeadList.parallelStream().map(BaseEntity::getId).collect(Collectors.toList());
        List<TemplateHeadVO> myHeadVoList = this.assembleTemplateHeadVOInfo(myHeadList, myHeadIds);
        ArrayList<TemplateHeadImportVO> existTemplateHeadVoList = new ArrayList<TemplateHeadImportVO>();
        TemplateHeadImportVO importVO = null;
        TemplateHead myHead = null;
        for (TemplateHeadVO headVO : existHeadList) {
            importVO = new TemplateHeadImportVO();
            myHead = new TemplateHead();
            BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)importVO));
            Optional<TemplateHeadVO> optional = myHeadVoList.parallelStream().filter(o -> o.getTemplateNumber().equals(headVO.getTemplateNumber())).findFirst();
            if (optional.isPresent()) {
                TemplateHeadVO vo2 = optional.get();
                BeanUtils.copyProperties((Object)((Object)vo2), (Object)((Object)myHead));
                importVO.setMyTemplateConfigHeadList(vo2.getTemplateConfigHeadList());
                importVO.setMyTemplateConfigItemList(vo2.getTemplateConfigItemList());
                importVO.setMyTemplateGroupList(vo2.getTemplateGroupList());
            }
            importVO.setMyTemplateHead(myHead);
            existTemplateHeadVoList.add(importVO);
        }
        this.importJsonDataToUpgradeVersionAsync(existTemplateHeadVoList, elsAccount, loginUser);
    }

    @Override
    public List<TemplateHead> getTemplateByType(String businessType) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TemplateHead::getBusinessType, (Object)businessType)).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(TemplateHead::getTemplateStatus, (Object)TemplateStatusEnum.GENERATED.getValue())).list();
        if (list.isEmpty()) {
            list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TemplateHead::getBusinessType, (Object)businessType)).eq(BaseEntity::getElsAccount, (Object)"100000")).eq(TemplateHead::getDefaultType, (Object)"1")).list();
        }
        if (list.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_VERWWWWWWUEtCLIr_5d28d2fe", (String)"\u8bf7\u914d\u7f6e[${0}]\u5e73\u53f0\u7ea7\u6a21\u677f", (String[])new String[]{businessType}));
        }
        return list;
    }

    private List<TemplateHeadVO> assembleTemplateHeadVOInfo(List<TemplateHead> templateHeadList, List<String> templateIds) {
        ArrayList<TemplateHeadVO> dataList = new ArrayList<TemplateHeadVO>();
        QueryWrapper groupQueryWrapper = new QueryWrapper();
        groupQueryWrapper.in((Object)"head_id", templateIds);
        List groupList = this.templateGroupMapper.selectList((Wrapper)groupQueryWrapper);
        QueryWrapper configHeadQueryWrapper = new QueryWrapper();
        configHeadQueryWrapper.in((Object)"head_id", templateIds);
        List headList = this.templateConfigHeadMapper.selectList((Wrapper)configHeadQueryWrapper);
        QueryWrapper configItemQueryWrapper = new QueryWrapper();
        configItemQueryWrapper.in((Object)"head_id", templateIds);
        List itemList = this.templateConfigItemMapper.selectList((Wrapper)configItemQueryWrapper);
        TemplateHeadVO templateHeadVO = null;
        List<TemplateGroup> groups = null;
        List<TemplateConfigHead> heads = null;
        List<TemplateConfigItem> items = null;
        for (TemplateHead head : templateHeadList) {
            templateHeadVO = new TemplateHeadVO();
            BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)templateHeadVO));
            groups = groupList.parallelStream().filter(g -> head.getId().equals(g.getHeadId())).collect(Collectors.toList());
            heads = headList.parallelStream().filter(g -> head.getId().equals(g.getHeadId())).collect(Collectors.toList());
            items = itemList.parallelStream().filter(g -> head.getId().equals(g.getHeadId())).collect(Collectors.toList());
            templateHeadVO.setTemplateGroupList(groups);
            templateHeadVO.setTemplateConfigHeadList(heads);
            templateHeadVO.setTemplateConfigItemList(items);
            dataList.add(templateHeadVO);
        }
        return dataList;
    }

    public void importJsonDataToInsertAsync(TemplateHeadVO headVO, TemplateHead templateHead, String elsAccount, LoginUserDTO loginUser) {
        templateHead.setId(null);
        templateHead.setElsAccount(elsAccount);
        templateHead.setTemplateVersion(1);
        templateHead.setTemplateStatus("0");
        templateHead.setDefaultType("0");
        templateHead.setCreateBy(loginUser != null ? loginUser.getSubAccount() : "els");
        templateHead.setUpdateBy(loginUser != null ? loginUser.getSubAccount() : "els");
        templateHead.setCreateTime(new Date());
        templateHead.setUpdateTime(new Date());
        this.srmPoolExecutor.execute(() -> {
            try {
                LoginUserContext.setUser((LoginUserDTO)loginUser);
                TenantContext.setTenant((String)elsAccount);
                ((TemplateHeadServiceImpl)SpringContextUtils.getBean(TemplateHeadServiceImpl.class)).importJsonSaveMain(templateHead, headVO.getTemplateGroupList(), headVO.getTemplateConfigHeadList(), headVO.getTemplateConfigItemList());
            }
            finally {
                TenantContext.clear();
                LoginUserContext.clear();
            }
        });
    }

    private void importJsonDataToUpgradeVersionAsync(List<TemplateHeadImportVO> importVOList, String elsAccount, LoginUserDTO loginUser) {
        for (TemplateHeadImportVO importVO : importVOList) {
            TemplateHead myTemplateHead = importVO.getMyTemplateHead();
            List<TemplateGroup> myTemplateGroupList = importVO.getMyTemplateGroupList();
            List<TemplateConfigHead> myTemplateConfigHeadList = importVO.getMyTemplateConfigHeadList();
            List<TemplateConfigItem> myTemplateConfigItemList = importVO.getMyTemplateConfigItemList();
            TemplateHead importTemplateHead = new TemplateHead();
            BeanUtils.copyProperties((Object)((Object)importVO), (Object)((Object)importTemplateHead));
            List<TemplateGroup> importTemplateGroupList = importVO.getTemplateGroupList();
            List<TemplateConfigHead> importTemplateConfigHeadList = importVO.getTemplateConfigHeadList();
            List<TemplateConfigItem> importTemplateConfigItemList = importVO.getTemplateConfigItemList();
            this.srmPoolExecutor.execute(() -> {
                try {
                    LoginUserContext.setUser((LoginUserDTO)loginUser);
                    TenantContext.setTenant((String)elsAccount);
                    ((TemplateHeadServiceImpl)SpringContextUtils.getBean(TemplateHeadServiceImpl.class)).importJsonUpdateMain(myTemplateHead, myTemplateGroupList, myTemplateConfigHeadList, myTemplateConfigItemList, importTemplateHead, importTemplateGroupList, importTemplateConfigHeadList, importTemplateConfigItemList);
                }
                finally {
                    TenantContext.clear();
                    LoginUserContext.clear();
                }
            });
        }
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void importJsonUpdateMain(TemplateHead myTemplateHead, List<TemplateGroup> myTemplateGroupList, List<TemplateConfigHead> myTemplateConfigHeadList, List<TemplateConfigItem> myTemplateConfigItemList, TemplateHead importTemplateHead, List<TemplateGroup> importTemplateGroupList, List<TemplateConfigHead> importTemplateConfigHeadList, List<TemplateConfigItem> importTemplateConfigItemList) {
        LoginUserDTO user = SysUtil.getLoginUser();
        importTemplateHead.setId(myTemplateHead.getId());
        importTemplateHead.setTemplateVersion(myTemplateHead.getTemplateVersion() + 1);
        importTemplateHead.setTemplateStatus(TemplateStatusEnum.NEW.getValue());
        importTemplateHead.setElsAccount(myTemplateHead.getElsAccount());
        importTemplateHead.setCreateBy(user.getSubAccount());
        importTemplateHead.setUpdateBy(user.getSubAccount());
        importTemplateHead.setCreateTime(myTemplateHead.getCreateTime());
        importTemplateHead.setUpdateTime(new Date());
        this.templateHeadMapper.updateById((Object)importTemplateHead);
        this.templateGroupMapper.deleteByMainId(myTemplateHead.getId());
        this.templateConfigHeadMapper.deleteByMainId(myTemplateHead.getId());
        this.templateConfigItemMapper.deleteByMainId(myTemplateHead.getId());
        this.insertData(importTemplateHead, importTemplateGroupList, importTemplateConfigHeadList, importTemplateConfigItemList);
        TemplateHeadHis headHis = new TemplateHeadHis();
        BeanUtils.copyProperties((Object)((Object)myTemplateHead), (Object)((Object)headHis));
        headHis.setId(null);
        ArrayList<TemplateGroupHis> templateGroupHisList = new ArrayList<TemplateGroupHis>();
        ArrayList<TemplateConfigHeadHis> templateConfigHeadHisList = new ArrayList<TemplateConfigHeadHis>();
        ArrayList<TemplateConfigItemHis> templateConfigItemHisList = new ArrayList<TemplateConfigItemHis>();
        for (TemplateGroup group : myTemplateGroupList) {
            TemplateGroupHis groupHis = new TemplateGroupHis();
            BeanUtils.copyProperties((Object)((Object)group), (Object)((Object)groupHis));
            groupHis.setId(null);
            templateGroupHisList.add(groupHis);
        }
        for (TemplateConfigHead configHead : myTemplateConfigHeadList) {
            TemplateConfigHeadHis configHeadHis = new TemplateConfigHeadHis();
            BeanUtils.copyProperties((Object)((Object)configHead), (Object)((Object)configHeadHis));
            configHeadHis.setId(null);
            templateConfigHeadHisList.add(configHeadHis);
        }
        for (TemplateConfigItem configItem : myTemplateConfigItemList) {
            TemplateConfigItemHis configItemHis = new TemplateConfigItemHis();
            BeanUtils.copyProperties((Object)((Object)configItem), (Object)((Object)configItemHis));
            configItemHis.setId(null);
            templateConfigItemHisList.add(configItemHis);
        }
        this.templateHeadHisService.saveMain(headHis, templateGroupHisList, templateConfigHeadHisList, templateConfigItemHisList);
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void importJsonSaveMain(TemplateHead templateHead, List<TemplateGroup> templateGroupList, List<TemplateConfigHead> templateConfigHeadList, List<TemplateConfigItem> templateConfigItemList) {
        this.templateHeadMapper.insert((Object)templateHead);
        this.insertData(templateHead, templateGroupList, templateConfigHeadList, templateConfigItemList);
    }

    private String getTemplateDictMapRedisKey(String templateId, String groupCode) {
        return TEMPLATE_DICT_MAP_REDIS_KEY + templateId + ":" + groupCode;
    }

    @Override
    public Map<String, String> getHeadDictMap(String templateId, String groupCode) {
        String redisKey = this.getTemplateDictMapRedisKey(templateId, groupCode);
        Map<String, String> dictMap = (Map<String, String>)this.redisUtil.get(redisKey);
        if (dictMap != null) {
            return dictMap;
        }
        TemplateHeadVO headVO = this.getTemplateById(templateId);
        List<TemplateConfigHead> templateConfigHeadList = headVO.getTemplateConfigHeadList();
        dictMap = templateConfigHeadList.stream().filter(head -> StrUtil.isNotBlank((CharSequence)head.getDictCode())).collect(Collectors.toMap(TemplateConfigHead::getFieldName, TemplateConfigHead::getDictCode));
        this.redisUtil.set(redisKey, dictMap);
        return dictMap;
    }

    @Override
    public Map<String, String> getItemDictMap(String templateId, String groupCode) {
        String redisKey = this.getTemplateDictMapRedisKey(templateId, groupCode);
        Map<String, String> dictMap = (Map<String, String>)this.redisUtil.get(redisKey);
        if (dictMap != null) {
            return dictMap;
        }
        TemplateHeadVO headVO = this.getTemplateById(templateId);
        List<TemplateConfigItem> templateConfigItemList = headVO.getTemplateConfigItemList();
        dictMap = templateConfigItemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getDictCode())).filter(item -> StrUtil.isBlank((CharSequence)item.getGroupCode()) || item.getGroupCode().equals(groupCode)).collect(Collectors.toMap(TemplateConfigItem::getFieldName, TemplateConfigItem::getDictCode));
        this.redisUtil.set(redisKey, dictMap);
        return dictMap;
    }

    @Override
    public TemplateHeadVO getTemplateByBusinessType(String elsAccount, String businessType) {
        String redisKey = this.getTemplateRedisKey(elsAccount, businessType);
        TemplateHeadVO headVO = (TemplateHeadVO)((Object)this.redisUtil.get(redisKey));
        if (headVO != null) {
            return headVO;
        }
        List headList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(TemplateHead::getBusinessType, (Object)businessType)).orderByDesc(TemplateHead::getDefaultType));
        if (headList.isEmpty() && (headList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BaseEntity::getElsAccount, (Object)ConfigUtil.getPurchaseAccount())).eq(TemplateHead::getBusinessType, (Object)businessType)).orderByDesc(TemplateHead::getDefaultType))).isEmpty() && !"100000".equals(ConfigUtil.getPurchaseAccount())) {
            headList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BaseEntity::getElsAccount, (Object)"100000")).eq(TemplateHead::getBusinessType, (Object)businessType)).orderByDesc(TemplateHead::getDefaultType));
        }
        if (headList.isEmpty()) {
            return null;
        }
        headVO = new TemplateHeadVO();
        BeanUtils.copyProperties(headList.get(0), (Object)((Object)headVO));
        headVO.setTemplateGroupList(this.templateGroupService.selectByMainId(headVO.getId()));
        headVO.setTemplateConfigHeadList(this.templateConfigHeadService.selectByMainId(headVO.getId()));
        headVO.setTemplateConfigItemList(this.templateConfigItemService.selectByMainId(headVO.getId()));
        this.redisUtil.set(redisKey, (Object)headVO);
        return headVO;
    }

    @Override
    public List<TemplateHeadVO> getTemplateByBusinessType(String templateBusinessType) {
        List headList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TemplateHead::getBusinessType, (Object)templateBusinessType)).in(BaseEntity::getElsAccount, new Object[]{TenantContext.getTenant(), "100000", ConfigUtil.getPurchaseAccount()})).in(TemplateHead::getTemplateStatus, new Object[]{TemplateStatusEnum.GENERATED.getValue(), TemplateStatusEnum.CANCEL.getValue()}));
        if (headList.isEmpty()) {
            return Lists.newArrayList();
        }
        ArrayList<TemplateHeadVO> headVOList = new ArrayList<TemplateHeadVO>();
        List<String> dbHeadIdList = headList.stream().map(BaseEntity::getId).toList();
        List dbGroupList = this.templateGroupService.list((Wrapper)new LambdaQueryWrapper().in(TemplateGroup::getHeadId, dbHeadIdList));
        Map<String, List<TemplateGroup>> groupMap = dbGroupList.stream().collect(Collectors.groupingBy(TemplateGroup::getHeadId));
        List dbConfigHeadList = this.templateConfigHeadService.list((Wrapper)new LambdaQueryWrapper().in(TemplateConfigHead::getHeadId, dbHeadIdList));
        Map<String, List<TemplateConfigHead>> configHeadMap = dbConfigHeadList.stream().collect(Collectors.groupingBy(TemplateConfigHead::getHeadId));
        List dbConfigItemList = this.templateConfigItemService.list((Wrapper)new LambdaQueryWrapper().in(TemplateConfigItem::getHeadId, dbHeadIdList));
        Map<String, List<TemplateConfigItem>> configItemMap = dbConfigItemList.stream().collect(Collectors.groupingBy(TemplateConfigItem::getHeadId));
        for (TemplateHead dbHead : headList) {
            TemplateHeadVO headVO = new TemplateHeadVO();
            BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
            headVO.setTemplateGroupList((List)ObjectUtil.defaultIfNull(groupMap.get(dbHead.getId()), (Object)Lists.newArrayList()));
            headVO.setTemplateConfigHeadList((List)ObjectUtil.defaultIfNull(configHeadMap.get(dbHead.getId()), (Object)Lists.newArrayList()));
            headVO.setTemplateConfigItemList((List)ObjectUtil.defaultIfNull(configItemMap.get(dbHead.getId()), (Object)Lists.newArrayList()));
            headVOList.add(headVO);
        }
        return headVOList;
    }

    private String getTemplateRedisKey(String templateId) {
        return TEMPLATE_VO_REDIS_KEY + templateId;
    }

    private String getTemplateRedisKey(String elsAccount, String businessType) {
        return TEMPLATE_VO_REDIS_KEY + elsAccount + ":" + businessType;
    }

    private TemplateHeadVO queryTemplate(String templateId) {
        TemplateHeadVO headVO = new TemplateHeadVO();
        TemplateHead dbHead = (TemplateHead)((Object)this.getById((Serializable)((Object)templateId)));
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
        headVO.setTemplateGroupList(this.templateGroupService.selectByMainId(dbHead.getId()));
        headVO.setTemplateConfigHeadList(this.templateConfigHeadService.selectByMainId(dbHead.getId()));
        headVO.setTemplateConfigItemList(this.templateConfigItemService.selectByMainId(dbHead.getId()));
        return headVO;
    }

    @Override
    public TemplateHeadVO getTemplateById(String templateId) {
        String redisKey = this.getTemplateRedisKey(templateId);
        TemplateHeadVO headVO = (TemplateHeadVO)((Object)this.redisUtil.get(redisKey));
        if (headVO != null) {
            return headVO;
        }
        headVO = this.queryTemplate(templateId);
        this.redisUtil.set(redisKey, (Object)headVO);
        return headVO;
    }
}

