/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core.agent.run;

import com.els.modules.ai.core.agent.AgentStrategyFactory;
import com.els.modules.ai.core.agent.run.RunStrategy;
import com.els.modules.ai.entity.AiAgentAppConfigItem;
import com.els.modules.ai.enums.AgentStepType;
import com.els.modules.ai.listener.AgentMqUtil;
import com.els.modules.ai.pojo.LlmRequestPojo;
import com.els.modules.ai.pojo.LlmResponsePojo;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractRunStrategy
implements RunStrategy,
InitializingBean {
    public void afterPropertiesSet() throws Exception {
        AgentStrategyFactory.register(this.type(), this);
    }

    public abstract LlmResponsePojo doExecute(LlmRequestPojo var1, AiAgentAppConfigItem var2);

    @Override
    public LlmResponsePojo execute(LlmRequestPojo llmRequest, AiAgentAppConfigItem config) {
        try {
            LlmResponsePojo result = this.doExecute(llmRequest, config);
            AgentMqUtil.sendItem(llmRequest.getLogHeadId(), llmRequest.getElsAccount(), AgentStepType.APP_CONFIG.getType(), config.getName(), config.getOrderSort(), result.getResultText(), "");
            return result;
        }
        catch (Exception e) {
            AgentMqUtil.sendItem(llmRequest.getLogHeadId(), llmRequest.getElsAccount(), AgentStepType.APP_CONFIG.getType(), config.getName(), config.getOrderSort(), "", e.getMessage());
            throw e;
        }
    }
}

