/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.service.impl;

import cn.hutool.core.util.StrUtil;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.barcode.entity.SaleBarcodePrintHead;
import com.els.modules.barcode.entity.SaleBarcodePrintItem;
import com.els.modules.barcode.enumerate.BarcodePrintStatusEnum;
import com.els.modules.barcode.mapper.SaleBarcodePrintHeadMapper;
import com.els.modules.barcode.mapper.SaleBarcodePrintItemMapper;
import com.els.modules.barcode.service.SaleBarcodePrintHeadService;
import com.els.modules.barcode.service.SaleBarcodePrintItemService;
import com.els.modules.system.service.CodeGeneratorService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SaleBarcodePrintHeadServiceImpl
extends BaseServiceImpl<SaleBarcodePrintHeadMapper, SaleBarcodePrintHead>
implements SaleBarcodePrintHeadService {
    @Autowired
    private SaleBarcodePrintHeadMapper saleBarcodePrintHeadMapper;
    @Autowired
    private SaleBarcodePrintItemMapper saleBarcodePrintItemMapper;
    @Autowired
    private SaleBarcodePrintItemService saleBarcodePrintItemService;
    @Autowired
    private CodeGeneratorService codeGeneratorService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(SaleBarcodePrintHead saleBarcodePrintHead, List<SaleBarcodePrintItem> saleBarcodePrintItemList) {
        saleBarcodePrintHead.setNumber(this.codeGeneratorService.getNextCode("srmBarcodePrintNumber", (Object)saleBarcodePrintHead));
        saleBarcodePrintHead.setStatus(BarcodePrintStatusEnum.NEW.getValue());
        saleBarcodePrintHead.setRecord(StrUtil.isBlank((CharSequence)saleBarcodePrintHead.getRecord()) ? "0" : saleBarcodePrintHead.getRecord());
        this.saleBarcodePrintHeadMapper.insert((Object)saleBarcodePrintHead);
        this.insertData(saleBarcodePrintHead, saleBarcodePrintItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(SaleBarcodePrintHead saleBarcodePrintHead, List<SaleBarcodePrintItem> saleBarcodePrintItemList) {
        int count = this.saleBarcodePrintHeadMapper.updateById((Object)saleBarcodePrintHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        this.saleBarcodePrintItemMapper.deleteByMainId(saleBarcodePrintHead.getId());
        this.insertData(saleBarcodePrintHead, saleBarcodePrintItemList);
    }

    private void insertData(SaleBarcodePrintHead saleBarcodePrintHead, List<SaleBarcodePrintItem> saleBarcodePrintItemList) {
        if (saleBarcodePrintItemList != null && !saleBarcodePrintItemList.isEmpty()) {
            for (SaleBarcodePrintItem entity : saleBarcodePrintItemList) {
                entity.setHeadId(saleBarcodePrintHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)saleBarcodePrintHead);
            }
            this.saleBarcodePrintItemService.saveBatch(saleBarcodePrintItemList);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.saleBarcodePrintItemMapper.deleteByMainId(id);
        this.saleBarcodePrintHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.saleBarcodePrintItemMapper.deleteByMainId(serializable.toString());
            this.saleBarcodePrintHeadMapper.deleteById(serializable);
        }
    }
}

