/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tactics.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.SysUtil;
import com.els.modules.system.service.CodeGeneratorService;
import com.els.modules.tactics.entity.ElsTacticsHead;
import com.els.modules.tactics.entity.ElsTacticsItem;
import com.els.modules.tactics.mapper.ElsTacticsHeadMapper;
import com.els.modules.tactics.mapper.ElsTacticsItemMapper;
import com.els.modules.tactics.service.ElsTacticsHeadService;
import com.els.modules.tactics.service.ElsTacticsItemService;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ElsTacticsHeadServiceImpl
extends ServiceImpl<ElsTacticsHeadMapper, ElsTacticsHead>
implements ElsTacticsHeadService {
    @Resource
    private ElsTacticsHeadMapper elsTacticsHeadMapper;
    @Resource
    private ElsTacticsItemMapper elsTacticsItemMapper;
    @Resource
    private ElsTacticsItemService elsTacticsItemService;
    @Autowired
    private CodeGeneratorService codeGeneratorService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(ElsTacticsHead elsTacticsHead, List<ElsTacticsItem> elsTacticsItemList) {
        if (StrUtil.isBlank((CharSequence)elsTacticsHead.getTacticsNumber())) {
            String nextCode = this.codeGeneratorService.getNextCode("srmTacticsNumber", (Object)elsTacticsHead);
            elsTacticsHead.setTacticsNumber(nextCode);
        }
        this.elsTacticsHeadMapper.insert((Object)elsTacticsHead);
        this.insertData(elsTacticsHead, elsTacticsItemList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(ElsTacticsHead elsTacticsHead, List<ElsTacticsItem> elsTacticsItemList) {
        this.elsTacticsHeadMapper.updateById((Object)elsTacticsHead);
        this.elsTacticsItemMapper.deleteByMainId(elsTacticsHead.getId());
        this.insertData(elsTacticsHead, elsTacticsItemList);
    }

    private void insertData(ElsTacticsHead elsTacticsHead, List<ElsTacticsItem> elsTacticsItemList) {
        if (!CollectionUtils.isEmpty(elsTacticsItemList)) {
            int count = 1;
            for (ElsTacticsItem entity : elsTacticsItemList) {
                entity.setHeadId(elsTacticsHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)elsTacticsHead);
                entity.setItemNumber(count);
                ++count;
            }
            if (!elsTacticsItemList.isEmpty()) {
                this.elsTacticsItemService.saveBatch(elsTacticsItemList);
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.elsTacticsItemMapper.deleteByMainId(id);
        this.elsTacticsHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.elsTacticsItemMapper.deleteByMainId(serializable.toString());
            this.elsTacticsHeadMapper.deleteById(serializable);
        }
    }
}

