/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.service.impl;

import cn.hutool.core.util.StrUtil;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.barcode.entity.PurchaseBarcodePrintHead;
import com.els.modules.barcode.entity.PurchaseBarcodePrintItem;
import com.els.modules.barcode.enumerate.BarcodePrintStatusEnum;
import com.els.modules.barcode.mapper.PurchaseBarcodePrintHeadMapper;
import com.els.modules.barcode.mapper.PurchaseBarcodePrintItemMapper;
import com.els.modules.barcode.service.PurchaseBarcodePrintHeadService;
import com.els.modules.barcode.service.PurchaseBarcodePrintItemService;
import com.els.modules.system.service.CodeGeneratorService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PurchaseBarcodePrintHeadServiceImpl
extends BaseServiceImpl<PurchaseBarcodePrintHeadMapper, PurchaseBarcodePrintHead>
implements PurchaseBarcodePrintHeadService {
    @Autowired
    private PurchaseBarcodePrintHeadMapper purchaseBarcodePrintHeadMapper;
    @Autowired
    private PurchaseBarcodePrintItemMapper purchaseBarcodePrintItemMapper;
    @Autowired
    private PurchaseBarcodePrintItemService purchaseBarcodePrintItemService;
    @Autowired
    private CodeGeneratorService codeGeneratorService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseBarcodePrintHead purchaseBarcodePrintHead, List<PurchaseBarcodePrintItem> purchaseBarcodePrintItemList) {
        purchaseBarcodePrintHead.setBusNumber(this.codeGeneratorService.getNextCode("srmBarcodePrintNumber", (Object)purchaseBarcodePrintHead));
        purchaseBarcodePrintHead.setStatus(BarcodePrintStatusEnum.NEW.getValue());
        purchaseBarcodePrintHead.setRecord(StrUtil.isBlank((CharSequence)purchaseBarcodePrintHead.getRecord()) ? "0" : purchaseBarcodePrintHead.getRecord());
        this.purchaseBarcodePrintHeadMapper.insert((Object)purchaseBarcodePrintHead);
        this.insertData(purchaseBarcodePrintHead, purchaseBarcodePrintItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseBarcodePrintHead purchaseBarcodePrintHead, List<PurchaseBarcodePrintItem> purchaseBarcodePrintItemList) {
        int count = this.purchaseBarcodePrintHeadMapper.updateById((Object)purchaseBarcodePrintHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        this.purchaseBarcodePrintItemMapper.deleteByMainId(purchaseBarcodePrintHead.getId());
        this.insertData(purchaseBarcodePrintHead, purchaseBarcodePrintItemList);
    }

    private void insertData(PurchaseBarcodePrintHead purchaseBarcodePrintHead, List<PurchaseBarcodePrintItem> purchaseBarcodePrintItemList) {
        if (purchaseBarcodePrintItemList != null && !purchaseBarcodePrintItemList.isEmpty()) {
            for (PurchaseBarcodePrintItem entity : purchaseBarcodePrintItemList) {
                entity.setId(null);
                entity.setHeadId(purchaseBarcodePrintHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseBarcodePrintHead);
            }
            this.purchaseBarcodePrintItemService.saveBatch(purchaseBarcodePrintItemList);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseBarcodePrintItemMapper.deleteByMainId(id);
        this.purchaseBarcodePrintHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseBarcodePrintItemMapper.deleteByMainId(serializable.toString());
            this.purchaseBarcodePrintHeadMapper.deleteById(serializable);
        }
    }
}

