/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logistics.controller;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.util.DateUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.IpaasConfig;
import com.els.modules.logistics.entity.LogisticsCompanyItem;
import com.els.modules.logistics.entity.ZhongJiaoXingLuParams;
import com.els.modules.logistics.vo.LogisticsCompanyVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/trace"})
@CrossOrigin(value={"*"})
public class TraceController {
    private Map<String, String> configMap = ((IpaasConfig)SpringContextUtils.getBean(IpaasConfig.class)).getConfig();
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @GetMapping(value={"/express"})
    @RequiresPermissions(value={"logistics#trace:express"})
    public Result<?> selectExpress(@RequestParam(name="expressNumber") String expressNumber, @RequestParam(name="phone") String phone) throws Exception {
        if (!StrUtil.isBlank((CharSequence)expressNumber)) {
            if (expressNumber.startsWith("SF") && StrUtil.isBlank((CharSequence)phone)) {
                return Result.error((String)"\u5feb\u9012\u5355\u53f7\u4e3a\u987a\u4e30\u7684,\u6536\u8d27\u4eba\u624b\u673a\u53f7\u7801\u5fc5\u586b");
            }
            JSONObject request = new JSONObject();
            request.put("num", (Object)expressNumber);
            request.put("phone", (Object)phone);
            JSONObject object = this.invokeBaseRpcService.callIPaasInterface(request, "valueAddedApplication", this.invokeBaseRpcService.getIpaasInterfaceCode("getExpressInfo"));
            if ("200".equals(object.getString("code"))) {
                JSONObject jsonObject = JSONObject.parseObject((String)object.getString("data"));
                if ("0".equals(jsonObject.getString("status")) || "200".equals(jsonObject.getString("status"))) {
                    return Result.ok((Object)((Object)this.jsonResult(jsonObject)));
                }
                return Result.error((String)jsonObject.getString("message"));
            }
            return Result.error((String)object.getString("message"));
        }
        return Result.error((String)I18nUtil.translate((String)"i18n_alert_QntyLV_c2c2a849", (String)"\u5feb\u9012\u5355\u53f7\u4e3a\u7a7a\uff01"));
    }

    private LogisticsCompanyVO jsonResult(JSONObject jsonObject) {
        LogisticsCompanyVO logisticsCompanyVO = new LogisticsCompanyVO();
        logisticsCompanyVO.setCurrent(jsonObject.getString("current"));
        logisticsCompanyVO.setCurrentStatus(jsonObject.getString("currentStatus"));
        logisticsCompanyVO.setLatestTime(jsonObject.getString("latest_time"));
        logisticsCompanyVO.setLatestProgress(jsonObject.getString("latest_progress"));
        logisticsCompanyVO.setCompanyName(jsonObject.getString("fullname"));
        logisticsCompanyVO.setCompanyNameIcon(jsonObject.getString("title_logo"));
        ArrayList<LogisticsCompanyItem> objects = new ArrayList<LogisticsCompanyItem>();
        JSONArray context = jsonObject.getJSONArray("data");
        context.forEach(item -> this.jsonToitem((JSONObject)item, objects));
        logisticsCompanyVO.setLogisticsCompanyItemList(objects);
        return logisticsCompanyVO;
    }

    private void jsonToitem(JSONObject jsonObject, List<LogisticsCompanyItem> objects) {
        LogisticsCompanyItem logisticsCompanyItem = new LogisticsCompanyItem();
        Date time = jsonObject.getDate("time");
        logisticsCompanyItem.setAcceptTime(time);
        logisticsCompanyItem.setAcceptStation(jsonObject.getString("context"));
        objects.add(logisticsCompanyItem);
    }

    @PostMapping(value={"/transportationNodeService"})
    @RequiresPermissions(value={"logistics#trace:transportationNodeService"})
    public Result<?> transportationNodeService(@RequestBody ZhongJiaoXingLuParams zhongJiaoXingLuParams) throws Exception {
        JSONObject request = new JSONObject();
        this.nodeToJson(request, zhongJiaoXingLuParams);
        JSONObject object = this.invokeBaseRpcService.callIPaasInterface(request, "valueAddedApplication", this.invokeBaseRpcService.getIpaasInterfaceCode("transportation-node-service"));
        if ("200".equals(object.getString("code"))) {
            JSONObject jsonObject = JSONObject.parseObject((String)object.getString("data"));
            if ("1001".equals(jsonObject.getString("status")) || "200".equals(jsonObject.getString("status"))) {
                return Result.ok((Object)jsonObject.get((Object)"result"));
            }
            return Result.error((String)jsonObject.getString("result"));
        }
        return Result.error((String)object.getString("result"));
    }

    private void nodeToJson(JSONObject jsonObject, ZhongJiaoXingLuParams objects) {
        if (StrUtil.isBlank((CharSequence)objects.getLicensePlateNumber())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_qAyxOLV_7d9c8ca1", (String)"\u8f66\u724c\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (StrUtil.isBlank((CharSequence)objects.getLicensePlateNumberColor())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_qAyOyxOLV_d7e50eb7", (String)"\u8f66\u724c\u53f7\u989c\u8272\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        jsonObject.put("vnos", (Object)(objects.getLicensePlateNumber() + "_" + objects.getLicensePlateNumberColor()));
        jsonObject.put("startLonlat", (Object)objects.getOriginCoordinates());
        jsonObject.put("endLonlat", (Object)objects.getDestinationCoordinates());
        jsonObject.put("startAreaCode", (Object)objects.getCodeOfAdministrativeDivisionOfOrigin());
        jsonObject.put("endAreaCode", (Object)objects.getDestinationAdministrativeDivisionCode());
    }

    @PostMapping(value={"/planningService"})
    @RequiresPermissions(value={"logistics#trace:planningService"})
    public Result<?> planningService(@RequestBody ZhongJiaoXingLuParams zhongJiaoXingLuParams) throws Exception {
        JSONObject request = new JSONObject();
        this.planToJson(request, zhongJiaoXingLuParams);
        JSONObject object = this.invokeBaseRpcService.callIPaasInterface(request, "valueAddedApplication", this.invokeBaseRpcService.getIpaasInterfaceCode("planning-service"));
        if ("200".equals(object.getString("code"))) {
            JSONObject jsonObject = JSONObject.parseObject((String)object.getString("data"));
            if ("1001".equals(jsonObject.getString("status")) || "200".equals(jsonObject.getString("status"))) {
                return Result.ok((Object)jsonObject.get((Object)"result"));
            }
            return Result.error((String)jsonObject.getString("result"));
        }
        return Result.error((String)object.getString("message"));
    }

    private void planToJson(JSONObject jsonObject, ZhongJiaoXingLuParams objects) {
        if (StrUtil.isBlank((CharSequence)objects.getLicensePlateNumber())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_qAyxOLV_7d9c8ca1", (String)"\u8f66\u724c\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (StrUtil.isBlank((CharSequence)objects.getLicensePlateNumberColor())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_qAyOyxOLV_d7e50eb7", (String)"\u8f66\u724c\u53f7\u989c\u8272\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (objects.getBeginTime() == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_vKKIxOLV_f095ba59", (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (objects.getEndTime() == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_yWKIxOLV_19b945ba", (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        jsonObject.put("vclN", (Object)objects.getLicensePlateNumber());
        jsonObject.put("vco", (Object)objects.getLicensePlateNumberColor());
        jsonObject.put("qryBtm", (Object)DateUtils.formatDate((Date)objects.getBeginTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        jsonObject.put("qryEtm", (Object)DateUtils.formatDate((Date)objects.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        jsonObject.put("startLonlat", (Object)objects.getOriginCoordinates());
        jsonObject.put("endLonlat", (Object)objects.getDestinationCoordinates());
        jsonObject.put("startAreaCode", (Object)objects.getCodeOfAdministrativeDivisionOfOrigin());
        jsonObject.put("endAreaCode", (Object)objects.getDestinationAdministrativeDivisionCode());
    }

    @PostMapping(value={"/transportationItineraryService"})
    @RequiresPermissions(value={"logistics#trace:transportationItineraryService"})
    public Result<?> transportationItineraryService(@RequestBody ZhongJiaoXingLuParams zhongJiaoXingLuParams) throws Exception {
        JSONObject request = new JSONObject();
        this.itineraryToJson(request, zhongJiaoXingLuParams);
        JSONObject object = this.invokeBaseRpcService.callIPaasInterface(request, "valueAddedApplication", this.invokeBaseRpcService.getIpaasInterfaceCode("transportation-itinerary-service"));
        if ("200".equals(object.getString("code"))) {
            JSONObject jsonObject = JSONObject.parseObject((String)object.getString("data"));
            if ("1001".equals(jsonObject.getString("status")) || "200".equals(jsonObject.getString("status"))) {
                return Result.ok((Object)jsonObject.get((Object)"result"));
            }
            return Result.error((String)jsonObject.getString("result"));
        }
        return Result.error((String)object.getString("result"));
    }

    private void itineraryToJson(JSONObject jsonObject, ZhongJiaoXingLuParams objects) {
        if (StrUtil.isBlank((CharSequence)objects.getLicensePlateNumber())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_qAyxOLV_7d9c8ca1", (String)"\u8f66\u724c\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (StrUtil.isBlank((CharSequence)objects.getLicensePlateNumberColor())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_qAyOyxOLV_d7e50eb7", (String)"\u8f66\u724c\u53f7\u989c\u8272\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (objects.getBeginTime() == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_vKKIxOLV_f095ba59", (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (objects.getEndTime() == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_yWKIxOLV_19b945ba", (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        jsonObject.put("vclN", (Object)objects.getLicensePlateNumber());
        jsonObject.put("vco", (Object)objects.getLicensePlateNumberColor());
        jsonObject.put("qryBtm", (Object)DateUtils.formatDate((Date)objects.getBeginTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        jsonObject.put("qryEtm", (Object)DateUtils.formatDate((Date)objects.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        jsonObject.put("startLonlat", (Object)objects.getOriginCoordinates());
        jsonObject.put("endLonlat", (Object)objects.getDestinationCoordinates());
        jsonObject.put("startAreaCode", (Object)objects.getCodeOfAdministrativeDivisionOfOrigin());
        jsonObject.put("endAreaCode", (Object)objects.getDestinationAdministrativeDivisionCode());
    }
}

