/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.attachment.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.util.I18nUtil;
import com.els.modules.attachment.storage.StorageFileInfo;
import com.els.modules.attachment.storage.service.FileStoreSignService;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Tag(name="NLP\u9644\u4ef6")
@RestController
@RequestMapping(value={"/attachment/nlp"})
public class NLPAttachmentAndExpainController {
    private static final Logger log = LoggerFactory.getLogger(NLPAttachmentAndExpainController.class);
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource(name="fileStoreSignServiceImpl")
    private FileStoreSignService fileStoreSignServiceImpl;

    @RequiresPermissions(value={"attachment#nlp:upload"})
    @AutoLog(value="NLP\u9644\u4ef6-\u4e0a\u4f20", operateType=2)
    @Operation(summary="NLP\u9644\u4ef6", description="NLP\u9644\u4ef6")
    @RequestMapping(value={"/upload"}, method={RequestMethod.POST})
    public Result<?> upload(HttpServletRequest request) {
        String service = "valueAddedApplication";
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        try {
            Iterator iterator = fileMap.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry entity = iterator.next();
                MultipartFile uploadFile = (MultipartFile)entity.getValue();
                StorageFileInfo fileInfo = this.fileStoreSignServiceImpl.storeFile(uploadFile, null, null, null);
                String filePath = this.fileStoreSignServiceImpl.getDownloadPath(fileInfo.getPath(), null);
                HashMap<String, String> param = new HashMap<String, String>();
                log.info("remotePath is:" + filePath);
                param.put("filePath", filePath);
                JSONObject object = this.invokeBaseRpcService.callIPaasInterface(JSON.parseObject((String)JSON.toJSONString(param)), service, this.invokeBaseRpcService.getIpaasInterfaceCode("delivery_note"));
                JSONObject resultData = this.getChildNode(object, "data");
                resultData = this.getChildNode(resultData, "data");
                List resultList = (List)resultData.get((Object)"results");
                HashMap result = new HashMap();
                if (resultList == null) {
                    return Result.ok(result);
                }
                for (Map map : resultList) {
                    List value = (List)map.get("results");
                    if (value != null && value.size() > 0) {
                        result.put(map.get("field_name"), value.get(0));
                        continue;
                    }
                    result.put(map.get("field_name"), "");
                }
                return Result.ok(result);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return Result.error((String)I18nUtil.translate((String)"i18n_field_XVKm_24addeea", (String)"\u4e0a\u4f20\u5931\u8d25"));
    }

    private JSONObject getChildNode(JSONObject object, String childNode) {
        JSONObject reslut = new JSONObject();
        if (object != null && !object.isEmpty()) {
            reslut = (JSONObject)object.get((Object)childNode);
        }
        return reslut;
    }
}

