/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.core.cluster;

import cn.hutool.core.text.CharSequenceUtil;
import com.els.modules.im.core.cluster.ICluster;
import com.els.modules.im.core.config.ImClusterConfig;
import com.els.modules.im.core.config.ImConfig;
import com.els.modules.im.core.constant.TioConfigConstant;
import com.els.modules.im.core.packets.ClusterToGroupPackets;
import com.els.modules.im.core.packets.ImPackets;
import java.util.List;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="defaultImCluster")
public class RedisCluster
implements ICluster {
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private ImConfig srmImConfigProperties;

    @Override
    public void clusterToUser(List<String> userIds, ImPackets packet) {
        ImClusterConfig clusterDto = this.srmImConfigProperties.getCluster();
        if (!this.srmImConfigProperties.isCluster() || CharSequenceUtil.isEmpty((CharSequence)clusterDto.getClusterFriendTopic())) {
            return;
        }
        packet.setUserIds(userIds);
        packet.setClusterToUser(true);
        RTopic topic = this.redissonClient.getTopic(this.srmImConfigProperties.getCluster().getClusterFriendTopic());
        packet.setServerId(TioConfigConstant.SERVER_ID);
        topic.publishAsync((Object)packet);
    }

    @Override
    public void clusterToGroup(List<ClusterToGroupPackets> groupList, ImPackets packet) {
        ImClusterConfig clusterDto = this.srmImConfigProperties.getCluster();
        if (!this.srmImConfigProperties.isCluster() || CharSequenceUtil.isEmpty((CharSequence)clusterDto.getClusterGroupTopic())) {
            return;
        }
        packet.setGroupList(groupList);
        packet.setClusterToGroup(true);
        RTopic topic = this.redissonClient.getTopic(this.srmImConfigProperties.getCluster().getClusterGroupTopic());
        packet.setServerId(TioConfigConstant.SERVER_ID);
        topic.publishAsync((Object)packet);
    }

    @Override
    public void clusterToLogout(String userId, ImPackets packet) {
    }

    @Override
    public void clusterToBindOrUbBindGroup(ImPackets packet) {
        ImClusterConfig clusterDto = this.srmImConfigProperties.getCluster();
        if (!this.srmImConfigProperties.isCluster() || CharSequenceUtil.isEmpty((CharSequence)clusterDto.getClusterBindTopic())) {
            return;
        }
        packet.setFromCluster(true);
        RTopic topic = this.redissonClient.getTopic(this.srmImConfigProperties.getCluster().getClusterBindTopic());
        packet.setServerId(TioConfigConstant.SERVER_ID);
        topic.publishAsync((Object)packet);
    }
}

