/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.core.server.handler.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.exception.ELSBootException;
import com.els.common.util.ConfigUtil;
import com.els.common.util.ExternalUtil;
import com.els.common.util.IPaasUtil;
import com.els.common.util.PanshiUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.im.core.ImSender;
import com.els.modules.im.core.constant.TioConfigConstant;
import com.els.modules.im.core.message.BusinessHelper;
import com.els.modules.im.core.packets.ImUserPackets;
import com.els.modules.im.core.packets.WsMessageDataPackets;
import com.els.modules.im.core.packets.WsMessagePackets;
import com.els.modules.im.core.packets.WsMsgTypePackets;
import com.els.modules.im.core.packets.WsResultPackets;
import com.els.modules.im.core.server.handler.AbstractConnHandler;
import com.els.modules.im.core.server.handler.HandlerManager;
import com.els.modules.im.core.server.handler.Opt;
import com.els.modules.im.core.server.handler.OptHandler;
import com.els.modules.im.core.server.handler.third.ImToThirdServiceHandler;
import com.els.modules.im.utils.TuLingRobotUtil;
import com.els.modules.integration.api.dto.ExternalVoucherDto;
import com.google.common.collect.Lists;
import jakarta.annotation.Resource;
import java.time.Instant;
import java.util.List;
import org.redisson.api.RBucket;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.core.intf.Packet;
import org.tio.utils.lock.SetWithLock;
import org.tio.websocket.common.WsRequest;
import org.tio.websocket.common.WsResponse;

@Service
public class KefuChatHandler
extends AbstractConnHandler {
    private static final Logger log = LoggerFactory.getLogger(KefuChatHandler.class);
    @Autowired
    private RedisUtil redisUtil;
    @Resource(name="srmBusinessHelper")
    private BusinessHelper srmBusinessHelper;
    @Autowired
    private RedissonClient redissonClient;
    private final String KE_FU_GROUP = "ke_fu_group";
    private final String KE_FU_GROUP_WAIT_CHANNEL = "im_ke_fu_group_wait_channel";
    private static final String IM_KEFU = "srm:im:kefu_id:";
    private static final List<String> IGNORE = Lists.newArrayList((Object[])new String[]{"file"});

    @Override
    public Opt opt() {
        return Opt.KEFU_MSG_MESSAGE;
    }

    @Override
    public Object reCallOnText(WsRequest wsRequest, String text, ChannelContext channelContext) {
        try {
            WsMessagePackets wsMessage = (WsMessagePackets)JSON.parseObject((String)text, WsMessagePackets.class);
            String code = wsMessage.getConnCode();
            if (CharSequenceUtil.isEmpty((CharSequence)code)) {
                throw new Exception("\u8fde\u63a5\u72b6\u6001\u7801\u4e0d\u652f\u6301");
            }
            OptHandler optHandler = HandlerManager.execHandler(code);
            if (null == optHandler) {
                throw new Exception("\u8fde\u63a5\u72b6\u6001\u7801\u4e0d\u652f\u6301");
            }
            return optHandler.handler(wsRequest, wsMessage, channelContext);
        }
        catch (Exception e) {
            log.error("AbstractConnHandler handler \u5904\u7406\u6d88\u606f\u5f02\u5e38:{}", (Object)e.getMessage());
            return null;
        }
    }

    @Override
    protected Object doHandler(WsResultPackets wsResult, WsRequest wsRequest, WsMessagePackets wsMessage, ChannelContext channelContext) {
        switch (wsMessage.getConnOpt()) {
            case "chat": {
                String addMessageId;
                boolean isKefu;
                WsMessageDataPackets messageData = wsMessage.getMessage();
                String toUserId = messageData.getMessageToId();
                log.info(":::\u5ba2\u670d\u804a\u5929\u4e2d\uff0c\u6536\u5230\u6d88\u606f\u7684\u7528\u6237id:{}", (Object)toUserId);
                Object o = this.redisUtil.get(IM_KEFU + toUserId);
                if (null == o) {
                    isKefu = this.srmBusinessHelper.checkIfKefu(toUserId);
                    this.redisUtil.set(IM_KEFU + toUserId, (Object)isKefu, 86400L);
                } else {
                    isKefu = (Boolean)o;
                }
                wsResult.setMsgType(WsMsgTypePackets.KEFU_MESSAGE.getMsgType());
                if (this.srmBusinessHelper.isOnline(messageData.getMessageToId())) {
                    messageData = this.storeMessage(messageData, "1", "kefu");
                    ImSender.sendToUser(messageData.getMessageToId(), channelContext.getTioConfig(), this.buildImPacket(wsResult, messageData));
                    if (isKefu && !messageData.isManualServiceConn() && !"1".equals(messageData.getMessageReplyByRobot())) {
                        ImToThirdServiceHandler.sendMessageToThirdService("chat-gpt", messageData, wsRequest, messageData.getMessageFromId(), x -> this.reCallOnText((WsRequest)x.getLeft(), (String)x.getMiddle(), (ChannelContext)x.getRight()));
                    }
                } else {
                    messageData = this.storeMessage(messageData, "0", "kefu");
                    this.srmBusinessHelper.sendOutLineMessage(messageData.getMessageToId(), "imChatFriend", "", messageData, Lists.newArrayList((Object[])new String[]{messageData.getMessageToId()}));
                    if (isKefu && !messageData.isManualServiceConn() && !"1".equals(messageData.getMessageReplyByRobot())) {
                        ImToThirdServiceHandler.sendMessageToThirdService("chat-gpt", messageData, wsRequest, messageData.getMessageFromId(), x -> this.reCallOnText((WsRequest)x.getLeft(), (String)x.getMiddle(), (ChannelContext)x.getRight()));
                    }
                    if (messageData.isManualServiceConn()) {
                        this.srmBusinessHelper.sendOutLineMessage(messageData.getMessageFromId(), "imChatKeFu", messageData.getMessageToId(), messageData, Lists.newArrayList((Object[])new String[]{messageData.getMessageToId()}));
                    }
                }
                if (isKefu && messageData.isManualServiceConn()) {
                    this.sendMessageToOtherSystem(messageData, "panshi");
                    this.sendMessageToOtherSystem(messageData, "ipaas");
                    this.srmBusinessHelper.sendOutLineMessage(messageData.getMessageFromId(), "imChatFriend", messageData.getMessageToId(), messageData, Lists.newArrayList((Object[])new String[]{messageData.getMessageToId()}));
                }
                if (!CharSequenceUtil.isNotEmpty((CharSequence)(addMessageId = messageData.getId()))) break;
                WsResultPackets wsResultMap = new WsResultPackets();
                wsResultMap.setMsgType(WsMsgTypePackets.SEND_MESSAGE_ID_RETURN.getMsgType());
                WsMessageDataPackets resultMessage = new WsMessageDataPackets();
                resultMessage.setUnSaveMessageId(messageData.getUnSaveMessageId());
                resultMessage.setUndoMessageId(addMessageId);
                wsResultMap.setData(resultMessage);
                SetWithLock mimeChannelContextSetWithLock = Tio.getByUserid((TioConfig)channelContext.getTioConfig(), (String)channelContext.userid);
                if (mimeChannelContextSetWithLock == null || mimeChannelContextSetWithLock.size() == 0) break;
                WsResponse wsResponse = WsResponse.fromText((String)wsResultMap.toJsonString(), (String)"utf-8");
                Tio.sendToUser((TioConfig)channelContext.getTioConfig(), (String)channelContext.userid, (Packet)wsResponse);
                break;
            }
            case "kefu_chat": {
                WsMessageDataPackets messageData = wsMessage.getMessage();
                String toUserId = messageData.getMessageToId();
                log.info(":::\u5ba2\u670d\u804a\u5929\u4e2d\uff0c\u6536\u5230\u6d88\u606f\u7684\u7528\u6237id:{}", (Object)toUserId);
                String kefuOnChatKey = "srm:im:kefu:kefu_on_chat:user:" + channelContext.userid;
                String ckefuId = (String)this.redisUtil.get(kefuOnChatKey);
                String key2 = "srm:im:kefu:kefu_on_chat:user:" + toUserId;
                String ckefuId2 = (String)this.redisUtil.get(key2);
                if (!CharSequenceUtil.equals((CharSequence)toUserId, (CharSequence)ckefuId) && !CharSequenceUtil.equals((CharSequence)channelContext.userid, (CharSequence)ckefuId2)) {
                    wsResult.setMsgType("kefu_chat_out_online");
                    wsResult.setData("\u4f1a\u8bdd\u5df2\u65ad\u5f00\uff0c\u8bf7\u91cd\u65b0\u6392\u961f\u8fdb\u5165");
                    WsResponse toWsResponse = WsResponse.fromText((String)JSON.toJSONString((Object)wsResult), (String)"utf-8");
                    Tio.sendToUser((TioConfig)channelContext.getTioConfig(), (String)channelContext.userid, (Packet)toWsResponse);
                    return null;
                }
                messageData.setId(null);
                wsResult.setMsgType(WsMsgTypePackets.KEFU_MESSAGE.getMsgType());
                messageData = this.storeMessage(messageData, "1", "kefu");
                ImSender.sendToUserChannelContext(messageData.getMessageToId(), channelContext.getTioConfig(), this.buildImPacket(wsResult, messageData));
                String addMessageId = messageData.getId();
                if (!CharSequenceUtil.isNotEmpty((CharSequence)addMessageId)) break;
                WsResultPackets wsResultMap = new WsResultPackets();
                wsResultMap.setMsgType(WsMsgTypePackets.SEND_MESSAGE_ID_RETURN.getMsgType());
                WsMessageDataPackets resultMessage = new WsMessageDataPackets();
                resultMessage.setUnSaveMessageId(messageData.getUnSaveMessageId());
                resultMessage.setUndoMessageId(addMessageId);
                wsResultMap.setData(resultMessage);
                SetWithLock mimeChannelContextSetWithLock = Tio.getByUserid((TioConfig)channelContext.getTioConfig(), (String)channelContext.userid);
                if (mimeChannelContextSetWithLock == null || mimeChannelContextSetWithLock.size() == 0) break;
                WsResponse wsResponse = WsResponse.fromText((String)wsResultMap.toJsonString(), (String)"utf-8");
                Tio.sendToUser((TioConfig)channelContext.getTioConfig(), (String)channelContext.userid, (Packet)wsResponse);
                break;
            }
            case "request_kefu": {
                break;
            }
            case "request_kefu_close_by_user": {
                break;
            }
            case "request_kefu_close_by_kefu": {
                break;
            }
        }
        return null;
    }

    private void sendMessageToOtherSystem(WsMessageDataPackets messageData, String system) {
        try {
            String key = "srm:im:kefu:query_user:" + messageData.getMessageFromId();
            ImUserPackets user = (ImUserPackets)((Object)this.redisUtil.get(key));
            if (null == user) {
                user = this.srmBusinessHelper.loadLoginUserId(messageData.getMessageFromId());
            }
            if (null == user) {
                log.error(":::\u7528\u6237\u4e0d\u5b58\u5728 userId:{}", (Object)messageData.getMessageFromId());
                return;
            }
            this.redisUtil.set(key, (Object)user, 259200L);
            switch (system) {
                case "panshi": {
                    JSONObject paramObj = this.buildPanshiParam(messageData, user);
                    PanshiUtil panshiUtil = (PanshiUtil)SpringContextUtils.getBean(PanshiUtil.class);
                    JSONObject result = panshiUtil.callPanshi("sendKefuMessage", paramObj);
                    log.info(":::\u5ba2\u670d\u53d1\u9001\u6570\u636e\u7ed9Panshi\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)result));
                    break;
                }
                case "ipaas": {
                    ExternalVoucherDto iPassVoucher = ExternalUtil.getVoucher((String)ConfigUtil.getPurchaseAccount(), (String)"ipaas");
                    if (null == iPassVoucher) {
                        throw new ELSBootException("\u672a\u8fdb\u884cIPass\u914d\u7f6e");
                    }
                    JSONObject requestJson = TuLingRobotUtil.buildJSONObject(messageData, iPassVoucher.getVoucherKey().split("_")[0], ConfigUtil.getServiceAddress());
                    JSONObject result = IPaasUtil.callIPaasInterface((JSONObject)requestJson, (String)"valueAddedApplication", (String)"ipass-kefu-anser", (ExternalVoucherDto)iPassVoucher);
                    log.info(":::\u5ba2\u670d\u53d1\u9001\u6570\u636e\u7ed9ipa-as\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)result));
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error(":::\u5ba2\u670d\u53d1\u9001\u6570\u636e\u7ed9{}\u5931\u8d25:{}", (Object)system, (Object)e.getMessage());
        }
    }

    private JSONObject buildPanshiParam(WsMessageDataPackets imMessage, ImUserPackets user) {
        JSONObject bodyObj = new JSONObject();
        bodyObj.put((Object)"elsAccount", (Object)user.getElsAccount());
        bodyObj.put((Object)"subAccount", (Object)user.getSubAccount());
        bodyObj.put((Object)"companyName", (Object)user.getEnterpriseName());
        bodyObj.put((Object)"subAccountName", (Object)user.getRealname());
        bodyObj.put((Object)"msgId", (Object)imMessage.getId());
        JSONObject recordObj = new JSONObject();
        recordObj.put((Object)"content", (Object)imMessage.getMessageContent());
        bodyObj.put((Object)"record", (Object)recordObj);
        return bodyObj;
    }

    private void buildkefuSuccess(String userId, String kefuId) {
        String keFuGroupId = "ke_fu_group_" + userId + "_" + kefuId;
        this.redisUtil.set("srm:im:kefu_user_group_id:" + userId + "_" + kefuId, (Object)keFuGroupId, 1200L);
        WsResultPackets wsResult = new WsResultPackets();
        wsResult.setMsgType("request_kefu_success_notify_to_kefu");
        WsMessageDataPackets message = new WsMessageDataPackets();
        message.setMessageToId(kefuId);
        message.setKefuGroupId(keFuGroupId);
        message.setId(IdWorker.getIdStr());
        message.setMessageFromId(userId);
        message.setMessageContent("\u7528\u6237\u5df2\u8fdb\u5165\u4f1a\u8bdd\u4e2d");
        wsResult.setData(message);
        message.setMessageChatType("kefu");
        ImSender.sendToUserChannelContext(kefuId, (TioConfig)TioConfigConstant.tioServerConfig, this.buildImPacket(wsResult, message));
        wsResult.setMsgType("request_kefu_success_notify_to_user");
        WsMessageDataPackets message1 = new WsMessageDataPackets();
        message1.setId(IdWorker.getIdStr());
        message1.setMessageToId(userId);
        message1.setKefuGroupId(keFuGroupId);
        message1.setMessageFromId(kefuId);
        message1.setMessageContent("\u5ba2\u670d\u5df2\u8fdb\u5165\u4f1a\u8bdd\u4e2d");
        wsResult.setData(message1);
        ImSender.sendToUserChannelContext(userId, (TioConfig)TioConfigConstant.tioServerConfig, this.buildImPacket(wsResult, message1));
        RBucket bucket = this.redissonClient.getBucket("srm:im:kefu:timeout:" + userId);
        bucket.set((Object)kefuId);
        Instant expireAt = Instant.now().plusSeconds(120L);
        bucket.expire(expireAt);
        this.redisUtil.set("srm:im:kefu:kefu_on_chat:user:" + userId, (Object)kefuId, 1200L);
        this.redisUtil.set("srm:im:kefu:kefu_on_chat:kefu:" + kefuId, (Object)userId, 1200L);
    }
}

