/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.core.server.handler.third;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.els.common.util.ConfigUtil;
import com.els.common.util.IPaasUtil;
import com.els.modules.im.core.packets.ImUserPackets;
import com.els.modules.im.core.packets.WsMessageDataPackets;
import com.els.modules.im.core.packets.WsMessagePackets;
import com.els.modules.im.core.server.handler.Opt;
import com.els.modules.im.core.server.handler.third.BaseImToThirdService;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.tio.core.ChannelContext;
import org.tio.websocket.common.WsRequest;

@Service
public class ImToGptService
extends BaseImToThirdService {
    private static final Logger log = LoggerFactory.getLogger(ImToGptService.class);

    @Override
    public String type() {
        return "chat-gpt";
    }

    @Override
    public void sendMessageToThirdAndReplay(WsMessageDataPackets message, final WsRequest wsRequest, String userid, Consumer<Triple<WsRequest, String, ChannelContext>> reCall) {
        JSONObject chatGpt;
        if (this.IGNORE.contains(message.getMessageType())) {
            return;
        }
        log.info("chatGptReplay \u81ea\u52a8\u56de\u590d\u83b7\u53d6\u56de\u590d\u6570\u636e");
        int hashCode = message.getMessageContent().hashCode();
        String key = "srm:im:ai_robot:" + this.type() + ":" + message.getId() + ":" + hashCode;
        Object obj = this.redisUtil.get(key);
        if (obj != null) {
            chatGpt = JSONObject.parseObject((String)JSON.toJSONString((Object)obj));
        } else {
            JSONObject requestJson = this.buildChatGptJSONObject(message, ConfigUtil.getPurchaseAccount(), "gpt-3.5-turbo");
            JSONObject result = IPaasUtil.callIPaasInterface((JSONObject)requestJson, (String)"valueAddedApplication", (String)"chat-gpt");
            chatGpt = this.analysisResult(result);
            if (null != chatGpt) {
                this.redisUtil.set(key, (Object)chatGpt, 259200L);
            } else {
                this.sendNoPermission(message, wsRequest, userid, result.getString("message"), reCall);
                return;
            }
        }
        if (null == chatGpt) {
            return;
        }
        ImUserPackets imUser = this.srmBusinessHelper.loadLoginUserId(message.getId());
        if (null == imUser) {
            return;
        }
        if (chatGpt.containsKey("error")) {
            chatGpt = this.buildError(chatGpt.getString("error"));
        }
        log.info("{}\u81ea\u52a8\u56de\u590d\u83b7\u53d6\u56de\u590d\u6570\u636e\u5373\u5c06\u56de\u590d", (Object)this.type());
        final ChannelContext cc = this.srmBusinessHelper.getChannelContextByUserId(userid);
        if (null == cc) {
            log.error("\u7528\u6237\u5728\u7ebf\u72b6\u6001\u5f02\u5e38");
            return;
        }
        List choices = chatGpt.getJSONArray("choices").toJavaList(JSONObject.class, new JSONReader.Feature[0]);
        for (JSONObject objects : choices) {
            JSONObject messageObj = objects.getJSONObject("message");
            if (null == messageObj) continue;
            String content = messageObj.getString("content");
            final WsMessagePackets sendInfo = new WsMessagePackets();
            sendInfo.setConnCode(Opt.KEFU_MSG_MESSAGE.getValue());
            WsMessageDataPackets messageInfo = new WsMessageDataPackets();
            messageInfo.setId(message.getMessageFromId());
            messageInfo.setMessageFromId(message.getMessageToId());
            messageInfo.setRealname("\u673a\u667a\u7684\u5c0f\u4f01");
            messageInfo.setHeadPortrait("/kefu/static/robot.png");
            messageInfo.setMessageContent(content);
            messageInfo.setMine(false);
            messageInfo.setMessageType("text");
            messageInfo.setMessageReplyByRobot("1");
            messageInfo.setMessageSendTime((Date)DateUtil.date());
            messageInfo.setMessageChatType(message.getMessageChatType());
            sendInfo.setMessage(messageInfo);
            log.info(":::\u6536\u5230\u7684\u6d88\u606f:{},{}\u81ea\u52a8\u56de\u590d\u7684\u6d88\u606f:{}", new Object[]{this.type(), message, sendInfo});
            if (cc.isClosed) continue;
            reCall.accept(new Triple<WsRequest, String, ChannelContext>(){

                public WsRequest getLeft() {
                    return wsRequest;
                }

                public String getMiddle() {
                    return JSON.toJSONString((Object)sendInfo);
                }

                public ChannelContext getRight() {
                    return cc;
                }
            });
        }
    }

    private JSONObject buildChatGptJSONObject(WsMessageDataPackets message, String elsAccount, String model) {
        JSONObject param = new JSONObject();
        param.put((Object)"model", (Object)model);
        JSONObject messageObj = new JSONObject();
        messageObj.put((Object)"role", (Object)"user");
        messageObj.put((Object)"content", (Object)message.getMessageContent());
        JSONArray messages = new JSONArray();
        messages.add((Object)messageObj);
        param.put((Object)"messages", (Object)messages);
        param.put((Object)"currentAccount", (Object)elsAccount);
        return param;
    }

    private JSONObject buildError(String errorMsg) {
        JSONObject param = new JSONObject();
        JSONObject choiceObj = new JSONObject();
        JSONObject message = new JSONObject();
        message.put((Object)"content", (Object)errorMsg);
        choiceObj.put((Object)"message", (Object)message);
        JSONArray choices = new JSONArray();
        choices.add((Object)choiceObj);
        param.put((Object)"choices", (Object)choices);
        return param;
    }
}

