/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.justauth.mp.config;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.els.common.util.SpringContextUtils;
import com.els.modules.account.entity.ExternalVoucher;
import com.els.modules.account.service.ExternalVoucherService;
import com.els.modules.justauth.mp.config.MpConfig;
import com.els.modules.justauth.mp.handler.KeFuHandler;
import com.els.modules.justauth.mp.handler.LogHandler;
import com.els.modules.justauth.mp.handler.MenuHandler;
import com.els.modules.justauth.mp.handler.MpMsgHandler;
import com.els.modules.justauth.mp.handler.ScanHandler;
import com.els.modules.justauth.mp.handler.SubscribeHandler;
import com.els.modules.justauth.mp.handler.UnsubscribeHandler;
import java.util.List;
import java.util.stream.Collectors;
import me.chanjar.weixin.mp.api.WxMpMessageHandler;
import me.chanjar.weixin.mp.api.WxMpMessageRouter;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.impl.WxMpServiceImpl;
import me.chanjar.weixin.mp.config.impl.WxMpDefaultConfigImpl;
import me.chanjar.weixin.mp.config.impl.WxMpRedissonConfigImpl;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;

@Configuration
public class WxServiceBuilder
implements CommandLineRunner {
    private final LogHandler logHandler;
    private final KeFuHandler keFuHandler;
    private final MenuHandler menuHandler;
    private final MpMsgHandler mpMsgHandler;
    private final UnsubscribeHandler unsubscribeHandler;
    private final SubscribeHandler subscribeHandler;
    private final ScanHandler scanHandler;

    private WxMpService createCommonWxMpService() {
        List<ExternalVoucher> configs = ((ExternalVoucherService)SpringContextUtils.getBean(ExternalVoucherService.class)).getAllMpDataConfig();
        List<MpConfig> configList = configs.stream().map(x -> {
            String voucherKey = x.getVoucherKey();
            String voucherSecret = x.getVoucherSecret();
            String extendParam = StrUtil.emptyToDefault((CharSequence)x.getExtendParam(), (String)"{}");
            JSONObject jsonObject = JSON.parseObject((String)extendParam);
            String token = jsonObject.getString("token");
            String encodingAESKey = jsonObject.getString("encodingAESKey");
            return new MpConfig(voucherKey, voucherSecret, token, encodingAESKey);
        }).filter(x -> CharSequenceUtil.isNotEmpty((CharSequence)x.getToken())).toList();
        if (configList.isEmpty()) {
            return new WxMpServiceImpl();
        }
        WxMpServiceImpl service = new WxMpServiceImpl();
        service.setMultiConfigStorages(configList.stream().map(a -> {
            WxMpRedissonConfigImpl configStorage = new WxMpRedissonConfigImpl((RedissonClient)SpringContextUtils.getBean(RedissonClient.class));
            configStorage.setAppId(a.getAppId());
            configStorage.setSecret(a.getSecret());
            configStorage.setToken(a.getToken());
            configStorage.setAesKey(a.getAesKey());
            return configStorage;
        }).collect(Collectors.toMap(WxMpDefaultConfigImpl::getAppId, a -> a, (o, n) -> o)));
        return service;
    }

    private WxMpMessageRouter createWxMpMessageRouter(WxMpService commonWxMpService) {
        WxMpMessageRouter newRouter = new WxMpMessageRouter(commonWxMpService);
        newRouter.rule().handler((WxMpMessageHandler)this.logHandler).next();
        newRouter.rule().async(false).msgType("event").event("kf_create_session").handler((WxMpMessageHandler)this.keFuHandler).end();
        newRouter.rule().async(false).msgType("event").event("kf_close_session").handler((WxMpMessageHandler)this.keFuHandler).end();
        newRouter.rule().async(false).msgType("event").event("kf_switch_session").handler((WxMpMessageHandler)this.keFuHandler).end();
        newRouter.rule().async(false).msgType("event").event("CLICK").handler((WxMpMessageHandler)this.menuHandler).end();
        newRouter.rule().async(false).msgType("event").event("subscribe").handler((WxMpMessageHandler)this.subscribeHandler).end();
        newRouter.rule().async(false).msgType("event").event("unsubscribe").handler((WxMpMessageHandler)this.unsubscribeHandler).end();
        newRouter.rule().async(false).msgType("event").event("SCAN").handler((WxMpMessageHandler)this.scanHandler).end();
        newRouter.rule().async(false).handler((WxMpMessageHandler)this.mpMsgHandler).end();
        return newRouter;
    }

    public void run(String ... args) throws Exception {
        WxMpService commonWxMpService = this.createCommonWxMpService();
        WxMpMessageRouter wxMpMessageRouter = this.createWxMpMessageRouter(commonWxMpService);
        ApplicationContext applicationContext = SpringContextUtils.getApplicationContext();
        ConfigurableListableBeanFactory beanFactory = (ConfigurableListableBeanFactory)applicationContext.getAutowireCapableBeanFactory();
        beanFactory.registerSingleton("commonWxMpService", (Object)commonWxMpService);
        beanFactory.registerSingleton("wxMpMessageRouter", (Object)wxMpMessageRouter);
    }

    public WxServiceBuilder(LogHandler logHandler, KeFuHandler keFuHandler, MenuHandler menuHandler, MpMsgHandler mpMsgHandler, UnsubscribeHandler unsubscribeHandler, SubscribeHandler subscribeHandler, ScanHandler scanHandler) {
        this.logHandler = logHandler;
        this.keFuHandler = keFuHandler;
        this.menuHandler = menuHandler;
        this.mpMsgHandler = mpMsgHandler;
        this.unsubscribeHandler = unsubscribeHandler;
        this.subscribeHandler = subscribeHandler;
        this.scanHandler = scanHandler;
    }
}

