/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.justauth.mp.handler;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.els.modules.account.api.dto.WebChatMpMsgDTO;
import com.els.modules.justauth.mp.rpc.service.WebChatMpMsgService;
import jakarta.annotation.Resource;
import java.util.Map;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.mp.api.WxMpMessageHandler;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import me.chanjar.weixin.mp.builder.outxml.ImageBuilder;
import me.chanjar.weixin.mp.builder.outxml.TextBuilder;
import me.chanjar.weixin.mp.builder.outxml.TransferCustomerServiceBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class MpMsgHandler
implements WxMpMessageHandler {
    private static final Logger log = LoggerFactory.getLogger(MpMsgHandler.class);
    @Resource
    @Lazy
    private WebChatMpMsgService webChatMpMsgService;

    public WxMpXmlOutMessage handle(WxMpXmlMessage wxMessage, Map<String, Object> context, WxMpService weixinService, WxSessionManager sessionManager) {
        try {
            if (StringUtils.startsWithAny((CharSequence)wxMessage.getContent(), (CharSequence[])new CharSequence[]{"\u4eba\u5de5\u5ba2\u670d"}) && weixinService.getKefuService().kfOnlineList().getKfOnlineList().size() > 0) {
                return ((TransferCustomerServiceBuilder)((TransferCustomerServiceBuilder)WxMpXmlOutMessage.TRANSFER_CUSTOMER_SERVICE().fromUser(wxMessage.getToUser())).toUser(wxMessage.getFromUser())).build();
            }
        }
        catch (Exception e) {
            log.info("MsgHandler:{}", (Object)e.getMessage());
        }
        String configParam = (String)wxMessage.getAllFieldsMap().get("configParam");
        JSONObject message = JSON.parseObject((String)JSON.toJSONString((Object)wxMessage));
        message.put((Object)"configParam", (Object)configParam);
        WebChatMpMsgDTO result = this.webChatMpMsgService.handlerMsg(message);
        if (CharSequenceUtil.isNotEmpty((CharSequence)result.getMediaId())) {
            return ((ImageBuilder)((ImageBuilder)WxMpXmlOutMessage.IMAGE().mediaId(result.getMediaId()).fromUser(wxMessage.getToUser())).toUser(wxMessage.getFromUser())).build();
        }
        return ((TextBuilder)((TextBuilder)WxMpXmlOutMessage.TEXT().content(result.getContent()).fromUser(wxMessage.getToUser())).toUser(wxMessage.getFromUser())).build();
    }
}

