/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.log.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.ConvertUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.log.entity.Log;
import com.els.modules.log.excel.LogExportServiceImpl;
import com.els.modules.log.excel.SupplierLogExportServiceImpl;
import com.els.modules.log.service.LogService;
import com.els.modules.log.vo.LogVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/log"})
@Tag(name="\u7cfb\u7edf\u65e5\u5fd7")
public class LogController
extends BaseController<Log, LogService> {
    private static final Logger log = LoggerFactory.getLogger(LogController.class);
    @Autowired
    private LogService logService;

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"log#log:list"})
    public Result<IPage<Log>> queryPageList(Log syslog, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result result = new Result();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)syslog, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        String keyWord = req.getParameter("keyWord");
        if (ConvertUtils.isNotEmpty((Object)keyWord)) {
            queryWrapper.like((Object)"business_number", (Object)keyWord);
        }
        queryWrapper.lambda().eq(Log::getElsAccount, (Object)TenantContext.getTenant());
        IPage pageList = this.logService.page((IPage)page, (Wrapper)queryWrapper);
        log.info("\u67e5\u8be2\u5f53\u524d\u9875\uff1a" + pageList.getCurrent());
        log.info("\u67e5\u8be2\u5f53\u524d\u9875\u6570\u91cf\uff1a" + pageList.getSize());
        log.info("\u67e5\u8be2\u7ed3\u679c\u6570\u91cf\uff1a" + pageList.getRecords().size());
        log.info("\u6570\u636e\u603b\u6570\uff1a" + pageList.getTotal());
        result.setSuccess(true);
        result.setResult((Object)pageList);
        return result;
    }

    @Operation(summary="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u64cd\u4f5c\u8bb0\u5f55\u67e5\u8be2", description="\u7cfb\u7edf\u81ea\u5b9a\u4e49\u5217-\u64cd\u4f5c\u8bb0\u5f55\u67e5\u8be2")
    @GetMapping(value={"/queryOptHisList"})
    @RequiresPermissions(value={"log#log:queryOptHisList"})
    public Result<?> queryOptHisList(Log log, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = new QueryWrapper();
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.likeRight((Object)"business_id", (Object)req.getParameter("businessId"));
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.orderByDesc((Object)"create_time");
        IPage pageList = this.logService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @Operation(summary="\u7cfb\u7edf\u65e5\u5fd7-\u67e5\u8be2\u4f9b\u5e94\u5546\u767b\u5f55\u7edf\u8ba1\u5217\u8868", description="\u7cfb\u7edf\u65e5\u5fd7-\u67e5\u8be2\u4f9b\u5e94\u5546\u767b\u5f55\u7edf\u8ba1\u5217\u8868")
    @GetMapping(value={"/querySupplierLoginList"})
    @RequiresPermissions(value={"log#log:querySupplierLoginList"})
    public Result<?> querySupplierLoginList(LogVO logVO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        logVO.setPageNo(pageNo);
        logVO.setPageSize(pageSize);
        IPage<Log> pageList = this.logService.selectPageList(logVO);
        return Result.ok(pageList);
    }

    @Operation(summary="\u7cfb\u7edf\u65e5\u5fd7-\u67e5\u8be2\u7528\u6237\u767b\u5f55\u60c5\u51b5\u5217\u8868", description="\u7cfb\u7edf\u65e5\u5fd7-\u67e5\u8be2\u7528\u6237\u767b\u5f55\u60c5\u51b5\u5217\u8868")
    @GetMapping(value={"/findUserLoginList"})
    @RequiresPermissions(value={"log#log:list"})
    public Result<?> findUserLoginList(LogVO logVO, HttpServletRequest req) {
        logVO.setElsAccount(this.getTenantId());
        List<LogVO> pageList = this.logService.findUserLoginList(logVO);
        return Result.ok(pageList);
    }

    @PostMapping(value={"/exportXls"})
    @RequiresPermissions(value={"log#log:export"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, LogExportServiceImpl.class);
    }

    @PostMapping(value={"/exportSupplierXls"})
    @RequiresPermissions(value={"log#log:export"})
    public ModelAndView exportSupplierXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, SupplierLogExportServiceImpl.class);
    }
}

