/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.handle.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.els.common.util.SpringContextUtils;
import com.els.modules.account.entity.ExternalAccount;
import com.els.modules.account.service.ExternalAccountService;
import com.els.modules.integration.api.dto.ExternalVoucherDto;
import com.els.modules.justauth.util.ThirdAuthUtil;
import com.els.modules.message.entity.ElsMsgConfigItem;
import com.els.modules.message.handle.enums.SendMsgTypeEnum;
import com.els.modules.message.handle.impl.AbstractSendMsgImpl;
import com.els.modules.message.vo.MsgVO;
import com.els.modules.system.entity.ElsSubAccount;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FeiShuSendMsgImpl
extends AbstractSendMsgImpl {
    private static final Logger log = LoggerFactory.getLogger(FeiShuSendMsgImpl.class);

    @Override
    public void doSendMsg(MsgVO msg) {
        log.info("FeiShuSendMsgImpl\u51c6\u5907\u6267\u884c\u53d1\u9001\u98de\u4e66\u6d88\u606f\u7684\u903b\u8f91.");
        ElsMsgConfigItem configItem = msg.getConfigItem();
        if (null == configItem) {
            log.warn("FeiShuSendMsgImpl\u7f3a\u5c11\u98de\u4e66\u6d88\u606f\u914d\u7f6e");
            return;
        }
        ElsSubAccount receiveAccountInfo = msg.getReceiveAccountInfo();
        ExternalAccountService externalAccountService = (ExternalAccountService)SpringContextUtils.getBean(ExternalAccountService.class);
        ExternalAccount externalAccount = externalAccountService.getEnableAccount(receiveAccountInfo.getElsAccount(), receiveAccountInfo.getId());
        if (null == externalAccount) {
            log.warn("FeiShuSendMsgImpl receive not bind FEISHU");
            return;
        }
        ExternalVoucherDto config = this.getJustConfig(receiveAccountInfo.getElsAccount(), "feishu");
        if (null == config || StrUtil.isEmpty((CharSequence)config.getVoucherKey())) {
            log.error(":::\u98de\u4e66\u7b2c\u4e09\u65b9\u914d\u7f6e\u4e0d\u5b58\u5728,elsAccount:{}", (Object)receiveAccountInfo.getElsAccount());
            return;
        }
        try {
            String accessToken = ThirdAuthUtil.getFeiShuToken(receiveAccountInfo.getElsAccount(), config);
            String titleCont = StringUtils.isNotBlank((CharSequence)configItem.getMsgTitle()) ? configItem.getMsgTitle() : "\u672a\u547d\u540d";
            String detailUrl = this.buildLinkUrl(msg.getBusinessObj(), configItem.getLinkUrl(), "", msg.getBusAccount(), msg.getReceiveAccountInfo());
            String receiveId = externalAccount.getExternalAccountId();
            String bodyCont = this.parseContentTemplateText("", configItem.getMsgContent(), (Map<String, Object>)msg.getBusinessObj());
            titleCont = this.parseContentTemplateText("", titleCont, (Map<String, Object>)msg.getBusinessObj());
            JSONObject bodyJson = FeiShuSendMsgImpl.getFeiShuSmsObj(titleCont, bodyCont, detailUrl, receiveId);
            String result = ((HttpRequest)((HttpRequest)HttpRequest.post((String)"https://open.feishu.cn/open-apis/im/v1/messages?receive_id_type=union_id").header("Authorization", "Bearer " + accessToken)).header("content-type", "application/json; charset=utf-8")).body(bodyJson.toJSONString(new JSONWriter.Feature[0])).execute().body();
            log.info(":::FeiShuSendMsgImpl send message result:{}", (Object)result);
        }
        catch (Exception e) {
            log.error(":::FeiShuSendMsgImpl \u98de\u4e66\u53d1\u9001\u6d88\u606f\u5f02\u5e38:{}", (Object)e.getMessage());
        }
    }

    @Override
    protected String getOauthUrl() {
        return "/els/base/thirdLogin/loadQrCode/%s/mobile/feishu";
    }

    private static JSONObject getFeiShuSmsObj(String titleCont, String bodyCont, String detailUrl, String receiveId) {
        JSONObject json = new JSONObject();
        json.put((Object)"msg_type", (Object)"interactive");
        JSONObject content = new JSONObject();
        JSONObject config = new JSONObject();
        config.put((Object)"wide_screen_mode", (Object)true);
        JSONObject header = new JSONObject();
        HashMap<String, String> title = new HashMap<String, String>();
        title.put("tag", "plain_text");
        title.put("content", titleCont);
        header.put((Object)"template", (Object)"blue");
        header.put((Object)"title", title);
        ArrayList elements = new ArrayList();
        HashMap<String, Object> elementOne = new HashMap<String, Object>();
        HashMap<String, Object> textOne = new HashMap<String, Object>();
        textOne.put("content", bodyCont + "\n[\u8be6\u60c5](" + detailUrl + ")");
        textOne.put("tag", "lark_md");
        elementOne.put("tag", "div");
        elementOne.put("text", textOne);
        elements.add(elementOne);
        content.put((Object)"config", (Object)config);
        content.put((Object)"header", (Object)header);
        content.put((Object)"elements", elements);
        json.put((Object)"content", (Object)content.toJSONString(new JSONWriter.Feature[0]));
        json.put((Object)"receive_id", (Object)receiveId);
        return json;
    }

    @Override
    public String supportType() {
        return SendMsgTypeEnum.FEI_SHU.getType();
    }

    public static void main(String[] args) {
        JSONObject jsonObject = FeiShuSendMsgImpl.getFeiShuSmsObj("\u91c7\u8d2d\u901a\u77e5\u5355", "\u7269\u6599A-002\u5b58\u5728\u4e0d\u5408\u683c\u7684\u68c0\u6d4b\uff0c\u8bf7\u8d1f\u8d23\u4eba\u91cd\u65b0\u5b89\u6392\u4eba\u5458\u53bb\u5904\u7406\u8fd9\u4ef6\u4e8b\u3002", "https://www.feishu.cn", "on_af43c1dc2226c2c9e88deb604ff69980");
        String result = ((HttpRequest)((HttpRequest)HttpRequest.post((String)"https://open.feishu.cn/open-apis/im/v1/messages?receive_id_type=union_id").header("Authorization", "Bearer t-5ab1f6d33e6f1b3dc9b5db757a7ee091704315a7")).header("content-type", "application/json; charset=utf-8")).body(jsonObject.toJSONString(new JSONWriter.Feature[0])).execute().body();
        System.out.println(result);
    }
}

