/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.els.common.constant.CommonConstant;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.ExcelImportCheckDTO;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.system.entity.ExcelDetail;
import com.els.modules.system.enums.ExcelDataTypeEnum;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelDataCheckListener
extends AnalysisEventListener<Map<Integer, String>> {
    private static final Logger log = LoggerFactory.getLogger(ExcelDataCheckListener.class);
    private List<Map<String, Object>> importDataList = new ArrayList<Map<String, Object>>();
    private ExcelImportCheckDTO checkDTO;
    private Map<String, Object> primaryMap = new HashMap<String, Object>(16);
    private List<ExcelDetail> excelDetailList;
    private List<String> fileHeadTitle;
    private int row = 0;
    private ExcelImportRpcService service;
    private InvokeBaseRpcService invokeBaseRpcService;
    private String dataKey;
    private List<Map<String, Object>> otherSheetList;
    private final String elsAccount;

    public ExcelDataCheckListener(ExcelImportRpcService service, List<ExcelDetail> excelDetailList, String dataKey, InvokeBaseRpcService invokeBaseRpcService, List<Map<String, Object>> otherSheetList, String elsAccount) {
        this.service = service;
        this.excelDetailList = excelDetailList;
        this.dataKey = dataKey;
        this.invokeBaseRpcService = invokeBaseRpcService;
        this.otherSheetList = otherSheetList;
        this.elsAccount = elsAccount;
    }

    public List<Map<String, Object>> getImportDataList() {
        return this.importDataList;
    }

    private String getDictValue(ExcelDetail detail, String val) {
        String dictCode = detail.getDataFormat();
        val = this.invokeBaseRpcService.queryDictCodeByText(dictCode, val, SysUtil.getLoginUser().getElsAccount());
        return val;
    }

    public void invoke(Map<Integer, String> data, AnalysisContext context) {
        ++this.row;
        if (this.row == 1) {
            this.fileHeadTitle = Lists.newArrayList(data.values());
            return;
        }
        int headRow = 2;
        if (this.row <= headRow) {
            return;
        }
        HashMap newData = new HashMap(data.size());
        if (CollUtil.isNotEmpty(data)) {
            data.forEach((key, val) -> {
                String title = this.fileHeadTitle.get((int)key);
                newData.put(title, val);
            });
        }
        HashMap<String, String> dataMap = new HashMap<String, String>(16);
        StringBuilder primaryKey = new StringBuilder();
        boolean check = true;
        HashMap excelData = new HashMap();
        for (ExcelDetail detail : this.excelDetailList) {
            String columnCode = detail.getColumnCode();
            String val2 = (String)newData.get(columnCode);
            if (StrUtil.isNotBlank((CharSequence)val2)) {
                if (ExcelDataTypeEnum.DICT.getCode().equals(detail.getDataType())) {
                    StringBuffer temVal = new StringBuffer("");
                    if (StrUtil.isNotBlank((CharSequence)val2) && val2.contains(",")) {
                        String[] split = val2.split(",");
                        for (int i = 0; i < split.length; ++i) {
                            String dictValue;
                            if (!StrUtil.isNotBlank((CharSequence)split[i]) || !StrUtil.isNotBlank((CharSequence)(dictValue = this.getDictValue(detail, split[i])))) continue;
                            temVal.append(dictValue).append(",");
                        }
                    } else {
                        temVal.append(this.getDictValue(detail, val2));
                    }
                    val2 = temVal.toString();
                    if (val2.endsWith(",")) {
                        val2 = val2.substring(0, val2.length() - 1);
                    }
                    if (StrUtil.isBlank((CharSequence)val2)) {
                        check = false;
                        break;
                    }
                    dataMap.put(columnCode, val2);
                } else if (ExcelDataTypeEnum.DATE.getCode().equals(detail.getDataType())) {
                    if (detail.getDataFormat() == null || detail.getDataFormat().length() < 11) {
                        if (val2.length() > 0 && val2.length() < 11) {
                            check = false;
                            break;
                        }
                        val2 = val2.substring(0, 10);
                        dataMap.put(columnCode, val2);
                    }
                } else if (ExcelDataTypeEnum.NUMBER.getCode().equals(detail.getDataType())) {
                    try {
                        Double dVal = Double.valueOf(val2);
                        BigDecimal bVal = BigDecimal.valueOf(dVal).setScale(4, 4);
                        dataMap.put(columnCode, bVal.stripTrailingZeros().toPlainString());
                    }
                    catch (NumberFormatException e) {
                        dataMap.put(detail.getColumnCode(), val2);
                    }
                } else {
                    dataMap.put(columnCode, val2);
                }
                if ("1".equals(detail.getPrimaryKey())) {
                    primaryKey.append(val2).append(",");
                }
            } else if ("1".equals(detail.getRequired())) {
                check = false;
                break;
            }
            Object obj = dataMap.get(columnCode);
            String oldObj = (String)newData.get(columnCode);
            if ((null == obj || "".equals(obj.toString()) || "null".equals(obj.toString())) && null != oldObj && obj != oldObj) {
                dataMap.put(columnCode, oldObj);
            }
            excelData.put(columnCode, newData.get(columnCode));
        }
        if (StrUtil.isNotBlank((CharSequence)primaryKey.toString())) {
            if (this.primaryMap.containsKey(primaryKey.toString())) {
                check = false;
            } else {
                this.primaryMap.put(primaryKey.toString(), CommonConstant.STATUS_YES);
            }
        }
        if (!check) {
            return;
        }
        if (dataMap.size() == 0) {
            return;
        }
        dataMap.put("els_account", this.elsAccount);
        this.importDataList.add(dataMap);
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        this.fileHeadTitle = null;
        RedisUtil redisUtil = (RedisUtil)SpringContextUtils.getBean(RedisUtil.class);
        ExcelImportDTO excelImportDTO = null;
        if (StrUtil.isBlank((CharSequence)this.dataKey)) {
            if (CollectionUtil.isNotEmpty(this.otherSheetList)) {
                HashMap<String, List<Map<String, Object>>> otherMap = new HashMap<String, List<Map<String, Object>>>();
                otherMap.put("otherSheetList", this.otherSheetList);
                this.importDataList.add(otherMap);
            }
            excelImportDTO = new ExcelImportDTO();
            excelImportDTO.setDataList(this.importDataList);
        } else {
            excelImportDTO = (ExcelImportDTO)redisUtil.get(this.dataKey);
        }
        this.checkDTO = this.service.interactiveCheck(excelImportDTO);
    }

    public ExcelImportCheckDTO getCheckDTO() {
        return this.checkDTO;
    }
}

