/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.account.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.ConfigUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SrmUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.entity.ExternalVoucher;
import com.els.modules.account.enums.ExternalVoucherTypeEnum;
import com.els.modules.account.mapper.ExternalVoucherMapper;
import com.els.modules.account.service.ExternalVoucherService;
import com.els.modules.account.sso.ExternalSsoUrlService;
import com.els.modules.account.vo.VoucherSsoVO;
import com.els.modules.integration.api.dto.ExternalVoucherDto;
import com.els.modules.justauth.mp.util.WxMpServiceRefreshUtil;
import jakarta.annotation.Resource;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ExternalVoucherServiceImpl
extends BaseServiceImpl<ExternalVoucherMapper, ExternalVoucher>
implements ExternalVoucherService {
    private static final Logger log = LoggerFactory.getLogger(ExternalVoucherServiceImpl.class);
    @Resource
    private RedisUtil redisUtil;
    private static final String SSO_BEAN_SUB = "SsoUrlServiceImpl";
    private static final String SSO_URL = "ssoUrl";

    @Override
    public void add(ExternalVoucher voucher) {
        this.checkExist(voucher);
        ((ExternalVoucherMapper)this.baseMapper).insert((Object)voucher);
        if ("wechat_mp".equals(voucher.getVoucherType())) {
            WxMpServiceRefreshUtil.updateConfig(voucher);
        }
    }

    private void checkExist(ExternalVoucher voucher) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ParentEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(ExternalVoucher::getVoucherType, (Object)voucher.getVoucherType())).ne(CharSequenceUtil.isNotEmpty((CharSequence)voucher.getId()), ParentEntity::getId, (Object)voucher.getId());
        Long count = ((ExternalVoucherMapper)this.baseMapper).selectCount((Wrapper)wrapper);
        if (count > 0L) {
            throw new ELSBootException(I18nUtil.translate((String)"\u5f53\u524d\u51ed\u8bc1\u7c7b\u578b\u5df2\u5b58\u5728\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6dfb\u52a0"));
        }
    }

    private String getRedisKey(String elsAccount, String voucherType) {
        return "srm:base:external:voucher:" + elsAccount + ":" + voucherType;
    }

    @Override
    public void edit(ExternalVoucher voucher) {
        this.checkExist(voucher);
        this.redisUtil.deleteByPrex(this.getRedisKey(super.getElsAccount(), voucher.getVoucherType()));
        this.redisUtil.deleteByPrex("srm:base:integration:auth:");
        int count = ((ExternalVoucherMapper)this.baseMapper).update((Object)voucher, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(ParentEntity::getId, (Object)voucher.getId())).eq(ParentEntity::getElsAccount, (Object)super.getElsAccount()));
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        if ("wechat_mp".equals(voucher.getVoucherType())) {
            WxMpServiceRefreshUtil.updateConfig(voucher);
        }
    }

    @Override
    public void delete(String id) {
        ExternalVoucher dbVoucher = (ExternalVoucher)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ParentEntity::getId, (Object)id)).eq(ParentEntity::getElsAccount, (Object)super.getElsAccount())));
        Assert.notNull((Object)((Object)dbVoucher), (String)"\u51ed\u8bc1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        this.redisUtil.deleteByPrex(this.getRedisKey(dbVoucher.getElsAccount(), dbVoucher.getVoucherType()));
        ((ExternalVoucherMapper)this.baseMapper).physicalDelete(super.getElsAccount(), id);
        if ("wechat_mp".equals(dbVoucher.getVoucherType())) {
            WxMpServiceRefreshUtil.removeConfig(id);
        }
    }

    @Override
    public ExternalVoucher getVoucherByType(String elsAccount, ExternalVoucherTypeEnum voucherType) {
        return this.getParamElsAccountVoucherByType(elsAccount, voucherType.getValue());
    }

    public ExternalVoucher getParamElsAccountVoucherByTypeAndKey(String elsAccount, String voucherType, String voucherKey) {
        String templateType = voucherType + "_" + voucherKey;
        ExternalVoucher paramElsAccountVoucherByType = null;
        try {
            paramElsAccountVoucherByType = this.getParamElsAccountVoucherByType(elsAccount, templateType);
        }
        catch (Exception e) {
            paramElsAccountVoucherByType = this.getParamElsAccountVoucherByType(elsAccount, voucherType);
        }
        return paramElsAccountVoucherByType;
    }

    @Override
    public ExternalVoucher getParamElsAccountVoucherByType(String elsAccount, String voucherType) {
        String redisKey = this.getRedisKey(elsAccount, voucherType);
        ExternalVoucher voucher = (ExternalVoucher)((Object)this.redisUtil.get(redisKey));
        if (voucher == null) {
            ExternalVoucher dbVoucher = (ExternalVoucher)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ParentEntity::getElsAccount, (Object)elsAccount)).eq(ExternalVoucher::getVoucherType, (Object)voucherType)));
            Assert.notNull((Object)((Object)dbVoucher), (String)I18nUtil.translate((String)"\u7b2c\u4e09\u65b9\u51ed\u8bc1\u4e2d\u6ca1\u6709\u914d\u7f6e{0}\u51ed\u8bc1", (String)voucherType));
            this.redisUtil.set(redisKey, (Object)dbVoucher);
            return dbVoucher;
        }
        return voucher;
    }

    @Override
    public ExternalVoucherDto getVoucherByType(String elsAccount, String voucherType) {
        String redisKey = this.getRedisKey(elsAccount, voucherType);
        ExternalVoucher externalVoucher = this.getVoucher(elsAccount, redisKey, voucherType);
        if (null == externalVoucher && !ConfigUtil.getPurchaseAccount().equalsIgnoreCase(elsAccount)) {
            redisKey = this.getRedisKey(ConfigUtil.getPurchaseAccount(), voucherType);
            externalVoucher = this.getVoucher(ConfigUtil.getPurchaseAccount(), redisKey, voucherType);
        }
        if (null == externalVoucher && !"100000".equalsIgnoreCase(elsAccount) && !"100000".equalsIgnoreCase(ConfigUtil.getPurchaseAccount())) {
            redisKey = this.getRedisKey("100000", voucherType);
            externalVoucher = this.getVoucher("100000", redisKey, voucherType);
        }
        Assert.notNull((Object)((Object)externalVoucher), (String)I18nUtil.translate((String)"\u7b2c\u4e09\u65b9\u51ed\u8bc1\u4e2d\u6ca1\u6709\u914d\u7f6e{0}\u51ed\u8bc1", (String)voucherType));
        this.redisUtil.set(redisKey, (Object)externalVoucher);
        return (ExternalVoucherDto)SrmUtil.copyProperties((Object)((Object)externalVoucher), ExternalVoucherDto.class);
    }

    private ExternalVoucher getVoucher(String elsAccount, String redisKey, String voucherType) {
        ExternalVoucher voucher = (ExternalVoucher)((Object)this.redisUtil.get(redisKey));
        if (null != voucher) {
            return voucher;
        }
        return (ExternalVoucher)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ParentEntity::getElsAccount, (Object)elsAccount)).eq(ExternalVoucher::getVoucherType, (Object)voucherType)));
    }

    @Override
    public ExternalVoucher getOneBindLoginDataConfig(String elsAccount, String voucherType) {
        String redisKey = this.getRedisKey(elsAccount, voucherType + ":dataConfig");
        ExternalVoucher voucher = (ExternalVoucher)((Object)this.redisUtil.get(redisKey));
        if (voucher == null) {
            voucher = (ExternalVoucher)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ParentEntity::getElsAccount, (Object)elsAccount)).eq(ExternalVoucher::getVoucherType, (Object)voucherType)).and(i -> ((LambdaQueryWrapper)((LambdaQueryWrapper)i.isNull(ExternalVoucher::getExtendParam)).or()).notLike(ExternalVoucher::getExtendParam, (Object)"templateConfig"))));
            Assert.notNull((Object)((Object)voucher), (String)I18nUtil.translate((String)"\u7b2c\u4e09\u65b9\u51ed\u8bc1\u4e2d\u6ca1\u6709\u914d\u7f6e{0}\u51ed\u8bc1", (String)voucherType));
            this.redisUtil.set(redisKey, (Object)voucher);
        }
        return voucher;
    }

    @Override
    public List<ExternalVoucher> getAllMpDataConfig() {
        return ((ExternalVoucherMapper)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ExternalVoucher::getVoucherType, (Object)"wechat_mp")).isNotNull(ExternalVoucher::getVoucherKey)).isNotNull(ExternalVoucher::getExtendParam));
    }

    @Override
    public ExternalVoucher getOneBindLoginTemplateConfig(String elsAccount, String voucherType) {
        String redisKey = this.getRedisKey(elsAccount, voucherType + ":templateConfig");
        ExternalVoucher voucher = (ExternalVoucher)((Object)this.redisUtil.get(redisKey));
        if (voucher == null) {
            voucher = (ExternalVoucher)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ParentEntity::getElsAccount, (Object)elsAccount)).eq(ExternalVoucher::getVoucherType, (Object)voucherType)).and(i -> ((LambdaQueryWrapper)((LambdaQueryWrapper)i.isNull(ExternalVoucher::getExtendParam)).or()).notLike(ExternalVoucher::getExtendParam, (Object)"templateConfig"))));
            Assert.notNull((Object)((Object)voucher), (String)("\u7b2c\u4e09\u65b9\u51ed\u8bc1\u4e2d\u6ca1\u6709\u914d\u7f6e" + voucherType + "\u51ed\u8bc1"));
            this.redisUtil.set(redisKey, (Object)voucher);
        }
        return voucher;
    }

    @Override
    public void weDevelopCreateAuth(ExternalVoucher wechatMp, JSONObject jsonObject) {
        JSONObject authCorpInfo = jsonObject.getJSONObject("auth_corp_info");
        String clientId = authCorpInfo.getString("corpid");
        String authCorpName = authCorpInfo.getString("corp_name");
        String clientSecret = jsonObject.getString("permanent_code");
        JSONArray jsonArray = jsonObject.getJSONObject("auth_info").getJSONArray("agent");
        JSONObject jsonObject2 = jsonArray.getJSONObject(0);
        String agentId = jsonObject2.getString("agentid");
        log.info("#createAuth \u81ea\u52a8\u521b\u5efa\u4f01\u4e1a\u5fae\u4fe1\u5e94\u7528\u4ee3\u5f00\u53d1\u6388\u6743\u914d\u7f6e:{},clientId:{} \u5f00\u59cb", (Object)jsonObject.toJSONString(new JSONWriter.Feature[0]), (Object)clientId);
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ExternalVoucher::getVoucherType, (Object)"wechat_enterprise_develop")).eq(ExternalVoucher::getVoucherKey, (Object)clientId)).isNotNull(ExternalVoucher::getExtendParam)).like(ExternalVoucher::getExtendParam, (Object)"dataConfig")).orderByDesc(BaseEntity::getUpdateTime);
        ExternalVoucher config = null;
        List list = ((ExternalVoucherMapper)this.baseMapper).selectList((Wrapper)wrapper);
        if (!list.isEmpty()) {
            config = (ExternalVoucher)((Object)list.get(0));
        }
        log.warn("weDevelopCreateAuth\u81ea\u5efa\u5e94\u7528\u4ee3\u5f00\u53d1\u53ea\u5141\u8bb8\u914d\u7f6e\u4e00\u4e2a,\u8fd9\u91cc\u53d6\u6700\u540e\u66f4\u65b0\u7684\u4e00\u4e2a");
        if (null == config) {
            config = new ExternalVoucher();
            config.setVoucherType(wechatMp.getVoucherType());
            config.setVoucherKey(clientId);
            config.setElsAccount(clientId);
            config.setVoucherSecret(clientSecret);
            JSONObject param = new JSONObject();
            param.put((Object)"configType", (Object)"dataConfig");
            param.put((Object)"enterpriseName", (Object)authCorpName);
            config.setExtendParam(param.toJSONString(new JSONWriter.Feature[0]));
        }
        config.setVoucherAgentId(agentId);
        this.saveOrUpdate((Object)config);
        log.info("#createAuth \u81ea\u52a8\u521b\u5efa\u4f01\u4e1a\u5fae\u4fe1\u5e94\u7528\u4ee3\u5f00\u53d1\u6388\u6743\u914d\u7f6e:{},clientId:{} \u5b8c\u6bd5", (Object)jsonObject.toJSONString(new JSONWriter.Feature[0]), (Object)clientId);
    }

    @Override
    public void weDevelopBindAuth(String corpId, String busAccount) {
        LambdaQueryWrapper countWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)countWrapper.eq(ExternalVoucher::getVoucherKey, (Object)corpId)).eq(ExternalVoucher::getVoucherType, (Object)"wechat_enterprise_develop")).isNotNull(ExternalVoucher::getExtendParam)).like(ExternalVoucher::getExtendParam, (Object)"dataConfig")).eq(ParentEntity::getElsAccount, (Object)busAccount);
        Long count = ((ExternalVoucherMapper)this.baseMapper).selectCount((Wrapper)countWrapper);
        if (count > 0L) {
            return;
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ExternalVoucher::getVoucherKey, (Object)corpId)).isNotNull(ExternalVoucher::getExtendParam)).like(ExternalVoucher::getExtendParam, (Object)"dataConfig")).eq(ExternalVoucher::getVoucherType, (Object)"wechat_enterprise_develop")).eq(ParentEntity::getElsAccount, (Object)corpId);
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        ExternalVoucher configs = null;
        List list = ((ExternalVoucherMapper)this.baseMapper).selectList((Wrapper)wrapper);
        if (!list.isEmpty()) {
            configs = (ExternalVoucher)((Object)list.get(0));
        }
        if (null != configs) {
            configs.setElsAccount(busAccount);
            this.updateById((Object)configs);
            log.info("bindAuth \u4f01\u4e1a\u5e94\u7528\u4ee3\u5f00\u53d1\u9996\u6b21\u7ed1\u5b9a\u79df\u6237,corpId:{},busAccount:{}", (Object)corpId, (Object)busAccount);
            return;
        }
        wrapper.clear();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ExternalVoucher::getVoucherKey, (Object)corpId)).isNotNull(ExternalVoucher::getExtendParam)).like(ExternalVoucher::getExtendParam, (Object)"dataConfig")).eq(ExternalVoucher::getVoucherType, (Object)"wechat_enterprise_develop")).ne(ParentEntity::getElsAccount, (Object)busAccount);
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list1 = ((ExternalVoucherMapper)this.baseMapper).selectList((Wrapper)wrapper);
        if (!list1.isEmpty()) {
            configs = (ExternalVoucher)((Object)list1.get(0));
        }
        if (null != configs) {
            configs.setElsAccount(busAccount);
            this.updateById((Object)configs);
            log.info("bindAuth \u4f01\u4e1a\u5e94\u7528\u4ee3\u5f00\u53d1\u53d8\u66f4\u7ed1\u5b9a\u79df\u6237,corpId:{},busAccount:{},id:{}", new Object[]{corpId, busAccount, configs.getId()});
        }
    }

    private void check(VoucherSsoVO vo) {
        String ymlConfigValue = ConfigUtil.getYmlConfigValue((String)"els.config.ssoSafeCode");
        if (CharSequenceUtil.isNotEmpty((CharSequence)vo.getVoucherKey()) && !ymlConfigValue.contains(vo.getVoucherKey())) {
            throw new ELSBootException("\u5f53\u524d\u7f16\u7801\u4e0d\u5141\u8bb8\u8bbf\u95ee");
        }
    }

    @Override
    public String getSsoUrl(String elsAccount, String type, VoucherSsoVO vo) {
        String url;
        ExternalSsoUrlService ssoUrlService = null;
        if (null == vo) {
            this.check(vo);
            if (CharSequenceUtil.isNotEmpty((CharSequence)vo.getVoucherKey())) {
                try {
                    ssoUrlService = (ExternalSsoUrlService)SpringContextUtils.getBean((String)(type + vo.getVoucherKey() + SSO_BEAN_SUB), ExternalSsoUrlService.class);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (null == ssoUrlService) {
            try {
                ssoUrlService = (ExternalSsoUrlService)SpringContextUtils.getBean((String)(type + SSO_BEAN_SUB), ExternalSsoUrlService.class);
            }
            catch (Exception e) {
                throw new ELSBootException(I18nUtil.translate((String)"\u5f53\u524d\u914d\u7f6e\u7c7b\u578b{0}\u672a\u914d\u7f6e\u6216\u4e0d\u652f\u6301\u83b7\u53d6SsoUrl", (String)type));
            }
        }
        ExternalVoucher externalVoucher = this.getParamElsAccountVoucherByTypeAndKey(elsAccount, type, vo.getVoucherKey());
        JSONObject object = JSONObject.parseObject((String)CharSequenceUtil.emptyToDefault((CharSequence)externalVoucher.getExtendParam(), (String)"{}"));
        Object urlKey = "";
        if (CharSequenceUtil.isNotEmpty((CharSequence)vo.getVoucherKey())) {
            urlKey = "ssoUrl_" + vo.getVoucherKey();
        }
        if (CharSequenceUtil.isEmpty((CharSequence)(url = object.getString((String)urlKey)))) {
            url = object.getString(SSO_URL);
        }
        return ssoUrlService.processSsoUrl(externalVoucher, url, vo);
    }

    @Override
    public void weDevelopResetAuth(ExternalVoucher wechatMp, JSONObject jsonObject) {
        JSONObject authCorpInfo = jsonObject.getJSONObject("auth_corp_info");
        String clientId = authCorpInfo.getString("corpid");
        String clientSecret = jsonObject.getString("permanent_code");
        log.info("#resetAuth \u4f01\u4e1a\u5fae\u4fe1\u5e94\u7528\u4ee3\u5f00\u53d1\u91cd\u8bbe\u6388\u6743\u79d8\u94a5:{},clientId:{} \u5f00\u59cb", (Object)jsonObject.toJSONString(new JSONWriter.Feature[0]), (Object)clientId);
        LambdaQueryWrapper countWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)countWrapper.eq(ExternalVoucher::getVoucherType, (Object)"wechat_enterprise_develop")).eq(ExternalVoucher::getVoucherKey, (Object)clientId)).isNotNull(ExternalVoucher::getExtendParam)).like(ExternalVoucher::getExtendParam, (Object)"dataConfig");
        ExternalVoucher config = null;
        List list = ((ExternalVoucherMapper)this.baseMapper).selectList((Wrapper)countWrapper);
        if (!list.isEmpty()) {
            config = (ExternalVoucher)((Object)list.get(0));
        }
        if (null == config) {
            String authcorpName = authCorpInfo.getString("corp_name");
            JSONArray jsonArray = jsonObject.getJSONObject("auth_info").getJSONArray("agent");
            JSONObject jsonObject2 = jsonArray.getJSONObject(0);
            String agentId = jsonObject2.getString("agentid");
            config = new ExternalVoucher();
            config.setVoucherType(wechatMp.getVoucherType());
            config.setVoucherKey(clientId);
            config.setElsAccount(clientId);
            config.setVoucherSecret(clientSecret);
            config.setVoucherAgentId(agentId);
            JSONObject param = new JSONObject();
            param.put((Object)"configType", (Object)"dataConfig");
            param.put((Object)"enterpriseName", (Object)authcorpName);
            config.setExtendParam(param.toJSONString(new JSONWriter.Feature[0]));
            ((ExternalVoucherMapper)this.baseMapper).insert((Object)config);
            return;
        }
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(ExternalVoucher::getVoucherSecret, (Object)clientSecret);
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(ExternalVoucher::getVoucherType, (Object)"wechat_enterprise_develop")).eq(ExternalVoucher::getVoucherKey, (Object)clientId)).isNotNull(ExternalVoucher::getExtendParam)).like(ExternalVoucher::getExtendParam, (Object)"dataConfig");
        ((ExternalVoucherMapper)this.baseMapper).update((Object)new ExternalVoucher(), (Wrapper)wrapper);
        log.info("#resetAuth \u4f01\u4e1a\u5fae\u4fe1\u5e94\u7528\u4ee3\u5f00\u53d1\u6388\u6743\u91cd\u8bbe\u6388\u6743\u79d8\u94a5:{},clientId:{} \u5b8c\u6bd5", (Object)jsonObject.toJSONString(new JSONWriter.Feature[0]), (Object)clientId);
    }

    @Override
    public void cancelWeDevelopAuth(String authCorpId, String busAccount, String type) {
        if ("100000".equals(busAccount)) {
            return;
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ExternalVoucher::getVoucherKey, (Object)authCorpId)).isNotNull(ExternalVoucher::getExtendParam)).like(ExternalVoucher::getExtendParam, (Object)"dataConfig")).eq(ExternalVoucher::getVoucherType, (Object)type);
        ((ExternalVoucherMapper)this.baseMapper).delete((Wrapper)wrapper);
    }
}

