/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.attachment.storage.spi;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.attachment.entity.ElsAttachmentPart;
import com.els.modules.attachment.service.impl.ElsAttachmentPartServiceImpl;
import com.els.modules.attachment.storage.StorageFileInfo;
import com.els.modules.attachment.storage.enumerate.FileTypeEnum;
import com.els.modules.attachment.storage.spi.StorageSpi;
import com.els.modules.template.util.ConfigPageGeneJsUtil;
import com.els.modules.template.vo.TemplateHeadVO;
import com.qcloud.cos.utils.IOUtils;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public abstract class AbstractStorageSpi
implements StorageSpi {
    private static final Logger log = LoggerFactory.getLogger(AbstractStorageSpi.class);
    public static final String BEAN_NAME_SUF = "StorageSpi";
    protected static final String NGINX_PATH = "/opt/upFiles/";
    protected static Path rootLocation;
    protected static final String UPLOAD_PATH;
    protected static final String SERVICE_ADDRESS;

    @Override
    public Resource loadAsResource(OutputStream outputStream, String filePath) {
        try {
            URL url;
            UrlResource resource;
            if (filePath.startsWith(File.separator)) {
                filePath = filePath.substring(1);
            }
            if ((resource = new UrlResource(url = new URL(this.getBaseUrl() + filePath))).exists() || resource.isReadable()) {
                return resource;
            }
            return resource;
        }
        catch (Exception e) {
            log.error(":::\u5f53\u524d\u6587\u4ef6\u5b58\u50a8\u7c7b\u578b[{}]\u8bfb\u53d6\u6587\u4ef6{}\u5f02\u5e38:{}", new Object[]{this.type(), filePath, e.getMessage()});
            return null;
        }
    }

    @Override
    public InputStream downloadFileWithInputStream(String filePath) {
        try {
            URL url;
            UrlResource resource;
            if (filePath.startsWith(File.separator)) {
                filePath = filePath.substring(1);
            }
            if ((resource = new UrlResource(url = new URL(this.getBaseUrl() + filePath))).exists() || resource.isReadable()) {
                return resource.getInputStream();
            }
        }
        catch (Exception e) {
            log.error(":::\u5f53\u524d\u6587\u4ef6\u5b58\u50a8\u7c7b\u578b[{}]\u8bfb\u53d6\u6587\u4ef6{}\u5f02\u5e38:{}", new Object[]{this.type(), filePath, e.getMessage()});
        }
        throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_QIzMIH_d9711ec0", (String)"\u6587\u4ef6\u8bfb\u53d6\u5f02\u5e38"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadFileWithOutput(HttpServletResponse response, OutputStream outputStream, String filePath) {
        Resource resource = this.loadAsResource(outputStream, filePath);
        if (null == resource) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_QIxMK_bbc974ee", (String)"\u6587\u4ef6\u4e0d\u5b58\u5728"));
        }
        try {
            InputStream inputStream = resource.getInputStream();
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
            outputStream.write(bytes, 0, bytes.length);
            outputStream.flush();
        }
        catch (Exception e) {
            log.error(":::\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public String contentType(String name) {
        int indexOf = name.lastIndexOf(".");
        if (indexOf > 0) {
            String substring = name.substring(indexOf, name.length() - 1);
            return FileTypeEnum.getValue(substring);
        }
        if (name.contains("BMP") || name.contains("bmp")) {
            return "image/bmp";
        }
        if (name.contains("GIF") || name.contains("gif")) {
            return "image/gif";
        }
        if (name.contains("JPEG") || name.contains("jpeg") || name.contains("JPG") || name.contains("jpg") || name.contains("PNG") || name.contains("png")) {
            return "image/jpeg";
        }
        if (name.contains("HTML") || name.contains("html")) {
            return "text/html";
        }
        if (name.contains("TXT") || name.contains("txt")) {
            return "text/plain";
        }
        if (name.contains("VSD") || name.contains("vsd")) {
            return "application/vnd.visio";
        }
        if (name.contains("PPTX") || name.contains("pptx") || name.contains("PPT") || name.contains("ppt")) {
            return "application/vnd.ms-powerpoint";
        }
        if (name.contains("DOCX") || name.contains("docx") || name.contains("DOC") || name.contains("doc")) {
            return "application/msword";
        }
        if (name.contains("XML") || name.contains("xml")) {
            return "text/xml";
        }
        if (name.contains("js") || name.contains("JS")) {
            return "application/x-javascript";
        }
        return "text/html";
    }

    @Override
    public String loadDownloadSafePath(StorageFileInfo fileInfo) {
        return this.loadDownloadPath(fileInfo.getPath());
    }

    @Override
    public void generatorJs(String savePathDir, TemplateHeadVO headVO) {
        ConfigPageGeneJsUtil.generatorJs(savePathDir, headVO);
    }

    protected String cutFilePath(String filePath) {
        if (filePath.startsWith("/")) {
            return filePath.substring(1);
        }
        return filePath;
    }

    protected void savePartInfo(ElsAttachmentPart part) {
        ((ElsAttachmentPartServiceImpl)SpringContextUtils.getBean(ElsAttachmentPartServiceImpl.class)).save((Object)part);
    }

    protected List<ElsAttachmentPart> getPartList(String uploadId) {
        return ((ElsAttachmentPartServiceImpl)SpringContextUtils.getBean(ElsAttachmentPartServiceImpl.class)).list((Wrapper)new LambdaQueryWrapper().eq(ElsAttachmentPart::getUploadId, (Object)uploadId));
    }

    static {
        UPLOAD_PATH = ((Environment)SpringContextUtils.getBean(Environment.class)).getProperty("els.path.upload");
        SERVICE_ADDRESS = ((Environment)SpringContextUtils.getBean(Environment.class)).getProperty("els.config.service.address");
    }
}

