/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.auth.controller;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.api.vo.Result;
import com.els.common.constant.SrmConstant;
import com.els.common.enumerate.DeployWayEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.util.JwtUtil;
import com.els.common.util.ConfigUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.entity.ExternalAccount;
import com.els.modules.account.service.ExternalAccountService;
import com.els.modules.auth.service.LoginService;
import com.els.modules.auth.vo.QrCodeToUrlVO;
import com.els.modules.auth.vo.SsoModelVO;
import com.els.modules.justauth.entity.DataPagePath;
import com.els.modules.justauth.service.DataPagePathService;
import com.els.modules.justauth.util.ThirdAuthUtil;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.service.ElsSubAccountService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.request.AuthRequest;
import me.zhyd.oauth.utils.AuthStateUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u7b2c\u4e09\u65b9\u767b\u9646\u8ba4\u8bc1", description="\u7b2c\u4e09\u65b9\u767b\u9646\u8ba4\u8bc1")
@RestController
@RequestMapping(value={"/base/thirdLogin"})
public class ThirdLoginController {
    private static final Logger log = LoggerFactory.getLogger(ThirdLoginController.class);
    @Resource
    private ElsSubAccountService accountInfoService;
    @Resource
    private ExternalAccountService externalAccountService;
    @Resource
    private LoginService loginService;
    @Resource
    private RedisUtil redisUtil;
    @Resource
    @Lazy
    private DataPagePathService dataPagePathService;

    @Operation(summary="\u901a\u8fc7\u4e8c\u7ef4\u7801\u83b7\u53d6\u8df3\u8f6cUrl\u8def\u5f84", description="\u901a\u8fc7\u4e8c\u7ef4\u7801\u83b7\u53d6\u8df3\u8f6cUrl\u8def\u5f84")
    @PostMapping(value={"/qrcodeToUrl"})
    public Result<?> qrcodeToUrl(@RequestBody QrCodeToUrlVO qrCodeToUrl) {
        String token = qrCodeToUrl.getToken();
        JSONObject accountObj = JwtUtil.getAccountObj((String)token);
        if (null == accountObj) {
            throw new ELSBootException("\u7528\u6237\u4fe1\u606f\u9519\u8bef");
        }
        String elsAccount = accountObj.getString("elsAccount");
        DataPagePath config = this.dataPagePathService.getByBusinessType(qrCodeToUrl.getBusinessType());
        if (null == config) {
            throw new ELSBootException("\u8bf7\u5148\u914d\u7f6e\u6570\u636e\u9875\u9762\u8df3\u8f6c\u8def\u5f84");
        }
        String routeUrl = elsAccount.equals(qrCodeToUrl.getBusAccount()) ? config.getPurchaseRoutePath() + "?id=" + qrCodeToUrl.getPurchaseId() : config.getSaleRoutePath() + "?id=" + qrCodeToUrl.getSaleId();
        return Result.ok((String)routeUrl);
    }

    @Operation(summary="\u7b2c\u4e09\u65b9\u767b\u9646\u8ba4\u8bc1-\u4e8c\u7ef4\u7801\u6e32\u67d3", description="\u7b2c\u4e09\u65b9\u767b\u9646\u8ba4\u8bc1-\u4e8c\u7ef4\u7801\u6e32\u67d3")
    @GetMapping(value={"/loadQrCode/{source}"})
    public void loadQrCode(@PathVariable(value="source") String source, @RequestParam(name="account", required=false, defaultValue="") String account, HttpServletResponse response) throws IOException {
        if (CharSequenceUtil.isEmpty((CharSequence)account)) {
            account = DeployWayEnum.CLOUD.getValue().equals(ConfigUtil.getDeployWay()) ? "100000" : ConfigUtil.getPurchaseAccount();
        }
        AuthRequest authRequest = ThirdAuthUtil.getAuthRequest(account, source.toUpperCase(), "pc", false);
        String state = AuthStateUtils.createState();
        String authorizeUrl = authRequest.authorize(state);
        log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u8ba4\u8bc1\u5730\u5740\uff1a" + authorizeUrl);
        response.sendRedirect(authorizeUrl);
    }

    @Operation(summary="\u7b2c\u4e09\u65b9\u767b\u9646\u8ba4\u8bc1-\u6388\u6743\u767b\u5f55", description="\u7b2c\u4e09\u65b9\u767b\u9646\u8ba4\u8bc1-\u6388\u6743\u767b\u5f55")
    @GetMapping(value={"/loadQrCode/{elsAccount}/{type}/{source}"})
    public void loadQrCodeAccount(@PathVariable(value="elsAccount") String elsAccount, @PathVariable(value="type") String type, @PathVariable(value="source") String source, @RequestParam(name="routeUri", required=false) String routeUri, HttpServletResponse response) throws IOException {
        AuthRequest authRequest = ThirdAuthUtil.getAuthRequest(elsAccount, source.toUpperCase(), type, true);
        String state = AuthStateUtils.createState();
        String authorizeUrl = authRequest.authorize(state);
        JSONObject object = new JSONObject();
        if (StrUtil.isNotBlank((CharSequence)routeUri)) {
            object.put("routeUri", (Object)routeUri);
            this.redisUtil.set("srm:base:third:login:account_state:" + state, (Object)object, 300L);
        }
        this.redisUtil.set("srm:base:third:login:account:" + state, (Object)elsAccount, 300L);
        log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u8ba4\u8bc1\u5730\u5740\uff1a" + authorizeUrl);
        response.sendRedirect(authorizeUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="\u7b2c\u4e09\u65b9\u767b\u9646\u8ba4\u8bc1-\u56de\u8c03", description="\u7b2c\u4e09\u65b9\u767b\u9646\u8ba4\u8bc1-\u56de\u8c03")
    @GetMapping(value={"/{source}/callback"})
    public Result<?> thirdLoginCallback(@PathVariable(value="source") String source, AuthCallback callback) {
        AuthRequest authRequest;
        AuthResponse response;
        boolean success;
        long beginTime = System.currentTimeMillis();
        String elsAccount = ConfigUtil.getPurchaseAccount();
        boolean flag = false;
        String account = (String)this.redisUtil.get("srm:base:third:login:account:" + callback.getState());
        if (CharSequenceUtil.isNotEmpty((CharSequence)account)) {
            elsAccount = account;
            flag = true;
        }
        boolean bl = success = (response = (authRequest = ThirdAuthUtil.getAuthRequest(elsAccount, source.toUpperCase(), "pc", flag)).login(callback)).getCode() == 2000;
        if (success) {
            JSONObject data = JSONObject.parseObject((String)JSONObject.toJSONString((Object)response.getData()));
            log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u8fdb\u5165callback\u6388\u6743\u6210\u529f,data:{}", (Object)data.toJSONString());
            String username = data.getString("username");
            String uuid = data.getString("uuid");
            if (CharSequenceUtil.isEmpty((CharSequence)username) && source.toUpperCase().contains("wechat_enterprise_develop")) {
                JSONObject rawUserInfo = data.getJSONObject("rawUserInfo");
                JSONObject userInfo = rawUserInfo.getJSONObject("user_info");
                uuid = userInfo.getString("open_userid");
            }
            String accountType = ThirdAuthUtil.getAuthConfigType(source.toUpperCase());
            ExternalAccount externalAccount = new ExternalAccount();
            externalAccount.setExternalAccountId(uuid);
            externalAccount.setAccountType(accountType);
            externalAccount.setEnabled(SrmConstant.YES_1);
            externalAccount.setBusAccount(elsAccount);
            ExternalAccount dbExternalAccount = this.getExternalAccount(elsAccount, accountType, uuid);
            if (dbExternalAccount == null) {
                log.info(":::\u7b2c\u4e09\u65b9\u767b\u5f55\u8fdb\u5165callback\u6388\u6743\u6210\u529f\uff0c\u65b0\u4fdd\u5b58\u7b2c\u4e09\u65b9\u7528\u6237.");
                externalAccount.setId(IdWorker.getIdStr());
                this.externalAccountService.checkAndSave(externalAccount);
                JSONObject obj = new JSONObject();
                obj.put("thirdUserUuid", (Object)externalAccount.getId());
                return Result.ok((String)"\u64cd\u4f5c\u6210\u529f\u4f46\u6ca1\u6709\u7ed1\u5b9a\u8d26\u53f7\uff01", (Object)obj);
            }
            log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u8fdb\u5165callback\u6388\u6743\u6210\u529f\uff0c\u51c6\u5907\u751f\u6210token");
            String accountId = dbExternalAccount.getAccountId();
            ElsSubAccount accountInfo = (ElsSubAccount)((Object)this.accountInfoService.getById((Serializable)((Object)accountId)));
            if (null == accountInfo) {
                throw new ELSBootException(I18nUtil.translate((String)"\u7528\u6237\u4e0d\u5b58\u5728"));
            }
            if (accountInfo.getStatus() == null || accountInfo.getStatus() != 1) {
                throw new ELSBootException(I18nUtil.translate((String)"\u8be5\u7528\u6237\u5df2\u51bb\u7ed3\uff01"));
            }
            JSONObject busObj = (JSONObject)this.redisUtil.get("srm:base:third:login:account_state:" + callback.getState());
            try {
                TenantContext.setTenant((String)accountInfo.getElsAccount());
                JSONObject loginResult = this.loginService.buildLoginResult(beginTime, accountInfo);
                if (loginResult != null) {
                    loginResult.put("busObj", (Object)busObj);
                }
                log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u8fdb\u5165callback\u6388\u6743\u6210\u529f\uff0c\u8fd4\u56de\u7ed3\u679c");
                Result result = Result.ok((Object)loginResult);
                return result;
            }
            finally {
                TenantContext.clear();
            }
        }
        log.error(":::\u7b2c\u4e09\u65b9\u6388\u6743\u5f02\u5e38\u4fe1\u606f :{},code:{},{}", new Object[]{JSONObject.toJSONString((Object)response), response.getCode(), success});
        return Result.error((String)("\u7b2c\u4e09\u65b9\u767b\u5f55\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458:" + response.getMsg()));
    }

    private ExternalAccount getExternalAccount(String busAccount, String accountType, String uuid) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(ExternalAccount::getExternalAccountId, (Object)uuid);
        query.eq(ExternalAccount::getAccountType, (Object)accountType);
        query.eq(ExternalAccount::getBusAccount, (Object)busAccount);
        query.orderByDesc(BaseEntity::getUpdateTime);
        List list = this.externalAccountService.list((Wrapper)query).stream().filter(o -> CharSequenceUtil.isNotBlank((CharSequence)o.getAccountId())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(list)) {
            ExternalAccount account = (ExternalAccount)((Object)list.get(0));
            if (SrmConstant.NO_0.equals(account.getEnabled())) {
                throw new ELSBootException(I18nUtil.translate((String)"\u8be5\u7528\u6237\u5df2\u51bb\u7ed3\uff01"));
            }
            return account;
        }
        return null;
    }

    @Operation(summary="\u7b2c\u4e09\u65b9\u767b\u5f55", description="\u83b7\u53d6ssoToken")
    @PostMapping(value={"/ssoToken"})
    public Result<?> ssoToken(@RequestBody SsoModelVO ssoModel) {
        return Result.ok();
    }
}

