/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.compare.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.compare.entity.ElsFileCompareHead;
import com.els.modules.compare.entity.ElsFileCompareResult;
import com.els.modules.compare.service.ElsFileCompareHeadService;
import com.els.modules.compare.service.ElsFileCompareResultService;
import com.els.modules.compare.vo.ElsFileCompareHeadVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/compare/elsFileCompareHead"})
@Tag(name="\u6587\u4ef6\u5bf9\u6bd4")
public class ElsFileCompareHeadController
extends BaseController<ElsFileCompareHead, ElsFileCompareHeadService> {
    private static final Logger log = LoggerFactory.getLogger(ElsFileCompareHeadController.class);
    @Autowired
    private ElsFileCompareHeadService elsFileCompareHeadService;
    @Autowired
    private ElsFileCompareResultService elsFileCompareResultService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"compare#elsFileCompareHead:list"})
    public Result<?> queryPageList(ElsFileCompareHead elsFileCompareHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsFileCompareHead), (Map)req.getParameterMap());
        queryWrapper.lambda().eq(ParentEntity::getElsAccount, (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsFileCompareHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u6587\u4ef6\u5bf9\u6bd4", value="\u6dfb\u52a0")
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"compare#elsFileCompareHead:add"})
    public Result<?> add(@RequestBody ElsFileCompareHeadVO elsFileCompareHeadPage) {
        ElsFileCompareHead elsFileCompareHead = new ElsFileCompareHead();
        BeanUtils.copyProperties((Object)((Object)elsFileCompareHeadPage), (Object)((Object)elsFileCompareHead));
        this.elsFileCompareHeadService.saveMain(elsFileCompareHead, elsFileCompareHeadPage.getElsFileCompareResultList());
        return Result.ok((Object)((Object)elsFileCompareHead));
    }

    @AutoLog(busModule="\u6587\u4ef6\u5bf9\u6bd4", value="\u7f16\u8f91")
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"compare#elsFileCompareHead:edit"})
    public Result<?> edit(@RequestBody ElsFileCompareHeadVO elsFileCompareHeadPage) {
        ElsFileCompareHead elsFileCompareHead = new ElsFileCompareHead();
        BeanUtils.copyProperties((Object)((Object)elsFileCompareHeadPage), (Object)((Object)elsFileCompareHead));
        this.elsFileCompareHeadService.updateMain(elsFileCompareHead, elsFileCompareHeadPage.getElsFileCompareResultList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u6587\u4ef6\u5bf9\u6bd4", value="\u7f16\u8f91")
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/fileCompare"})
    @RequiresPermissions(value={"compare#elsFileCompareHead:edit"})
    public Result<?> fileCompare(@RequestBody ElsFileCompareHeadVO elsFileCompareHeadPage) {
        return this.elsFileCompareHeadService.fileCompare(elsFileCompareHeadPage);
    }

    @AutoLog(busModule="\u6587\u4ef6\u5bf9\u6bd4", value="\u901a\u8fc7id\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"compare#elsFileCompareHead:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.elsFileCompareHeadService.deleteMain(id);
        return this.commonSuccessResult(4);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"compare#elsFileCompareHead:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        ElsFileCompareHead elsFileCompareHead = (ElsFileCompareHead)((Object)this.elsFileCompareHeadService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        ElsFileCompareHeadVO elsFileCompareHeadVO = new ElsFileCompareHeadVO();
        BeanUtils.copyProperties((Object)((Object)elsFileCompareHead), (Object)((Object)elsFileCompareHeadVO));
        List<ElsFileCompareResult> elsFileCompareResultList = this.elsFileCompareResultService.selectByMainId(id);
        elsFileCompareHeadVO.setElsFileCompareResultList(elsFileCompareResultList);
        return Result.ok((Object)((Object)elsFileCompareHeadVO));
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2\u6700\u65b0\u7ed3\u679c", description="\u901a\u8fc7id\u67e5\u8be2\u6700\u65b0\u7ed3\u679c")
    @GetMapping(value={"/getResultById"})
    @RequiresPermissions(value={"compare#elsFileCompareHead:view"})
    public Result<?> getResultById(@RequestParam(name="id") String id) {
        QueryWrapper objectQueryWrapper = new QueryWrapper();
        objectQueryWrapper.lambda().eq(ElsFileCompareHead::getFileASourceId, (Object)id);
        objectQueryWrapper.lambda().orderByDesc(BaseEntity::getCreateTime);
        List list = this.elsFileCompareHeadService.list((Wrapper)objectQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new ELSBootException("\u6682\u65e0\u5bf9\u6bd4\u7ed3\u679c");
        }
        ElsFileCompareHeadVO elsFileCompareHeadVO = new ElsFileCompareHeadVO();
        BeanUtils.copyProperties(list.get(0), (Object)((Object)elsFileCompareHeadVO));
        List<ElsFileCompareResult> elsFileCompareResultList = this.elsFileCompareResultService.selectByMainId(elsFileCompareHeadVO.getId());
        elsFileCompareHeadVO.setElsFileCompareResultList(elsFileCompareResultList);
        return Result.ok((Object)((Object)elsFileCompareHeadVO));
    }

    @Operation(summary="\u901a\u8fc7\u6587\u4ef6\u5bf9\u6bd4id\u67e5\u8be2\u6587\u4ef6\u5bf9\u6bd4\u7ed3\u679c", description="\u901a\u8fc7\u6587\u4ef6\u5bf9\u6bd4id\u67e5\u8be2\u6587\u4ef6\u5bf9\u6bd4\u7ed3\u679c")
    @GetMapping(value={"/queryElsFileCompareResultByMainId"})
    @RequiresPermissions(value={"compare#elsFileCompareHead:list"})
    public Result<?> queryElsFileCompareResultListByMainId(@RequestParam(name="id") String id) {
        List<ElsFileCompareResult> elsFileCompareResultList = this.elsFileCompareResultService.selectByMainId(id);
        return Result.ok(elsFileCompareResultList);
    }
}

