/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.email.core;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.SystemPropsUtil;
import cn.hutool.setting.GroupedMap;
import cn.hutool.setting.Setting;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrmEmailSetting
extends Setting {
    private static final Logger log = LoggerFactory.getLogger(SrmEmailSetting.class);
    private static final long serialVersionUID = 1L;
    private final GroupedMap srmGroupedMap;
    private static final char ASSIGN_FLAG = '=';
    private static final String VAR_REGEX = "\\$\\{(.*?)\\}";

    public SrmEmailSetting(String configString) {
        configString = CharSequenceUtil.emptyToDefault((CharSequence)configString, (String)"");
        this.srmGroupedMap = SrmEmailSetting.loadGroupedMap(configString, false);
    }

    public SrmEmailSetting(String configString, boolean isUseVariable) {
        configString = CharSequenceUtil.emptyToDefault((CharSequence)configString, (String)"");
        this.srmGroupedMap = SrmEmailSetting.loadGroupedMap(configString, isUseVariable);
    }

    public static GroupedMap loadGroupedMap(String emailStringConfig, boolean isUseVariable) {
        GroupedMap groupedMap = new GroupedMap();
        try {
            String[] lines;
            String group = null;
            for (String line : lines = emailStringConfig.replace("\r", "").split("\n")) {
                if (CharSequenceUtil.isEmpty((CharSequence)line) || StrUtil.isBlank((CharSequence)(line = StrUtil.trim((CharSequence)line))) || StrUtil.startWith((CharSequence)line, (char)'#')) continue;
                if (StrUtil.isSurround((CharSequence)line, (char)'[', (char)']')) {
                    group = StrUtil.trim((CharSequence)line.substring(1, line.length() - 1));
                    continue;
                }
                String[] keyValue = StrUtil.splitToArray((CharSequence)line, (char)'=', (int)2);
                if (keyValue.length < 2) continue;
                String value = StrUtil.trim((CharSequence)keyValue[1]);
                if (isUseVariable) {
                    value = SrmEmailSetting.replaceVar(group, value, groupedMap);
                }
                groupedMap.put(group, StrUtil.trim((CharSequence)keyValue[0]), value);
            }
            return groupedMap;
        }
        catch (Exception e) {
            log.error("\u90ae\u7bb1\u914d\u7f6e\u9519\u8bef:{}", (Object)e.getMessage());
            throw e;
        }
    }

    private static String replaceVar(String group, String value, GroupedMap groupedMap) {
        Set vars = (Set)ReUtil.findAll((String)VAR_REGEX, (CharSequence)value, (int)0, new HashSet());
        for (String var : vars) {
            List groupAndKey;
            String key = ReUtil.get((String)VAR_REGEX, (CharSequence)var, (int)1);
            if (!StrUtil.isNotBlank((CharSequence)key)) continue;
            String varValue = groupedMap.get(group, key);
            if (null == varValue && (groupAndKey = StrUtil.split((CharSequence)key, (char)'.', (int)2)).size() > 1) {
                varValue = groupedMap.get((String)groupAndKey.get(0), (String)groupAndKey.get(1));
            }
            if (null == varValue) {
                varValue = SystemPropsUtil.get((String)key);
            }
            if (null == varValue) continue;
            value = value.replace(var, varValue);
        }
        return value;
    }

    public GroupedMap getSrmGroupedMap() {
        return this.srmGroupedMap;
    }
}

