/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.fanruan.controller;

import com.alibaba.fastjson.JSONObject;
import com.els.common.api.vo.Result;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.fanruan.entity.FanRuanEntity;
import com.els.modules.fanruan.util.RsaEncryptFanRuan;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u83b7\u53d6\u5e06\u8f6ftoken")
@RestController
@RequestMapping(value={"/account/fanruan"})
public class FanRuanController {
    private static final Logger log = LoggerFactory.getLogger(FanRuanController.class);
    @Resource
    private FanRuanEntity fanRuanEntity;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @RequestMapping(value={"/getToken"}, method={RequestMethod.GET})
    public Result<?> queryPageList() throws UnsupportedEncodingException {
        String publicKey = this.fanRuanEntity.getPublicKey();
        log.error("\u83b7\u53d6\u914d\u7f6e" + JSONObject.toJSONString((Object)this.fanRuanEntity));
        String encrypt = RsaEncryptFanRuan.encrypt(this.fanRuanEntity.getName(), publicKey);
        System.out.println("encrypted username: " + encrypt);
        String encode = URLEncoder.encode(encrypt, "UTF-8");
        Result result = new Result();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("ssoToken", (Object)encode);
        log.error("\u83b7\u53d6\u914d\u7f6essoToken" + encode);
        List srmReportDataMenu = this.invokeBaseRpcService.queryDictItemsByCode("srmFanRuanReportId", TenantContext.getTenant());
        if (srmReportDataMenu != null && srmReportDataMenu.size() > 0) {
            jsonObject.put("reportKey", (Object)((DictDTO)srmReportDataMenu.get(0)).getValue());
        }
        result.setResult((Object)jsonObject);
        return result;
    }
}

