/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.controller;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.finance.entity.ElsFinanceReconciliationConfig;
import com.els.modules.finance.enumerate.ConfigStatusEnum;
import com.els.modules.finance.service.ElsFinanceReconciliationConfigService;
import com.els.modules.template.entity.TemplateHead;
import com.els.modules.template.enumerate.TemplateStatusEnum;
import com.els.modules.template.service.TemplateHeadService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u5bf9\u8d26\u5355\u7b56\u7565\u914d\u7f6e")
@RestController
@RequestMapping(value={"/base/elsFinanceReconciliationConfig"})
public class ElsFinanceReconciliationConfigController
extends BaseController<ElsFinanceReconciliationConfig, ElsFinanceReconciliationConfigService> {
    private static final Logger log = LoggerFactory.getLogger(ElsFinanceReconciliationConfigController.class);
    @Autowired
    private ElsFinanceReconciliationConfigService elsFinanceReconciliationConfigService;
    @Autowired
    private TemplateHeadService templateHeadService;

    @Operation(summary="\u5165\u5e93\u5bf9\u8d26-\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/reconciliationList"})
    public Result<?> queryReconciliationPageList(ElsFinanceReconciliationConfig elsFinanceReconciliationConfig, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsFinanceReconciliationConfig), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.lambda().eq(ParentEntity::getElsAccount, (Object)TenantContext.getTenant());
        queryWrapper.lambda().eq(ElsFinanceReconciliationConfig::getBusinessType, (Object)"reconciliation");
        queryWrapper.lambda().eq(BaseEntity::getDeleted, (Object)"0");
        IPage pageList = this.elsFinanceReconciliationConfigService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @Operation(summary="\u5c65\u7ea6\u5bf9\u8d26-\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/performanceList"})
    public Result<?> queryPerformancePageList(ElsFinanceReconciliationConfig elsFinanceReconciliationConfig, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsFinanceReconciliationConfig), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.lambda().eq(ParentEntity::getElsAccount, (Object)TenantContext.getTenant());
        queryWrapper.lambda().eq(ElsFinanceReconciliationConfig::getBusinessType, (Object)"performanceReconciliation");
        queryWrapper.lambda().eq(BaseEntity::getDeleted, (Object)"0");
        IPage pageList = this.elsFinanceReconciliationConfigService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u8d22\u52a1\u786e\u8ba4\u51fd\u914d\u7f6e-\u9009\u62e9100000\u6570\u636e\u6dfb\u52a0\u81f3\u4f01\u4e1a\u7ea7", logType=2, operateType=2)
    @Operation(summary="\u9009\u62e9100000\u6570\u636e\u6dfb\u52a0\u81f3\u4f01\u4e1a\u7ea7", description="\u9009\u62e9100000\u6570\u636e\u6dfb\u52a0\u81f3\u4f01\u4e1a\u7ea7")
    @GetMapping(value={"/reconciliationAddBy100000"})
    public Result<?> reconciliationAddBy100000(@RequestParam(name="id", required=true) String id) {
        this.elsFinanceReconciliationConfigService.addBy100000(id, "reconciliation");
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u8d22\u52a1\u786e\u8ba4\u51fd\u914d\u7f6e-\u9009\u62e9100000\u6570\u636e\u6dfb\u52a0\u81f3\u4f01\u4e1a\u7ea7", logType=2, operateType=2)
    @Operation(summary="\u9009\u62e9100000\u6570\u636e\u6dfb\u52a0\u81f3\u4f01\u4e1a\u7ea7", description="\u9009\u62e9100000\u6570\u636e\u6dfb\u52a0\u81f3\u4f01\u4e1a\u7ea7")
    @GetMapping(value={"/performanceAddBy100000"})
    public Result<?> performanceAddBy100000(@RequestParam(name="id", required=true) String id) {
        this.elsFinanceReconciliationConfigService.addBy100000(id, "performanceReconciliation");
        return this.commonSuccessResult(3);
    }

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/sysReconciliationlist"})
    public Result<?> queryPageReconciliationSysList(ElsFinanceReconciliationConfig elsFinanceReconciliationConfig, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsFinanceReconciliationConfig), (Map)req.getParameterMap());
        queryWrapper.lambda().eq(ParentEntity::getElsAccount, (Object)"100000");
        queryWrapper.lambda().eq(ElsFinanceReconciliationConfig::getBusinessType, (Object)"reconciliation");
        queryWrapper.lambda().eq(BaseEntity::getDeleted, (Object)"0");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsFinanceReconciliationConfigService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/sysPerformancelist"})
    public Result<?> queryPageSysList(ElsFinanceReconciliationConfig elsFinanceReconciliationConfig, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsFinanceReconciliationConfig), (Map)req.getParameterMap());
        queryWrapper.lambda().eq(ParentEntity::getElsAccount, (Object)"100000");
        queryWrapper.lambda().eq(ElsFinanceReconciliationConfig::getBusinessType, (Object)"performanceReconciliation");
        queryWrapper.lambda().eq(BaseEntity::getDeleted, (Object)"0");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsFinanceReconciliationConfigService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u5bf9\u8d26\u5355\u7b56\u7565\u914d\u7f6e-\u6dfb\u52a0")
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody ElsFinanceReconciliationConfig elsFinanceReconciliationConfig) {
        log.info("elsFinanceReconciliationConfig: add " + JSON.toJSONString((Object)((Object)elsFinanceReconciliationConfig)));
        this.elsFinanceReconciliationConfigService.add(elsFinanceReconciliationConfig);
        return Result.ok((Object)((Object)elsFinanceReconciliationConfig));
    }

    @AutoLog(value="\u5bf9\u8d26\u5355\u7b56\u7565\u914d\u7f6e-\u7f16\u8f91")
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody ElsFinanceReconciliationConfig elsFinanceReconciliationConfig) {
        log.info("elsFinanceReconciliationConfig: edit" + JSON.toJSONString((Object)((Object)elsFinanceReconciliationConfig)));
        this.elsFinanceReconciliationConfigService.edit(elsFinanceReconciliationConfig);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u5bf9\u8d26\u5355\u7b56\u7565\u914d\u7f6e-\u901a\u8fc7id\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.elsFinanceReconciliationConfigService.delete(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u5bf9\u8d26\u5355\u7b56\u7565\u914d\u7f6e-\u6279\u91cf\u5220\u9664")
    @Operation(summary="\u6279\u91cf\u5220\u9664", description="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.elsFinanceReconciliationConfigService.deleteBatch(idList);
        return this.commonSuccessResult(4);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        ElsFinanceReconciliationConfig elsFinanceReconciliationConfig = (ElsFinanceReconciliationConfig)((Object)this.elsFinanceReconciliationConfigService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        return Result.ok((Object)((Object)elsFinanceReconciliationConfig));
    }

    @Operation(summary="\u901a\u8fc7id\u4f5c\u5e9f", description="\u901a\u8fc7id\u4f5c\u5e9f")
    @GetMapping(value={"/invalidById"})
    public Result<?> invalidById(@RequestParam(name="id") String id) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(ElsFinanceReconciliationConfig::getStatus, (Object)ConfigStatusEnum.CANCELL.getValue());
        updateWrapper.eq(ParentEntity::getId, (Object)id);
        return Result.ok((Object)this.elsFinanceReconciliationConfigService.update((Wrapper)updateWrapper));
    }

    @Operation(summary="\u6839\u636e\u4e1a\u52a1\u7c7b\u578b\u83b7\u53d6\u6a21\u677f\u5217\u8868", description="\u6839\u636e\u4e1a\u52a1\u7c7b\u578b\u83b7\u53d6\u6a21\u677f\u5217\u8868")
    @GetMapping(value={"/getListByType"})
    public Result<?> queryList(TemplateHead templateHead, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)templateHead), (Map)req.getParameterMap());
        String elsAccount = StrUtil.isNotBlank((CharSequence)templateHead.getElsAccount()) ? templateHead.getElsAccount() : TenantContext.getTenant();
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.eq((Object)"template_status", (Object)TemplateStatusEnum.GENERATED.getValue());
        List list = this.templateHeadService.list((Wrapper)queryWrapper);
        if (list.isEmpty()) {
            queryWrapper.clear();
            queryWrapper.eq((Object)"els_account", (Object)"100000");
            queryWrapper.eq((Object)"template_status", (Object)TemplateStatusEnum.GENERATED.getValue());
            list = this.templateHeadService.list((Wrapper)queryWrapper);
        }
        return Result.ok((Object)list);
    }
}

