/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.core.server.handler.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.els.modules.im.core.ImSender;
import com.els.modules.im.core.message.BusinessHelper;
import com.els.modules.im.core.packets.WsMessageDataPackets;
import com.els.modules.im.core.packets.WsMessagePackets;
import com.els.modules.im.core.packets.WsMsgTypePackets;
import com.els.modules.im.core.packets.WsResultPackets;
import com.els.modules.im.core.server.handler.AbstractConnHandler;
import com.els.modules.im.core.server.handler.Opt;
import com.google.common.collect.Lists;
import jakarta.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.core.intf.Packet;
import org.tio.utils.lock.SetWithLock;
import org.tio.websocket.common.WsRequest;
import org.tio.websocket.common.WsResponse;

@Service
public class FriendChatHandler
extends AbstractConnHandler {
    private static final Logger log = LoggerFactory.getLogger(FriendChatHandler.class);
    @Resource(name="srmBusinessHelper")
    private BusinessHelper srmBusinessHelper;

    @Override
    public Opt opt() {
        return Opt.FRIEND_MSG_MESSAGE;
    }

    @Override
    public Object reCallOnText(WsRequest wsRequest, String text, ChannelContext channelContext) {
        return null;
    }

    @Override
    protected Object doHandler(WsResultPackets wsResult, WsRequest wsRequest, WsMessagePackets wsMessage, ChannelContext channelContext) {
        wsMessage.getMessage().setMessageChatType("friend");
        if ("chat".equals(wsMessage.getConnOpt())) {
            WsMessageDataPackets message = wsMessage.getMessage();
            message.setId(null);
            wsResult.setMsgType(WsMsgTypePackets.FRIEND_MESSAGE.getMsgType());
            if (this.srmBusinessHelper.isOnline(message.getMessageToId())) {
                message = this.storeMessage(message, "1", "friend");
                ImSender.sendToUser(message.getMessageToId(), channelContext.getTioConfig(), this.buildImPacket(wsResult, message));
            } else {
                message = this.storeMessage(message, "0", "friend");
                this.srmBusinessHelper.sendOutLineMessage(message.getMessageToId(), "imChatFriend", "", message, Lists.newArrayList((Object[])new String[]{message.getMessageToId()}));
            }
            String addMessageId = message.getId();
            if (CharSequenceUtil.isNotEmpty((CharSequence)addMessageId)) {
                WsResultPackets wsResultMap = new WsResultPackets();
                wsResultMap.setMsgType(WsMsgTypePackets.SEND_MESSAGE_ID_RETURN.getMsgType());
                WsMessageDataPackets resultMessage = new WsMessageDataPackets();
                resultMessage.setUnSaveMessageId(message.getUnSaveMessageId());
                resultMessage.setUndoMessageId(addMessageId);
                wsResultMap.setData(resultMessage);
                SetWithLock mimeChannelContextSetWithLock = Tio.getByUserid((TioConfig)channelContext.getTioConfig(), (String)channelContext.userid);
                if (mimeChannelContextSetWithLock != null && mimeChannelContextSetWithLock.size() != 0) {
                    WsResponse wsResponse = WsResponse.fromText((String)wsResultMap.toJsonString(), (String)"utf-8");
                    Tio.sendToUser((TioConfig)channelContext.getTioConfig(), (String)channelContext.userid, (Packet)wsResponse);
                }
            }
        }
        return null;
    }
}

