/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.justauth.util;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.els.common.exception.ELSBootException;
import com.els.common.util.ClassReflectUtil;
import com.els.common.util.ConfigUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.account.entity.ExternalVoucher;
import com.els.modules.account.service.ExternalVoucherService;
import com.els.modules.integration.api.dto.ExternalVoucherDto;
import com.els.modules.justauth.constant.ThirdTokenEnums;
import com.els.modules.justauth.enums.QRCodeConstant;
import com.els.modules.justauth.extend.ConfigExtendInter;
import com.els.modules.justauth.state.RedisStateCache;
import com.els.modules.justauth.vo.ConfigExtendVO;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import me.zhyd.oauth.AuthRequestBuilder;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.request.AuthRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThirdAuthUtil {
    private static final Logger log = LoggerFactory.getLogger(ThirdAuthUtil.class);
    private static final String THIRD_TOKEN_KEY = "srm:base:third:token";
    private static final String LOCAL_REDIRECT_URI = "localRedirectUri";
    private static final RedisUtil REDIS_UTIL = (RedisUtil)SpringContextUtils.getBean(RedisUtil.class);

    public static AuthRequest getAuthRequest(String elsAccount, String source, String type, Boolean flag) {
        JSONObject extendParamObj;
        ExternalVoucher config = ((ExternalVoucherService)SpringContextUtils.getBean(ExternalVoucherService.class)).getOneBindLoginDataConfig(elsAccount, ThirdAuthUtil.getAuthConfigType(source));
        if (config == null) {
            throw new ELSBootException(I18nUtil.translate((String)"\u7b2c\u4e09\u65b9\u51ed\u8bc1\u4e0d\u5b58\u5728!"));
        }
        String uri = "/user/qcLogin";
        if ("mobile".equals(type)) {
            uri = "/mobile";
        }
        String oldSource = source;
        if (flag.booleanValue()) {
            source = ThirdAuthUtil.getAuthType(source);
        }
        String redirectUri = (extendParamObj = JSON.parseObject((String)CharSequenceUtil.emptyToDefault((CharSequence)config.getExtendParam(), (String)"{}"))).containsKey(LOCAL_REDIRECT_URI) ? extendParamObj.getString(LOCAL_REDIRECT_URI) + uri + "?type%3D" + source.toLowerCase() : ConfigUtil.getServiceAddress() + uri + "?type%3D" + source.toLowerCase();
        AuthConfig build = AuthConfig.builder().clientId(config.getVoucherKey()).clientSecret(config.getVoucherSecret()).agentId(config.getVoucherAgentId()).redirectUri(redirectUri).build();
        source = ThirdAuthUtil.rebuildSource(source);
        List<ConfigExtendVO> extendParamList = ((ConfigExtendInter)SpringContextUtils.getBean(ConfigExtendInter.class)).buildExtendParam(oldSource.toUpperCase(), "");
        if (extendParamObj.size() > 0 && extendParamList.size() > 0) {
            for (ConfigExtendVO c : extendParamList) {
                String paramName;
                Field field;
                if (!c.getAuthRequired().booleanValue() || null == (field = ClassReflectUtil.getField(AuthConfig.class, (String)(paramName = c.getParamName()))) || !extendParamObj.containsKey(paramName)) continue;
                field.setAccessible(true);
                try {
                    field.set(build, CharSequenceUtil.emptyToDefault((CharSequence)c.getDefaultValue(), (String)extendParamObj.getString(paramName)));
                }
                catch (Exception e) {
                    throw new ELSBootException(oldSource + "\u8bbe\u7f6e\u6388\u6743\u8bf7\u6c42\u53c2\u6570\u5931\u8d25:{}", new String[]{e.getMessage()});
                }
            }
        }
        AuthRequestBuilder authRequestBuilder = AuthRequestBuilder.builder().source(source.toLowerCase()).authConfig(build).authStateCache((AuthStateCache)SpringContextUtils.getBean(RedisStateCache.class));
        return authRequestBuilder.build();
    }

    public static String getUrlParamByJson(JSONObject json) {
        StringBuilder result = new StringBuilder();
        if (json == null) {
            return result.toString();
        }
        for (Map.Entry entry : json.entrySet()) {
            if (result.length() == 0) {
                result.append((String)entry.getKey()).append("=").append(entry.getValue());
                continue;
            }
            result.append("&").append((String)entry.getKey()).append("=").append(entry.getValue());
        }
        return result.toString();
    }

    public static String getWechatMpToken(String busAccount, ExternalVoucherDto config) {
        String key = "srm:base:third:token:" + ThirdTokenEnums.WECHAT_MP.getType() + ":" + busAccount;
        String token = (String)REDIS_UTIL.get(key);
        if (StrUtil.isNotBlank((CharSequence)token)) {
            return token;
        }
        try {
            JSONObject object = new JSONObject();
            object.put((Object)"appid", (Object)config.getVoucherKey());
            object.put((Object)"secret", (Object)config.getVoucherSecret());
            String invokeUrl = ThirdTokenEnums.WECHAT_MP.getTokenUrl() + "&" + ThirdAuthUtil.getUrlParamByJson(object);
            String result = HttpUtil.get((String)invokeUrl);
            JSONObject resultObj = JSONObject.parseObject((String)result);
            if (!resultObj.containsKey("access_token")) {
                throw new ELSBootException(I18nUtil.translate((String)resultObj.getString("errmsg")));
            }
            token = resultObj.getString("access_token");
            int expiresIn = resultObj.getIntValue("expires_in");
            REDIS_UTIL.set(key, (Object)token, (long)expiresIn - 5L);
            return token;
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage());
        }
    }

    public static String getWechatEnterpriseToken(String busAccount, ExternalVoucherDto config) {
        String key = "srm:base:third:token:" + ThirdTokenEnums.WECHAT_ENTERPRISE.getType() + ":" + busAccount;
        String token = (String)REDIS_UTIL.get(key);
        if (StrUtil.isNotBlank((CharSequence)token)) {
            return token;
        }
        JSONObject object = new JSONObject();
        object.put((Object)"corpid", (Object)config.getVoucherKey());
        object.put((Object)"corpsecret", (Object)config.getVoucherSecret());
        String invokeUrl = ThirdTokenEnums.WECHAT_ENTERPRISE.getTokenUrl() + "?" + ThirdAuthUtil.getUrlParamByJson(object);
        String result = HttpUtil.get((String)invokeUrl);
        JSONObject resultObj = JSONObject.parseObject((String)result);
        if (!resultObj.containsKey("access_token")) {
            throw new ELSBootException(I18nUtil.translate((String)resultObj.getString("errmsg")));
        }
        token = resultObj.getString("access_token");
        int expiresIn = resultObj.getIntValue("expires_in");
        REDIS_UTIL.set(key, (Object)token, (long)(expiresIn - 5));
        return token;
    }

    public static String getDingTalkToken(String busAccount, ExternalVoucherDto config) {
        String key = "srm:base:third:token:" + ThirdTokenEnums.DING_TALK.getType() + ":" + busAccount;
        String token = (String)REDIS_UTIL.get(key);
        if (StrUtil.isNotBlank((CharSequence)token)) {
            return token;
        }
        String appid = config.getVoucherKey();
        String secret = config.getVoucherSecret();
        JSONObject object = new JSONObject();
        object.put((Object)"appkey", (Object)appid);
        object.put((Object)"appsecret", (Object)secret);
        String invokeUrl = ThirdTokenEnums.DING_TALK.getTokenUrl() + "?" + ThirdAuthUtil.getUrlParamByJson(object);
        String result = HttpUtil.get((String)invokeUrl);
        JSONObject resultObj = JSONObject.parseObject((String)result);
        if (!resultObj.containsKey("access_token")) {
            throw new ELSBootException(I18nUtil.translate((String)resultObj.getString("errmsg")));
        }
        token = resultObj.getString("access_token");
        int expiresIn = resultObj.getIntValue("expires_in");
        REDIS_UTIL.set(key, (Object)token, (long)(expiresIn - 5));
        return token;
    }

    public static String getFeiShuToken(String busAccount, ExternalVoucherDto config) {
        String key = "srm:base:third:token:" + ThirdTokenEnums.FEI_SHU.getType() + ":" + busAccount;
        String token = (String)REDIS_UTIL.get(key);
        if (StrUtil.isNotBlank((CharSequence)token)) {
            return token;
        }
        String appid = config.getVoucherKey();
        String secret = config.getVoucherSecret();
        JSONObject object = new JSONObject();
        object.put((Object)"app_id", (Object)appid);
        object.put((Object)"app_secret", (Object)secret);
        String result = HttpUtil.post((String)ThirdTokenEnums.FEI_SHU.getTokenUrl(), (String)object.toJSONString(new JSONWriter.Feature[0]));
        JSONObject resultObj = JSONObject.parseObject((String)result);
        if (!resultObj.containsKey("tenant_access_token")) {
            throw new ELSBootException(I18nUtil.translate((String)resultObj.getString("errmsg")));
        }
        token = resultObj.getString("tenant_access_token");
        int expiresIn = resultObj.getIntValue("expire");
        REDIS_UTIL.set(key, (Object)token, (long)(expiresIn - 5));
        return token;
    }

    public static void cleanThirdToken(String type, String busAccount) {
        ThirdTokenEnums enums = ThirdTokenEnums.buildType(type);
        if (null != enums) {
            String key = "srm:base:third:token:" + enums.getType() + ":" + busAccount;
            REDIS_UTIL.del(new String[]{key});
        }
    }

    public static String getAuthType(String type) {
        if ("dingtalk".equalsIgnoreCase(type)) {
            return "dingtalk_account";
        }
        if ("wechat_enterprise".equalsIgnoreCase(type)) {
            return "wechat_enterprise_web";
        }
        if ("wechat_enterprise_develop".equalsIgnoreCase(type)) {
            return "wechat_enterprise_develop_web";
        }
        return type;
    }

    public static String getAuthConfigType(String type) {
        if ("dingtalk_account".equalsIgnoreCase(type)) {
            return "dingtalk";
        }
        if ("wechat_enterprise_web".equalsIgnoreCase(type)) {
            return "wechat_enterprise";
        }
        if ("wechat_enterprise_develop_web".equalsIgnoreCase(type)) {
            return "wechat_enterprise_develop";
        }
        return type;
    }

    public static String rebuildSource(String source) {
        if ("wechat_enterprise_develop_web".equalsIgnoreCase(source)) {
            return "wechat_enterprise_web";
        }
        if ("wechat_enterprise_develop".equalsIgnoreCase(source)) {
            return "wechat_enterprise";
        }
        return source;
    }

    public static JSONObject createWechatMpTempTicket(String accessToken, String sceneStr, int expireSeconds) {
        JSONObject params = new JSONObject();
        params.put((Object)"access_token", (Object)accessToken);
        JSONObject data = new JSONObject();
        data.put((Object)"action_name", (Object)QRCodeConstant.QR_STR_SCENE.getCode());
        if (expireSeconds != 0) {
            data.put((Object)"expire_seconds", (Object)expireSeconds);
        }
        JSONObject scene = new JSONObject();
        scene.put((Object)"scene_str", (Object)sceneStr);
        JSONObject actionInfo = new JSONObject();
        actionInfo.put((Object)"scene", (Object)scene);
        data.put((Object)"action_info", (Object)actionInfo);
        String str = HttpUtil.post((String)("https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token=" + accessToken), (String)data.toJSONString(new JSONWriter.Feature[0]));
        return JSON.parseObject((String)str);
    }
}

