/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.handle.impl;

import cn.hutool.core.util.URLUtil;
import com.els.common.exception.ELSBootException;
import com.els.common.system.util.JwtUtil;
import com.els.common.util.I18nUtil;
import com.els.modules.email.core.SrmEmailBuilder;
import com.els.modules.message.entity.ElsMsgConfigItem;
import com.els.modules.message.handle.enums.SendMsgTypeEnum;
import com.els.modules.message.handle.impl.AbstractSendMsgImpl;
import com.els.modules.message.vo.MsgVO;
import com.els.modules.system.entity.ElsSubAccount;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EmailSendMsgImpl
extends AbstractSendMsgImpl {
    private static final Logger log = LoggerFactory.getLogger(EmailSendMsgImpl.class);

    @Override
    public void doSendMsg(MsgVO msg) {
        log.info("EmailSendMsgImpl\u51c6\u5907\u6267\u884c\u53d1\u9001\u90ae\u4ef6\u6d88\u606f\u7684\u903b\u8f91.");
        ElsMsgConfigItem configItem = msg.getConfigItem();
        if (null == configItem) {
            log.warn("EmailSendMsgImpl\u7f3a\u5c11\u90ae\u4ef6\u6d88\u606f\u914d\u7f6e");
            return;
        }
        ElsSubAccount receiveAccountInfo = msg.getReceiveAccountInfo();
        try {
            String msgContent = configItem.getMsgContent();
            String subject = configItem.getMsgTitle();
            String linkUrl = this.buildLinkUrl(msg.getBusinessObj(), configItem.getLinkUrl(), "", msg.getBusAccount(), msg.getReceiveAccountInfo());
            if (null != msg.getBusinessObj()) {
                msg.getBusinessObj().put((Object)"audthUrl", (Object)linkUrl);
            }
            msgContent = this.parseContentTemplateText("", msgContent, (Map<String, Object>)msg.getBusinessObj());
            subject = this.parseContentTemplateText("", subject, (Map<String, Object>)msg.getBusinessObj());
            SrmEmailBuilder.sendEmailToQueue(msg.getBusAccount(), new String[]{receiveAccountInfo.getEmail()}, subject, msgContent, "", null, null);
        }
        catch (Exception e) {
            log.error("EmailSendMsgImpl\u53d1\u9001\u90ae\u4ef6\u5931\u8d25:{}", (Object)e.getMessage());
            throw new ELSBootException(I18nUtil.translate((String)"\u6d88\u606f\u7ec4\u4ef6\u53d1\u9001\u6d88\u606f\u5931\u8d25"));
        }
    }

    @Override
    protected String getOauthUrl() {
        return this.getServiceBuilder() + "/user/login";
    }

    @Override
    protected String getUrl(String urlParam, String busAccount, ElsSubAccount accountInfo) {
        String routeUri = URLUtil.encodeAll((String)urlParam);
        return String.format(this.getOauthUrl(), busAccount) + "?redirect=" + routeUri + "&token=" + JwtUtil.getOutToken((String)accountInfo.getElsAccount(), (String)accountInfo.getSubAccount(), (String)accountInfo.getPassword());
    }

    @Override
    public String supportType() {
        return SendMsgTypeEnum.EMAIL.getType();
    }

    public static void main(String[] args) {
        String url = "/srm/bidding/sale/SaleBiddingHeadList?templateNumber=TC2021051401&templateVersion=1&id=1404452506648141826&busAccount=307000";
        System.out.println(URLUtil.encodeAll((String)url));
    }
}

