/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.handle.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson2.JSONObject;
import com.els.common.util.SpringContextUtils;
import com.els.modules.account.entity.ExternalAccount;
import com.els.modules.account.enums.ExternalVoucherTypeEnum;
import com.els.modules.account.service.ExternalAccountService;
import com.els.modules.integration.api.dto.ExternalVoucherDto;
import com.els.modules.justauth.util.ThirdAuthUtil;
import com.els.modules.message.entity.ElsMsgConfigItem;
import com.els.modules.message.handle.enums.SendMsgTypeEnum;
import com.els.modules.message.handle.impl.AbstractSendMsgImpl;
import com.els.modules.message.vo.MsgVO;
import com.els.modules.system.entity.ElsSubAccount;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WxEnterpriseSendMsgImpl
extends AbstractSendMsgImpl {
    private static final Logger log = LoggerFactory.getLogger(WxEnterpriseSendMsgImpl.class);

    protected String getType() {
        return ExternalVoucherTypeEnum.WECHAT_ENTERPRISE.getValue();
    }

    @Override
    public String supportType() {
        return SendMsgTypeEnum.WECHAT_ENTERPRISE.getType();
    }

    @Override
    public void doSendMsg(MsgVO msg) {
        log.info("WxEnterpriseSendMsgImpl\u51c6\u5907\u6267\u884c\u53d1\u9001\u4f01\u4e1a\u5fae\u4fe1\u6d88\u606f\u7684\u903b\u8f91.");
        ElsMsgConfigItem configItem = msg.getConfigItem();
        if (null == configItem) {
            log.warn("WxEnterpriseSendMsgImpl\u7f3a\u5c11\u4f01\u4e1a\u5fae\u4fe1\u6d88\u606f\u914d\u7f6e");
            return;
        }
        ElsSubAccount receiveAccountInfo = msg.getReceiveAccountInfo();
        ExternalAccountService externalAccountService = (ExternalAccountService)SpringContextUtils.getBean(ExternalAccountService.class);
        ExternalAccount externalAccount = externalAccountService.getEnableAccount(receiveAccountInfo.getElsAccount(), receiveAccountInfo.getId());
        if (null == externalAccount) {
            log.warn("WxEnterpriseSendMsgImpl receive not bind " + this.getType());
            return;
        }
        ExternalVoucherDto config = this.getJustConfig(receiveAccountInfo.getElsAccount(), this.getType());
        if (null == config || StrUtil.isEmpty((CharSequence)config.getVoucherKey()) || StrUtil.isEmpty((CharSequence)config.getVoucherAgentId())) {
            log.error(":::\u4f01\u4e1a\u5fae\u4fe1\u7b2c\u4e09\u65b9\u914d\u7f6e\u4e0d\u5b58\u5728,elsAccount:{}", (Object)receiveAccountInfo.getElsAccount());
            return;
        }
        try {
            String urlString = "https://qyapi.weixin.qq.com/cgi-bin/message/send?access_token=" + ThirdAuthUtil.getWechatEnterpriseToken(config.getElsAccount(), config);
            JSONObject body = new JSONObject();
            body.put((Object)"agentid", (Object)config.getVoucherAgentId());
            body.put((Object)"msgtype", (Object)"textcard");
            JSONObject textcard = new JSONObject();
            textcard.put((Object)"btntxt", (Object)"");
            String linkUrl = this.buildLinkUrl(msg.getBusinessObj(), configItem.getLinkUrl(), "", msg.getBusAccount(), msg.getReceiveAccountInfo());
            textcard.put((Object)"url", (Object)linkUrl);
            String msgContent = this.parseContentTemplateText("", configItem.getMsgContent(), (Map<String, Object>)msg.getBusinessObj());
            textcard.put((Object)"description", (Object)msgContent);
            String msgTitle = this.parseContentTemplateText("", configItem.getMsgTitle(), (Map<String, Object>)msg.getBusinessObj());
            textcard.put((Object)"title", (Object)msgTitle);
            body.put((Object)"textcard", (Object)textcard);
            body.put((Object)"touser", (Object)externalAccount.getExternalAccountId());
            String result = HttpUtil.post((String)urlString, (String)body.toString());
            log.info(":::WxEnterpriseSendMsgImpl send message result:{}", (Object)result);
        }
        catch (Exception e) {
            log.error("WxEnterpriseSendMsgImpl\u4f01\u4e1a\u5fae\u4fe1\u53d1\u9001\u6d88\u606f\u5f02\u5e38:{}", (Object)e.getMessage());
        }
    }

    @Override
    protected String getOauthUrl() {
        return "/els/base/thirdLogin/loadQrCode/%s/mobile/wechat_enterprise_web";
    }
}

