/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.handle.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.els.common.trace.TraceIdHolder;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SrmUtil;
import com.els.modules.integration.api.dto.ExternalVoucherDto;
import com.els.modules.justauth.util.ThirdAuthUtil;
import com.els.modules.message.entity.ElsMsgConfigItem;
import com.els.modules.message.handle.enums.SendMsgTypeEnum;
import com.els.modules.message.handle.impl.WxSendMsgImpl;
import com.els.modules.message.vo.MsgVO;
import com.els.modules.system.entity.ElsSubAccount;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class WxGroupSendMsgImpl
extends WxSendMsgImpl {
    private static final Logger log = LoggerFactory.getLogger(WxGroupSendMsgImpl.class);

    @Override
    public String supportType() {
        return SendMsgTypeEnum.WE_CHAT_GROUP.getType();
    }

    @Override
    public void doSendMsg(MsgVO msg) {
        log.info("WxGroupSendMsgImpl \u51c6\u5907\u6267\u884c\u53d1\u9001\u5fae\u4fe1\u6d88\u606f\u7684\u903b\u8f91.");
        ElsMsgConfigItem configItem = msg.getConfigItem();
        if (null == configItem) {
            log.error("WxGroupSendMsgImpl\u5f53\u524d\u8d26\u53f7:{}\u6ca1\u6709\u914d\u7f6e{}\u7684\u6d88\u606f\u53d1\u9001\u7c7b\u578b\u914d\u7f6e", (Object)msg.getBusAccount(), (Object)"WECHAT_GROUP_SEND");
            return;
        }
        if (StrUtil.isBlank((CharSequence)configItem.getTemplateNumber())) {
            log.error(":::WxGroupSendMsgImpl\u5f53\u524d\u8d26\u53f7:{}\u7fa4\u53d1\u516c\u4f17\u53f7\u6a21\u7248\u6d88\u606f\u7684\u914d\u7f6e\u6ca1\u6709\u914d\u7f6e\u6a21\u677f\u53f7...", (Object)msg.getBusAccount());
            return;
        }
        ElsSubAccount receiveAccountInfo = msg.getReceiveAccountInfo();
        ExternalVoucherDto config = this.getJustConfig(receiveAccountInfo.getElsAccount(), "wechat_mp");
        if (null == config || StrUtil.isEmpty((CharSequence)config.getVoucherKey()) || StrUtil.isEmpty((CharSequence)config.getVoucherAgentId())) {
            log.error(":::\u516c\u4f17\u53f7\u914d\u7f6e\u4e0d\u5b58\u5728,elsAccount:{}", (Object)receiveAccountInfo.getElsAccount());
            return;
        }
        ArrayList openIdList = new ArrayList();
        String nextOpenid = "";
        while (true) {
            String errmsg;
            String userUrl;
            String userResult;
            JSONObject userJson;
            if ((userJson = JSONObject.parseObject((String)(userResult = HttpUtil.get((String)(userUrl = "https://api.weixin.qq.com/cgi-bin/user/get?access_token=" + ThirdAuthUtil.getWechatMpToken(config.getElsAccount(), config) + "&&next_openid=" + nextOpenid))))).containsKey("errmsg") && CharSequenceUtil.isNotEmpty((CharSequence)(errmsg = userJson.getString("errmsg"))) && errmsg.contains("invalid credential")) {
                ((RedisUtil)SpringContextUtils.getBean(RedisUtil.class)).del(new String[]{"sys:thirdToken:weixin_mp:" + config.getElsAccount()});
                userUrl = "https://api.weixin.qq.com/cgi-bin/user/get?access_token=" + ThirdAuthUtil.getWechatMpToken(config.getElsAccount(), config) + "&&next_openid=" + nextOpenid;
                userResult = HttpUtil.get((String)userUrl);
                userJson = JSONObject.parseObject((String)userResult);
                log.error(":::WxGroupSendMsgImpl userResult2:{}", (Object)userResult);
            }
            int total = userJson.getInteger("total");
            Integer count = userJson.getInteger("count");
            if (null == count) {
                count = 0;
            }
            nextOpenid = userJson.getString("next_openid");
            if (count <= 0) break;
            JSONObject data = userJson.getJSONObject("data");
            JSONArray openids = data.getJSONArray("openid");
            List resultList = openids.toJavaList(String.class, new JSONReader.Feature[0]);
            openIdList.addAll(resultList);
        }
        log.error(":::WxGroupSendMsgImpl openIdList size:{}", (Object)openIdList.size());
        if (CollectionUtil.isNotEmpty(openIdList)) {
            ThreadPoolTaskExecutor theadPool = SrmUtil.getTheadPool();
            String traceId = TraceIdHolder.get();
            for (String openId : openIdList) {
                theadPool.execute(() -> {
                    try {
                        TraceIdHolder.init();
                        TraceIdHolder.set((String)traceId);
                        this.send(msg, configItem, config, openId);
                    }
                    catch (Exception e) {
                        log.error("WxGroupSendMsgImpl.doSendMsg \u5fae\u4fe1\u53d1\u9001\u6d88\u606f\u5f02\u5e38:", (Throwable)e);
                    }
                    finally {
                        TraceIdHolder.remove();
                    }
                });
            }
        }
    }

    @Override
    protected String getOauthUrl() {
        return "/els/base/thirdLogin/loadQrCode/%s/mobile/wechat_mp";
    }
}

