/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.notice.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.notice.entity.SaleNotice;
import com.els.modules.notice.service.SaleNoticeService;
import com.els.modules.notice.vo.SaleNoticeVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/notice/saleNotice"})
@Tag(name="\u91c7\u8d2d\u516c\u544a")
public class SaleNoticeController
extends BaseController<SaleNotice, SaleNoticeService> {
    private static final Logger log = LoggerFactory.getLogger(SaleNoticeController.class);
    @Autowired
    private SaleNoticeService saleNoticeService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"saleNotice#SaleNotice:list"})
    public Result<?> queryPageList(SaleNotice saleNotice, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleNotice), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.saleNoticeService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"saleNotice#SaleNotice:add"})
    public Result<?> add(@RequestBody SaleNoticeVO saleNoticePage) {
        SaleNotice saleNotice = new SaleNotice();
        BeanUtils.copyProperties((Object)((Object)saleNoticePage), (Object)((Object)saleNotice));
        this.saleNoticeService.saveMain(saleNotice, saleNoticePage.getSaleAttachmentList());
        return Result.ok((Object)((Object)saleNotice));
    }

    @SrmValidated
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"saleNotice#SaleNotice:edit"})
    public Result<?> edit(@RequestBody SaleNoticeVO saleNoticePage) {
        SaleNotice saleNotice = new SaleNotice();
        BeanUtils.copyProperties((Object)((Object)saleNoticePage), (Object)((Object)saleNotice));
        this.saleNoticeService.updateMain(saleNotice, saleNoticePage.getSaleAttachmentList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u901a\u8fc7id\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"saleNotice#SaleNotice:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.saleNoticeService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u6279\u91cf\u5220\u9664")
    @Operation(summary="\u6279\u91cf\u5220\u9664", description="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"saleNotice#SaleNotice:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.saleNoticeService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"saleNotice#SaleNotice:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        SaleNotice saleNotice = (SaleNotice)((Object)this.saleNoticeService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        SaleNoticeVO saleNoticeVO = new SaleNoticeVO();
        BeanUtils.copyProperties((Object)((Object)saleNotice), (Object)((Object)saleNoticeVO));
        List saleAttachmentList = this.invokeBaseRpcService.selectSaleAttachmentByMainId(id);
        saleNoticeVO.setSaleAttachmentList(saleAttachmentList);
        return Result.ok((Object)((Object)saleNoticeVO));
    }

    @Operation(summary="\u901a\u8fc7\u91c7\u8d2d\u516c\u544aid\u67e5\u8be2\u9644\u4ef6\u5217\u8868", description="\u901a\u8fc7\u91c7\u8d2d\u516c\u544aid\u67e5\u8be2\u9644\u4ef6\u5217\u8868")
    @GetMapping(value={"/querySaleAttachmentByMainId"})
    @RequiresPermissions(value={"saleNotice#SaleNotice:list"})
    public Result<?> querySaleAttachmentListByMainId(@RequestParam(name="id") String id) {
        List saleAttachmentList = this.invokeBaseRpcService.selectSaleAttachmentByMainId(id);
        return Result.ok((Object)saleAttachmentList);
    }
}

