/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.survey.adapter;

import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.SrmUtil;
import com.els.modules.survey.entity.PurchaseSurveyAnswer;
import com.els.modules.survey.entity.PurchaseSurveyHead;
import com.els.modules.survey.entity.PurchaseSurveyLibrary;
import com.els.modules.survey.service.PurchaseSurveyAnswerService;
import com.els.modules.survey.service.PurchaseSurveyHeadService;
import com.els.modules.survey.service.PurchaseSurveyLibraryService;
import com.els.modules.survey.vo.PurchaseSurveyHeadVO;
import com.els.srm.workflow.modules.dto.FlowCallBackDTO;
import com.els.srm.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="publishSurveyAuditAdapter")
public class PublishSurveyAdapter
implements WorkflowAuditOptCallBackService {
    @Autowired
    private PurchaseSurveyHeadService purchaseSurveyHeadService;
    @Autowired
    private PurchaseSurveyLibraryService purchaseSurveyLibraryService;
    @Autowired
    private PurchaseSurveyAnswerService purchaseSurveyAnswerService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
        PurchaseSurveyHeadVO headVO = new PurchaseSurveyHeadVO();
        String id = flowCallbackDTO.getBusinessId();
        PurchaseSurveyHead dbHead = (PurchaseSurveyHead)((Object)this.purchaseSurveyHeadService.getById((Serializable)((Object)id)));
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
        List<PurchaseSurveyLibrary> libraryList = this.purchaseSurveyLibraryService.selectByMainId(id);
        List<PurchaseSurveyAnswer> answerList = this.purchaseSurveyAnswerService.selectByMainId(id);
        this.purchaseSurveyHeadService.publish(headVO, libraryList, answerList);
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String businessId) {
        PurchaseSurveyHead head = (PurchaseSurveyHead)((Object)this.purchaseSurveyHeadService.getById((Serializable)((Object)businessId)));
        return SrmUtil.toJSONObject((Object)((Object)head));
    }

    private void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        PurchaseSurveyHead updateHead = new PurchaseSurveyHead();
        updateHead.setAuditStatus(auditStatus);
        updateHead.setFlowId(flowCallbackDTO.getProcessInstanceId());
        updateHead.setId(flowCallbackDTO.getBusinessId());
        this.purchaseSurveyHeadService.updateById((Object)updateHead);
    }
}

